/*
 * Decompiled with CFR 0.152.
 */
package net.quumi.mwtab.net.packets;

import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.network.PacketBuffer;
import net.quumi.mwtab.base.TabListPlayerEntry;
import net.quumi.mwtab.core.TabListData;
import net.quumi.mwtab.net.BaseHandler;
import net.quumi.mwtab.net.BasePacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004\u00a8\u0006\u000f"}, d2={"Lnet/quumi/mwtab/net/packets/S2CJoinedPacket;", "Lnet/quumi/mwtab/net/BasePacket;", "player", "Lnet/quumi/mwtab/base/TabListPlayerEntry;", "(Lnet/quumi/mwtab/base/TabListPlayerEntry;)V", "()V", "getPlayer", "()Lnet/quumi/mwtab/base/TabListPlayerEntry;", "setPlayer", "fromBytes", "", "buffer", "Lnet/minecraft/network/PacketBuffer;", "toBytes", "Handler", "adapt-1.7.10"})
public final class S2CJoinedPacket
extends BasePacket {
    public TabListPlayerEntry player;

    public S2CJoinedPacket() {
    }

    @NotNull
    public final TabListPlayerEntry getPlayer() {
        TabListPlayerEntry tabListPlayerEntry = this.player;
        if (tabListPlayerEntry != null) {
            return tabListPlayerEntry;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"player");
        return null;
    }

    public final void setPlayer(@NotNull TabListPlayerEntry tabListPlayerEntry) {
        Intrinsics.checkNotNullParameter((Object)tabListPlayerEntry, (String)"<set-?>");
        this.player = tabListPlayerEntry;
    }

    public S2CJoinedPacket(@NotNull TabListPlayerEntry player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this();
        this.setPlayer(player);
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        String name = buffer.func_150789_c(Short.MAX_VALUE);
        String prefix = buffer.func_150789_c(Short.MAX_VALUE);
        int gradientStart = buffer.readInt();
        int gradientTo = buffer.readInt();
        int weight = buffer.readInt();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)prefix, (String)"prefix");
        this.setPlayer(new TabListPlayerEntry(name, prefix, gradientStart, gradientTo, weight));
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.func_150785_a(this.getPlayer().getName());
        buffer.func_150785_a(this.getPlayer().getPrefix());
        buffer.writeInt(this.getPlayer().getGradientFrom());
        buffer.writeInt(this.getPlayer().getGradientTo());
        buffer.writeInt(this.getPlayer().getListWeight());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/quumi/mwtab/net/packets/S2CJoinedPacket$Handler;", "Lnet/quumi/mwtab/net/BaseHandler;", "Lnet/quumi/mwtab/net/packets/S2CJoinedPacket;", "()V", "handleClientThread", "", "message", "playerSP", "Lnet/minecraft/client/entity/EntityPlayerSP;", "ctx", "Lcpw/mods/fml/common/network/simpleimpl/MessageContext;", "adapt-1.7.10"})
    public static final class Handler
    extends BaseHandler<S2CJoinedPacket> {
        @Override
        public void handleClientThread(@NotNull S2CJoinedPacket message, @Nullable EntityPlayerSP playerSP, @Nullable MessageContext ctx) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            TabListData.INSTANCE.playerJoin(message.getPlayer());
        }
    }
}

