/*
 * Decompiled with CFR 0.152.
 */
package net.quumi.mwtab.server;

import by.fxg.pluginforgery.api.essentials.BaltopEntry;
import by.fxg.pluginforgery.api.ow.OnlineRecordTop;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.quumi.mwtab.base.TabListPlayerEntry;
import net.quumi.mwtab.base.TopsListPlayerEntry;
import net.quumi.mwtab.net.NetworkManager;
import net.quumi.mwtab.net.packets.S2CClearPacket;
import net.quumi.mwtab.net.packets.S2CJoinedPacket;
import net.quumi.mwtab.net.packets.S2CLeftPacket;
import net.quumi.mwtab.net.packets.S2CMetricsPacket;
import net.quumi.mwtab.net.packets.S2CTopsPacket;
import net.quumi.mwtab.server.PluginForgeryManager;
import net.quumi.mwtab.server.ServerDataHandler;
import net.quumi.mwtab.warcrimes.ClamperHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0015H\u0007J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0006\u0010\u001a\u001a\u00020\nJ\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnet/quumi/mwtab/server/ServerHandler;", "", "()V", "balanceFormat", "Ljava/text/DecimalFormat;", "lastTick", "", "tick", "", "addPlayer", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "getProfileForPlayer", "Lnet/quumi/mwtab/base/TabListPlayerEntry;", "onPlayerJoin", "event", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerLoggedInEvent;", "onPlayerLeave", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerLoggedOutEvent;", "onTick", "Lcpw/mods/fml/common/gameevent/TickEvent$ServerTickEvent;", "refreshProfile", "removePlayer", "syncServerMetrics", "msSinceLastTick", "syncTopsGlobal", "syncTopsToOne", "to", "timeConvert", "", "time", "", "adapt-1.7.10"})
@SourceDebugExtension(value={"SMAP\nServerHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerHandler.kt\nnet/quumi/mwtab/server/ServerHandler\n+ 2 NotCutter.kt\nnet/quumi/mwtab/warcrimes/NotCutterKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,173:1\n5#2,2:174\n5#2,2:176\n5#2,2:178\n5#2,2:180\n5#2:182\n6#2:203\n5#2:204\n6#2:225\n5#2,2:226\n5#2:228\n6#2:231\n5#2,2:232\n10#2:234\n10#2:235\n766#3:183\n857#3,2:184\n1045#3:186\n1549#3:187\n1620#3,3:188\n766#3:193\n857#3,2:194\n1045#3:196\n1549#3:197\n1620#3,3:198\n766#3:205\n857#3,2:206\n1045#3:208\n1549#3:209\n1620#3,3:210\n766#3:215\n857#3,2:216\n1045#3:218\n1549#3:219\n1620#3,3:220\n1855#3,2:229\n37#4,2:191\n37#4,2:201\n37#4,2:213\n37#4,2:223\n*S KotlinDebug\n*F\n+ 1 ServerHandler.kt\nnet/quumi/mwtab/server/ServerHandler\n*L\n31#1:174,2\n39#1:176,2\n45#1:178,2\n64#1:180,2\n69#1:182\n69#1:203\n88#1:204\n88#1:225\n107#1:226,2\n116#1:228\n116#1:231\n129#1:232,2\n133#1:234\n167#1:235\n71#1:183\n71#1:184,2\n72#1:186\n73#1:187\n73#1:188,3\n78#1:193\n78#1:194,2\n79#1:196\n80#1:197\n80#1:198,3\n90#1:205\n90#1:206,2\n91#1:208\n92#1:209\n92#1:210,3\n97#1:215\n97#1:216,2\n98#1:218\n99#1:219\n99#1:220,3\n124#1:229,2\n75#1:191,2\n82#1:201,2\n94#1:213,2\n101#1:223,2\n*E\n"})
public final class ServerHandler {
    @NotNull
    public static final ServerHandler INSTANCE;
    @NotNull
    private static final DecimalFormat balanceFormat;
    private static int tick;
    private static double lastTick;

    private ServerHandler() {
    }

    @SubscribeEvent
    public final void onPlayerJoin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean $i$f$serverCode = false;
        boolean bl = false;
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayer entityPlayer = event.player;
        Intrinsics.checkNotNull((Object)entityPlayer, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        INSTANCE.addPlayer(player);
    }

    @SubscribeEvent
    public final void onPlayerLeave(@NotNull PlayerEvent.PlayerLoggedOutEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean $i$f$serverCode = false;
        boolean bl = false;
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayer entityPlayer = event.player;
        Intrinsics.checkNotNull((Object)entityPlayer, (String)"null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
        INSTANCE.removePlayer((EntityPlayerMP)entityPlayer);
    }

    @SubscribeEvent
    public final void onTick(@NotNull TickEvent.ServerTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean $i$f$serverCode = false;
        boolean bl = false;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.type != TickEvent.Type.SERVER) {
            return;
        }
        if (event.side != Side.SERVER) {
            return;
        }
        long thisTick = System.currentTimeMillis();
        if (lastTick > 0.0) {
            double diffMs = (double)thisTick - lastTick;
            INSTANCE.syncServerMetrics(diffMs);
        }
        int n = tick;
        tick = n + 1;
        if (n % 20 * 60 * 5 == 0) {
            INSTANCE.syncTopsGlobal();
        }
        lastTick = thisTick;
    }

    public final void refreshProfile(@NotNull EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean $i$f$serverCode = false;
        boolean bl = false;
        INSTANCE.removePlayer(player);
        INSTANCE.addPlayer(player);
    }

    /*
     * WARNING - void declaration
     */
    public final void syncTopsGlobal() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Iterable $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        OnlineRecordTop it;
        Iterable $this$filterTo$iv$iv2;
        boolean $i$f$serverCode = false;
        boolean bl = false;
        List<OnlineRecordTop> list = PluginForgeryManager.INSTANCE.getForgeryOnlineWatcher().getOnlineTop();
        Intrinsics.checkNotNullExpressionValue(list, (String)"PluginForgeryManager.for\u2026ryOnlineWatcher.onlineTop");
        Iterable $this$filter$iv2 = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (OnlineRecordTop)element$iv$iv;
            boolean bl2 = false;
            if (!(!ServerDataHandler.INSTANCE.getOnlineTopBlock().contains(it.getPlayerName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv2 = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                OnlineRecordTop it = (OnlineRecordTop)a;
                boolean bl = false;
                boolean $i$f$typedServerCode = false;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getRank());
                it = (OnlineRecordTop)b;
                Comparable comparable2 = comparable;
                bl = false;
                $i$f$typedServerCode = false;
                bl2 = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRank()));
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (OnlineRecordTop)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            String string = it.getPlayerName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.playerName");
            collection.add(new TopsListPlayerEntry(string, INSTANCE.timeConvert(it.getOnline())));
        }
        Collection $this$toTypedArray$iv2 = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)3);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv2;
        TopsListPlayerEntry[] onlineTop = thisCollection$iv.toArray(new TopsListPlayerEntry[0]);
        Iterable $i$f$toTypedArray22 = PluginForgeryManager.INSTANCE.getForgeryBalance().getBalanceTop().values();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BaltopEntry it2 = (BaltopEntry)element$iv$iv;
            boolean bl4 = false;
            if (!(!ServerDataHandler.INSTANCE.getBalanceTopBlock().contains(it2.getDisplayName()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy2 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BaltopEntry it = (BaltopEntry)a;
                boolean bl = false;
                boolean $i$f$typedServerCode = false;
                boolean bl2 = false;
                BigDecimal bigDecimal = it.getBalance();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"it.balance");
                BigDecimal bigDecimal2 = bigDecimal.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"this.negate()");
                it = (BaltopEntry)b;
                Comparable comparable = bigDecimal2;
                bl = false;
                $i$f$typedServerCode = false;
                bl2 = false;
                BigDecimal bigDecimal3 = it.getBalance();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"it.balance");
                BigDecimal bigDecimal4 = bigDecimal3.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"this.negate()");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)bigDecimal4);
            }
        });
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BaltopEntry it2 = (BaltopEntry)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            String string = it2.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.displayName");
            collection.add(new TopsListPlayerEntry(string, balanceFormat.format(it2.getBalance()) + '$'));
        }
        $this$map$iv = CollectionsKt.take((Iterable)((List)destination$iv$iv2), (int)3);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv2 = $this$toTypedArray$iv;
        TopsListPlayerEntry[] moneyTop = thisCollection$iv2.toArray(new TopsListPlayerEntry[0]);
        NetworkManager.INSTANCE.getManager().sendToAll((IMessage)new S2CTopsPacket(moneyTop, onlineTop));
    }

    /*
     * WARNING - void declaration
     */
    private final void syncTopsToOne(EntityPlayerMP to) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Iterable $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$toTypedArray$iv2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Collection $this$map$iv2;
        Iterable $this$sortedBy$iv2;
        OnlineRecordTop it;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        boolean $i$f$serverCode = false;
        boolean bl = false;
        List<OnlineRecordTop> list = PluginForgeryManager.INSTANCE.getForgeryOnlineWatcher().getOnlineTop();
        Intrinsics.checkNotNullExpressionValue(list, (String)"PluginForgeryManager.for\u2026ryOnlineWatcher.onlineTop");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (OnlineRecordTop)element$iv$iv;
            boolean bl2 = false;
            if (!(!ServerDataHandler.INSTANCE.getOnlineTopBlock().contains(it.getPlayerName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                OnlineRecordTop it = (OnlineRecordTop)a;
                boolean bl = false;
                boolean $i$f$typedServerCode = false;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getRank());
                it = (OnlineRecordTop)b;
                Comparable comparable2 = comparable;
                bl = false;
                $i$f$typedServerCode = false;
                bl2 = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRank()));
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (OnlineRecordTop)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            String string = it.getPlayerName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.playerName");
            collection.add(new TopsListPlayerEntry(string, INSTANCE.timeConvert(it.getOnline())));
        }
        $this$map$iv2 = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)3);
        boolean $i$f$toTypedArray22 = false;
        void thisCollection$iv = $this$toTypedArray$iv2;
        TopsListPlayerEntry[] onlineTop = thisCollection$iv.toArray(new TopsListPlayerEntry[0]);
        Iterable $i$f$toTypedArray22 = PluginForgeryManager.INSTANCE.getForgeryBalance().getBalanceTop().values();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BaltopEntry it2 = (BaltopEntry)element$iv$iv;
            boolean bl4 = false;
            if (!(!ServerDataHandler.INSTANCE.getBalanceTopBlock().contains(it2.getDisplayName()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy2 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BaltopEntry it = (BaltopEntry)a;
                boolean bl = false;
                boolean $i$f$typedServerCode = false;
                boolean bl2 = false;
                Comparable comparable = it.getBalance();
                it = (BaltopEntry)b;
                Comparable comparable2 = comparable;
                bl = false;
                $i$f$typedServerCode = false;
                bl2 = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getBalance());
            }
        });
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BaltopEntry it2 = (BaltopEntry)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            String string = it2.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.displayName");
            collection.add(new TopsListPlayerEntry(string, balanceFormat.format(it2.getBalance()) + '$'));
        }
        $this$map$iv = CollectionsKt.take((Iterable)((List)destination$iv$iv2), (int)3);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv2 = $this$toTypedArray$iv;
        TopsListPlayerEntry[] moneyTop = thisCollection$iv2.toArray(new TopsListPlayerEntry[0]);
        NetworkManager.INSTANCE.getManager().sendTo((IMessage)new S2CTopsPacket(moneyTop, onlineTop), to);
    }

    private final void syncServerMetrics(double msSinceLastTick) {
        boolean $i$f$serverCode = false;
        boolean bl = false;
        NetworkManager.INSTANCE.getManager().sendToAll((IMessage)new S2CMetricsPacket(ClamperHelper.INSTANCE.clamp(0, 20, (int)((double)1000L / msSinceLastTick)), System.currentTimeMillis(), MinecraftServer.func_71276_C().func_71275_y(), ServerDataHandler.INSTANCE.getBranchName()));
    }

    private final void addPlayer(EntityPlayerMP player) {
        boolean $i$f$serverCode = false;
        boolean bl = false;
        NetworkManager.INSTANCE.getManager().sendToAll((IMessage)new S2CJoinedPacket(INSTANCE.getProfileForPlayer(player)));
        NetworkManager.INSTANCE.getManager().sendTo((IMessage)new S2CClearPacket(), player);
        INSTANCE.syncTopsToOne(player);
        List list = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<net.minecraft.entity.player.EntityPlayerMP>");
        List onlinePlayers = list;
        Iterable $this$forEach$iv = onlinePlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityPlayerMP it = (EntityPlayerMP)element$iv;
            boolean bl2 = false;
            NetworkManager.INSTANCE.getManager().sendTo((IMessage)new S2CJoinedPacket(INSTANCE.getProfileForPlayer(it)), player);
        }
    }

    private final void removePlayer(EntityPlayerMP player) {
        boolean $i$f$serverCode = false;
        boolean bl = false;
        NetworkManager.INSTANCE.getManager().sendToAll((IMessage)new S2CLeftPacket(INSTANCE.getProfileForPlayer(player)));
    }

    private final String timeConvert(long time) {
        boolean $i$f$typedServerCode = false;
        boolean bl = false;
        long opTime = time;
        String str = "";
        long months = TimeUnit.SECONDS.toDays(opTime) >= 30L ? TimeUnit.SECONDS.toDays(opTime) / 30L : 0L;
        long weeks = TimeUnit.SECONDS.toDays(opTime -= months * 30L * 86400L) >= 7L ? TimeUnit.SECONDS.toDays(opTime) / 7L : 0L;
        long days = TimeUnit.SECONDS.toDays(opTime -= weeks * 7L * 86400L);
        long hours = TimeUnit.SECONDS.toHours(opTime -= days * 86400L);
        long minutes = TimeUnit.SECONDS.toMinutes(opTime -= hours * 3600L);
        opTime -= minutes * 60L;
        if (months > 0L) {
            str = str + months + " \u043c\u0435\u0441. ";
        }
        if (weeks > 0L) {
            str = str + weeks + " \u043d\u0435\u0434. ";
        }
        if (days > 0L) {
            str = str + days + " \u0434\u043d. ";
        }
        if (hours > 0L) {
            str = str + hours + " \u0447. ";
        }
        if (minutes > 0L) {
            str = str + minutes + " \u043c\u0438\u043d. ";
        }
        if (((CharSequence)str).length() == 0) {
            str = "0 \u0441\u0435\u043a. ";
        }
        return str;
    }

    private final TabListPlayerEntry getProfileForPlayer(EntityPlayerMP player) {
        String string;
        String string2;
        boolean $i$f$typedServerCode = false;
        boolean bl = false;
        String world = player.field_70170_p.field_73011_w.func_80007_l();
        String string3 = string2 = PluginForgeryManager.INSTANCE.getForgeryPermissions().getPrimaryGroup(world, player.func_110124_au());
        if (string3 == null) {
            string = "unknown_group";
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PluginForgeryManager.for\u2026queID) ?: \"unknown_group\"");
            string = string2;
        }
        String group = string;
        String string4 = player.func_70005_c_();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"player.commandSenderName");
        String string5 = PluginForgeryManager.INSTANCE.getForgeryChat().getPlayerPrefix(world, player.func_110124_au());
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"PluginForgeryManager.for\u2026x(world, player.uniqueID)");
        return ServerDataHandler.INSTANCE.getProfileDisplay(string4, group, string5);
    }

    static {
        DecimalFormat decimalFormat;
        INSTANCE = new ServerHandler();
        DecimalFormat $this$balanceFormat_u24lambda_u240 = decimalFormat = new DecimalFormat();
        boolean bl = false;
        $this$balanceFormat_u24lambda_u240.setMaximumFractionDigits(0);
        balanceFormat = decimalFormat;
    }
}

