/*
 * Decompiled with CFR 0.152.
 */
package com.elpiksan.mwtechnology.common.block;

import com.denfop.utils.WrenchChecker;
import com.elpiksan.mwtechnology.CreativeTab;
import com.elpiksan.mwtechnology.common.tile.tileMechanisms.TileEntityCosmicMatter;
import com.elpiksan.mwtechnology.common.tile.tileMechanisms.TileEntityHeavenlyMatter;
import com.elpiksan.mwtechnology.common.tile.tileMechanisms.TileEntityInfiniteMatter;
import com.elpiksan.mwtechnology.common.tile.tileMechanisms.TileEntityNaturalMatter;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterGenerator
extends BlockContainer {
    public final String id;

    public MatterGenerator(String id) {
        super(Material.field_151573_f);
        this.id = id;
        this.func_149663_c(id);
        this.func_149711_c(2.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(CreativeTab.INSTANCE);
        this.func_149715_a(0.0f);
    }

    public void func_149651_a(IIconRegister iconRegister) {
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int i) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (this.id) {
            case "naturalMatter": {
                return new TileEntityNaturalMatter();
            }
            case "heavenlyMatter": {
                return new TileEntityHeavenlyMatter();
            }
            case "cosmicMatter": {
                return new TileEntityCosmicMatter();
            }
            case "infiniteMatter": {
                return new TileEntityInfiniteMatter();
            }
        }
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        if (!entityPlayer.func_70093_af() && WrenchChecker.isWrenchInHand((EntityPlayer)entityPlayer)) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityNaturalMatter) {
            return !IC2.platform.isSimulating() || IC2.platform.launchGui(entityPlayer, (IHasGui)((TileEntityNaturalMatter)tileEntity));
        }
        if (tileEntity instanceof TileEntityHeavenlyMatter) {
            return !IC2.platform.isSimulating() || IC2.platform.launchGui(entityPlayer, (IHasGui)((TileEntityHeavenlyMatter)tileEntity));
        }
        if (tileEntity instanceof TileEntityCosmicMatter) {
            return !IC2.platform.isSimulating() || IC2.platform.launchGui(entityPlayer, (IHasGui)((TileEntityCosmicMatter)tileEntity));
        }
        if (tileEntity instanceof TileEntityInfiniteMatter) {
            return !IC2.platform.isSimulating() || IC2.platform.launchGui(entityPlayer, (IHasGui)((TileEntityInfiniteMatter)tileEntity));
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_149689_a(world, x, y, z, player, stack);
        int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        short facing = 0;
        switch (heading) {
            case 0: {
                facing = 2;
                break;
            }
            case 1: {
                facing = 5;
                break;
            }
            case 2: {
                facing = 3;
                break;
            }
            case 3: {
                facing = 4;
            }
        }
        TileEntityBlock te = (TileEntityBlock)world.func_147438_o(x, y, z);
        if (te != null) {
            te.setFacing(facing);
            world.func_147471_g(x, y, z);
        }
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        int newFacing;
        IWrenchable te;
        TileEntity tileEntity;
        if (axis != ForgeDirection.UNKNOWN && (tileEntity = worldObj.func_147438_o(x, y, z)) instanceof IWrenchable && (te = (IWrenchable)tileEntity).wrenchCanSetFacing(null, newFacing = ForgeDirection.getOrientation((int)te.getFacing()).getRotation(axis).ordinal())) {
            te.setFacing((short)newFacing);
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityNaturalMatter) {
            ((TileEntityNaturalMatter)tile).onNeighborUpdate(block);
        }
        if (tile instanceof TileEntityHeavenlyMatter) {
            ((TileEntityHeavenlyMatter)tile).onNeighborUpdate(block);
        }
        if (tile instanceof TileEntityCosmicMatter) {
            ((TileEntityCosmicMatter)tile).onNeighborUpdate(block);
        }
        if (tile instanceof TileEntityInfiniteMatter) {
            ((TileEntityInfiniteMatter)tile).onNeighborUpdate(block);
        }
    }
}

