/*
 * Decompiled with CFR 0.152.
 */
package com.elpiksan.mwtechnology.common.invslot;

import com.elpiksan.mwtechnology.common.util.TaskScheduler;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotOutput;
import java.util.concurrent.TimeUnit;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AutoOutput {
    private boolean isProcessing = false;

    public void autoOutput(TileEntity tileEntity, InvSlotOutput outputSlot) {
        if (tileEntity == null || tileEntity.func_145831_w().field_72995_K || this.isProcessing) {
            return;
        }
        this.isProcessing = true;
        TaskScheduler.getInstance().schedule(task -> {
            boolean itemsTransferred = this.autoTransfer(outputSlot, tileEntity);
            if (!outputSlot.isEmpty()) {
                itemsTransferred = true;
            }
            if (!itemsTransferred) {
                this.isProcessing = false;
                task.markAsRemoved();
            }
        }, 50L, TimeUnit.MILLISECONDS, true);
    }

    public boolean autoTransfer(InvSlotOutput outputSlot, TileEntity tileEntity) {
        boolean itemsTransferred = false;
        if (!outputSlot.isEmpty()) {
            itemsTransferred = this.transferItemsFromSlot((InvSlot)outputSlot, tileEntity);
        }
        return itemsTransferred;
    }

    private boolean transferItemsFromSlot(InvSlot outputSlot, TileEntity tileEntity) {
        boolean itemsTransferred = false;
        for (int i = 0; i < outputSlot.size(); ++i) {
            ItemStack stack = outputSlot.get(i);
            if (stack == null || stack.field_77994_a <= 0 || !this.tryTransferItem(stack, tileEntity)) continue;
            outputSlot.put(i, null);
            itemsTransferred = true;
        }
        return itemsTransferred;
    }

    private boolean tryTransferItem(ItemStack stack, TileEntity tileEntity) {
        World world = tileEntity.func_145831_w();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            IInventory inventory;
            TileEntity neighbor = world.func_147438_o(tileEntity.field_145851_c + direction.offsetX, tileEntity.field_145848_d + direction.offsetY, tileEntity.field_145849_e + direction.offsetZ);
            if (!(neighbor instanceof IInventory) || !this.transferItemToInventory(stack, inventory = (IInventory)neighbor, direction)) continue;
            return true;
        }
        return false;
    }

    private boolean transferItemToInventory(ItemStack stack, IInventory inventory, ForgeDirection direction) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack remaining;
            if (!inventory.func_94041_b(slot, stack) || (remaining = this.insertItem(inventory, slot, stack)) != null) continue;
            return true;
        }
        return false;
    }

    public ItemStack insertItem(IInventory inventory, int slot, ItemStack stack) {
        ItemStack existing = inventory.func_70301_a(slot);
        if (existing == null) {
            inventory.func_70299_a(slot, stack);
            inventory.func_70296_d();
            return null;
        }
        if (existing.func_77969_a(stack) && existing.field_77994_a < existing.func_77976_d()) {
            int transferAmount = Math.min(existing.func_77976_d() - existing.field_77994_a, stack.field_77994_a);
            existing.field_77994_a += transferAmount;
            stack.field_77994_a -= transferAmount;
            if (stack.field_77994_a <= 0) {
                inventory.func_70296_d();
                return null;
            }
        }
        return stack;
    }
}

