/*
 * Decompiled with CFR 0.152.
 */
package com.elpiksan.mwtechnology.common.render;

import com.elpiksan.mwtechnology.common.tile.tileMechanisms.TileEntityMythicalMolecular;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class TileEntityMythicalMolecularRender
extends TileEntitySpecialRenderer {
    public static final ResourceLocation texture = new ResourceLocation("mwtechnology", "textures/models/mt.png");
    static final IModelCustom model = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("mwtechnology", "models/MolecularT1.obj"));
    private static final ResourceLocation plazmaTextloc = new ResourceLocation("mwtechnology", "textures/models/plazma.png");
    private static final ResourceLocation particlesTextloc = new ResourceLocation("mwtechnology", "textures/models/particles.png");
    private static Map textureSizeCache = new HashMap();
    public int ticker;

    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        this.render((TileEntityMythicalMolecular)tile, x, y, z, f);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getTextureSize(String s, int dv) {
        if (textureSizeCache.get(Arrays.asList(s, dv)) != null) {
            return (Integer)textureSizeCache.get(Arrays.asList(s, dv));
        }
        try {
            InputStream inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("mwtechnology", s)).func_110527_b();
            if (inputstream == null) {
                throw new Exception("Image not found: " + s);
            }
            BufferedImage bi = ImageIO.read(inputstream);
            int size = bi.getWidth() / dv;
            textureSizeCache.put(Arrays.asList(s, dv), size);
            return size;
        }
        catch (Exception var5) {
            Exception e = var5;
            e.printStackTrace();
            return 16;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void render(TileEntityMythicalMolecular tile, double x, double y, double z, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslatef((float)0.5f, (float)0.98f, (float)0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)1.3f, (float)1.23f, (float)1.3f);
        if (tile.tileActiveSlots == 0) {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(texture);
        }
        if (tile.tileActiveSlots > 0) {
            this.renderCore((TileEntity)tile, x, y, z, scale);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(texture);
        }
        model.renderAll();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCore(TileEntity te, double x, double y, double z, float scale) {
        ++this.ticker;
        if (this.ticker > 161) {
            this.ticker = 1;
        }
        int size1 = TileEntityMythicalMolecularRender.getTextureSize("textures/models/plazma.png", 64);
        int size2 = TileEntityMythicalMolecularRender.getTextureSize("textures/models/particles.png", 32);
        float f1 = ActiveRenderInfo.field_74588_d;
        float f2 = ActiveRenderInfo.field_74589_e;
        float f3 = ActiveRenderInfo.field_74586_f;
        float f4 = ActiveRenderInfo.field_74587_g;
        float f5 = ActiveRenderInfo.field_74596_h;
        float scaleCore = 0.35f;
        float posX = 0.0f;
        float posY = 0.2f;
        float posZ = 0.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        Color color = new Color(65497);
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(plazmaTextloc);
        int i = this.ticker % 16;
        float size4 = size1 * 4;
        float float_sizeMinus0_01 = (float)size1 - 0.01f;
        float x0 = ((float)(i % 4 * size1) + 0.0f) / size4;
        float x1 = ((float)(i % 4 * size1) + float_sizeMinus0_01) / size4;
        float x2 = ((float)(i / 4 * size1) + 0.0f) / size4;
        float x3 = ((float)(i / 4 * size1) + float_sizeMinus0_01) / size4;
        this.renderQuad(tessellator, color, posX, posY, posZ, f1, f2, f3, f4, f5, scaleCore, x0, x1, x2, x3);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderQuad(tessellator, color, posX, posY, posZ, f1, f2, f3, f4, f5, scaleCore, x0, x1, x2, x3);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderQuad(tessellator, color, posX, posY, posZ, f1, f2, f3, f4, f5, scaleCore, x0, x1, x2, x3);
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderQuad(tessellator, color, posX, posY, posZ, f1, f2, f3, f4, f5, scaleCore, x0, x1, x2, x3);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderQuad(tessellator, color, posX, posY, posZ, f1, f2, f3, f4, f5, scaleCore, x0, x1, x2, x3);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(particlesTextloc);
        int qq = this.ticker % 16;
        i = 24 + qq;
        float size8 = size2 * 8;
        float_sizeMinus0_01 = (float)size2 - 0.01f;
        x0 = ((float)(i % 8 * size2) + 0.0f) / size8;
        x1 = ((float)(i % 8 * size2) + float_sizeMinus0_01) / size8;
        x2 = ((float)(i / 8 * size2) + 0.0f) / size8;
        x3 = ((float)(i / 8 * size2) + float_sizeMinus0_01) / size8;
        this.renderQuad(tessellator, color, posX, posY * 2.0f, posZ, f1, f2, f3, f4, f5, scaleCore, x0, x1, x2, x3);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderQuad(tessellator, color, posX, posY * 2.0f, posZ, f1, f2, f3, f4, f5, scaleCore, x0, x1, x2, x3);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderQuad(tessellator, color, posX, posY * 2.0f, posZ, f1, f2, f3, f4, f5, scaleCore, x0, x1, x2, x3);
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderQuad(tessellator, color, posX, posY * 2.0f, posZ, f1, f2, f3, f4, f5, scaleCore, x0, x1, x2, x3);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderQuad(tessellator, color, posX, posY * 2.0f, posZ, f1, f2, f3, f4, f5, scaleCore, x0, x1, x2, x3);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderQuad(Tessellator tessellator, Color color, float posX, float posY, float posZ, float f1, float f2, float f3, float f4, float f5, float scaleCore, float x0, float x1, float x2, float x3) {
        tessellator.func_78382_b();
        tessellator.func_78369_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        tessellator.func_78374_a((double)(posX - f1 * scaleCore - f4 * scaleCore), (double)(posY - f2 * scaleCore), (double)(posZ - f3 * scaleCore - f5 * scaleCore), (double)x1, (double)x3);
        tessellator.func_78374_a((double)(posX - f1 * scaleCore + f4 * scaleCore), (double)(posY + f2 * scaleCore), (double)(posZ - f3 * scaleCore + f5 * scaleCore), (double)x1, (double)x2);
        tessellator.func_78374_a((double)(posX + f1 * scaleCore + f4 * scaleCore), (double)(posY + f2 * scaleCore), (double)(posZ + f3 * scaleCore + f5 * scaleCore), (double)x0, (double)x2);
        tessellator.func_78374_a((double)(posX + f1 * scaleCore - f4 * scaleCore), (double)(posY - f2 * scaleCore), (double)(posZ + f3 * scaleCore - f5 * scaleCore), (double)x0, (double)x3);
        tessellator.func_78381_a();
    }
}

