/*
 * Decompiled with CFR 0.152.
 */
package com.elpiksan.mwtechnology.common.tile.tileCommon;

import com.elpiksan.mwtechnology.common.container.containerMythical.ContainerMaceratorAdvenced;
import com.elpiksan.mwtechnology.common.product.ExtraProduct;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessable;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.upgrade.IUpgradableBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityMaceratorAdvenced
extends TileEntityElectricMachine
implements IHasGui,
INetworkTileEntityEventListener,
IUpgradableBlock {
    protected short progress = 0;
    public final int defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final int defaultEnergyStorage;
    public int energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public double energyOutput;
    public double guiProgress = 0.0;
    public AudioSource audioSource;
    protected static final int EventStart = 0;
    protected static final int EventStop = 2;
    public final IMachineRecipeManager recipeManager;
    public InvSlotProcessable[] inputSlot;
    public final InvSlotOutput outputSlot;
    public final InvSlotOutput extraOutputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public int extraOutputSlots;
    public int outputSlots;
    public int inputSlots;
    private static final Random RANDOM = new Random();
    private List<ExtraProduct> extraProducts;

    public TileEntityMaceratorAdvenced(int energyPerTick, int length, int outputSlots, int extraOutputSlot, int inputSlots, IMachineRecipeManager recipeManager, List<ExtraProduct> extraProducts) {
        this(energyPerTick, length, outputSlots, inputSlots, extraOutputSlot, recipeManager, 1);
        this.extraProducts = extraProducts;
    }

    public TileEntityMaceratorAdvenced(int energyPerTick, int length, int outputSlots, int inputSlots, int extraOutputSlot, IMachineRecipeManager recipeManager, int aDefaultTier) {
        super(1000000, 1, 1);
        this.recipeManager = recipeManager;
        this.defaultEnergyConsume = this.energyConsume = energyPerTick;
        this.defaultOperationLength = this.operationLength = length;
        this.defaultTier = aDefaultTier;
        this.defaultEnergyStorage = 1000000;
        this.inputSlot = new InvSlotProcessable[inputSlots];
        int index = 0;
        if (recipeManager != null) {
            for (int i = 0; i < inputSlots; ++i) {
                this.inputSlot[i] = new InvSlotProcessableGeneric((TileEntityInventory)this, "input_" + i, index++, 1, recipeManager);
            }
        }
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", index++, outputSlots);
        this.extraOutputSlot = new InvSlotOutput((TileEntityInventory)this, "extra_output", index++, extraOutputSlot);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", index++, 4);
        this.outputSlots = outputSlots;
        this.inputSlots = inputSlots;
        this.extraOutputSlots = extraOutputSlot;
    }

    public int func_70302_i_() {
        return super.func_70302_i_() + this.extraOutputSlots;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.extraOutputSlot != null && slot == this.func_70302_i_() - 1) {
            return false;
        }
        return super.func_94041_b(slot, stack);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        NBTTagCompound tag = new NBTTagCompound();
    }

    public double getProgress() {
        return this.guiProgress;
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        this.upgradeSlot.onChanged();
        double previousProgress = (double)this.progress / (double)this.operationLength;
        double stackOpLen = ((double)this.defaultOperationLength + (double)this.upgradeSlot.extraProcessTime) * 64.0 * this.upgradeSlot.processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = TileEntityMaceratorAdvenced.applyModifier(this.defaultEnergyConsume, this.upgradeSlot.extraEnergyDemand, this.upgradeSlot.energyDemandMultiplier);
        this.setTier(TileEntityMaceratorAdvenced.applyModifier(this.defaultTier, this.upgradeSlot.extraTier, 1.0));
        this.maxEnergy = TileEntityMaceratorAdvenced.applyModifier(this.defaultEnergyStorage, this.upgradeSlot.extraEnergyStorage, this.upgradeSlot.energyStorageMultiplier);
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.progress = (short)Math.floor(previousProgress * (double)this.operationLength + 0.1);
    }

    public abstract String func_145825_b();

    public ContainerBase<? extends TileEntityMaceratorAdvenced> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMaceratorAdvenced<TileEntityMaceratorAdvenced>(entityPlayer, this);
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IC2.audioManager.playOnce((Object)this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxEnergy) {
            return amount;
        }
        this.energyOutput = voltage;
        this.energy += amount;
        return 0.0;
    }

    public String formatEnergy(double energy) {
        if (energy >= 1.0E12) {
            return String.format("%.1fT", energy / 1.0E12);
        }
        if (energy >= 1.0E11) {
            return String.format("%dG", (int)(energy / 1.0E9));
        }
        if (energy >= 1.0E10) {
            return String.format("%.1fG", energy / 1.0E9);
        }
        if (energy >= 1.0E9) {
            return String.format("%.1fG", energy / 1.0E9);
        }
        if (energy >= 1.0E8) {
            return String.format("%dM", (int)(energy / 1000000.0));
        }
        if (energy >= 1.0E7) {
            return String.format("%.1fM", energy / 1000000.0);
        }
        if (energy >= 1000000.0) {
            return String.format("%.1fM", energy / 1000000.0);
        }
        if (energy >= 100000.0) {
            return String.format("%dK", (int)(energy / 1000.0));
        }
        if (energy >= 10000.0) {
            return String.format("%.1fK", energy / 1000.0);
        }
        if (energy >= 1000.0) {
            return String.format("%.1fK", energy / 1000.0);
        }
        return String.valueOf((int)energy);
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }
}

