/*
 * Decompiled with CFR 0.152.
 */
package com.elpiksan.mwtechnology.common.tile.tileCommon;

import com.denfop.tiles.base.TileEntityElectricMachine;
import com.elpiksan.mwtechnology.common.container.containerMythical.ContainerMatterGenerator;
import com.elpiksan.mwtechnology.common.invslot.AutoOutput;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.UpgradableProperty;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityMatterGenerator
extends TileEntityElectricMachine
implements IHasGui,
INetworkTileEntityEventListener,
IUpgradableBlock {
    private int activeCooldown = 0;
    public boolean isActive;
    protected double progress;
    public final int defaultTier;
    public double guiProgress;
    private long ENERGY_PER_ITEM;
    private static final int ITEMS_PER_CYCLE = 1;
    public double energyOutput;
    public final InvSlotOutput outputSlot;
    public String matter;
    private short facing;
    public AutoOutput autoOutput;

    public TileEntityMatterGenerator(int outputSlots, long ENERGY_PER_ITEM, String matter) {
        super((double)ENERGY_PER_ITEM, 1, 1);
        this.matter = matter;
        this.progress = 0.0;
        this.guiProgress = 0.0;
        this.ENERGY_PER_ITEM = ENERGY_PER_ITEM;
        this.maxEnergy = ENERGY_PER_ITEM;
        this.defaultTier = 1;
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 0, outputSlots);
        this.autoOutput = new AutoOutput();
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void setFacing(short facing) {
        this.facing = facing;
    }

    public short getFacing() {
        return this.facing;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74765_d("progress");
        this.setFacing(nbt.func_74765_d("Facing"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("Facing", this.getFacing());
        nbt.func_74780_a("progress", this.progress);
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public double getProgress() {
        return this.guiProgress;
    }

    public void updateEntityServer() {
        ItemStack newItem;
        Item item;
        if (this.isActive || this.energy > 0.0 || this.progress > 0.0) {
            this.isActive = true;
            this.activeCooldown = 20;
        }
        this.guiProgress = this.progress = this.energy / (double)this.ENERGY_PER_ITEM;
        if (this.energy >= (double)this.ENERGY_PER_ITEM && (item = (Item)Item.field_150901_e.func_82594_a(this.matter)) != null && this.outputSlot.canAdd(newItem = new ItemStack(item, 1)) && this.progress >= 1.0) {
            this.energy -= (double)this.ENERGY_PER_ITEM;
            this.outputSlot.add(newItem);
            this.progress = 0.0;
            this.autoOutput.autoOutput((TileEntity)this, this.outputSlot);
        }
        if (this.activeCooldown > 0) {
            --this.activeCooldown;
        }
        if (this.energy <= 0.0 && this.progress <= 0.0 && this.activeCooldown <= 0) {
            this.isActive = false;
        }
        if (this.getActive() != this.isActive) {
            this.setActive(this.isActive);
        }
        this.func_70296_d();
    }

    public abstract String func_145825_b();

    public ContainerBase<? extends TileEntityMatterGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMatterGenerator(entityPlayer, this);
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= this.maxEnergy) {
            return amount;
        }
        this.energyOutput = voltage;
        this.energy += amount;
        return 0.0;
    }

    public String formatEnergy(double energy) {
        if (energy >= 1.0E12) {
            return String.format("%.1fT", energy / 1.0E12);
        }
        if (energy >= 1.0E11) {
            return String.format("%dG", (int)(energy / 1.0E9));
        }
        if (energy >= 1.0E10) {
            return String.format("%.1fG", energy / 1.0E9);
        }
        if (energy >= 1.0E9) {
            return String.format("%.1fG", energy / 1.0E9);
        }
        if (energy >= 1.0E8) {
            return String.format("%dM", (int)(energy / 1000000.0));
        }
        if (energy >= 1.0E7) {
            return String.format("%.1fM", energy / 1000000.0);
        }
        if (energy >= 1000000.0) {
            return String.format("%.1fM", energy / 1000000.0);
        }
        if (energy >= 100000.0) {
            return String.format("%dK", (int)(energy / 1000.0));
        }
        if (energy >= 10000.0) {
            return String.format("%.1fK", energy / 1000.0);
        }
        if (energy >= 1000.0) {
            return String.format("%.1fK", energy / 1000.0);
        }
        return String.valueOf((int)energy);
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return Collections.emptySet();
    }

    public List<String> getNetworkedFields() {
        List ret = super.getNetworkedFields();
        ret.add("guiProgress");
        ret.add("energy");
        ret.add("maxEnergy");
        ret.add("isActive");
        return ret;
    }
}

