/*
 * Decompiled with CFR 0.152.
 */
package com.elpiksan.mwtechnology.common.tile.tileMechanisms;

import com.elpiksan.mwtechnology.client.gui.guiMechanisms.GuiLegendaryReplicator;
import com.elpiksan.mwtechnology.common.container.containerMythical.ContainerLegendaryReplicator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.IPatternStorage;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankElectricMachine;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.UpgradableProperty;
import ic2.core.util.StackUtil;
import ic2.core.uu.UuIndex;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityLegendaryReplicator
extends TileEntityLiquidTankElectricMachine
implements IHasGui,
IUpgradableBlock,
INetworkClientTileEntityEventListener {
    public int patternsSize = 3;
    private static final double uuPerTickBase = 1.0E-4;
    private static final double euPerTickBase = 512.0;
    private static final int defaultTier = 4;
    private static final int defaultEnergyStorage = 10000000;
    private double extraUuStored = 0.0;
    public double[] uuProcessed = new double[this.patternsSize];
    public ItemStack[] pattern = new ItemStack[this.patternsSize];
    private Mode mode;
    public int[] index = new int[this.patternsSize];
    public int maxIndex;
    public double[] patternUu = new double[this.patternsSize];
    public double[] patternEu = new double[this.patternsSize];
    public final InvSlotConsumableLiquid fluidSlot;
    public final InvSlotOutput cellSlot;
    public final InvSlotOutput outputSlot;

    public TileEntityLegendaryReplicator() {
        super(10000000, 14, 0, 328);
        this.mode = Mode.STOPPED;
        int sizeIndex = 0;
        this.fluidSlot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "fluid", 0, 1, new Fluid[]{BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter)});
        this.cellSlot = new InvSlotOutput((TileEntityInventory)this, "cell", 0, 1);
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", sizeIndex++, 28);
    }

    public void refreshInfo() {
        for (int slotIndex = 0; slotIndex < this.patternsSize; ++slotIndex) {
            IPatternStorage storage = this.getPatternStorageFromChunk();
            ItemStack oldPattern = this.pattern[slotIndex];
            if (storage == null) {
                this.pattern[slotIndex] = null;
                continue;
            }
            List patterns = storage.getPatterns();
            if (this.index[slotIndex] < 0 || this.index[slotIndex] >= patterns.size()) {
                this.index[slotIndex] = 0;
            }
            this.maxIndex = patterns.size();
            if (patterns.isEmpty()) {
                this.pattern[slotIndex] = null;
                continue;
            }
            this.pattern[slotIndex] = (ItemStack)patterns.get(this.index[slotIndex]);
            this.patternUu[slotIndex] = UuIndex.instance.getInBuckets(this.pattern[slotIndex]);
            if (StackUtil.isStackEqual((ItemStack)this.pattern[slotIndex], (ItemStack)oldPattern)) continue;
            this.uuProcessed[slotIndex] = 0.0;
            this.mode = Mode.STOPPED;
        }
    }

    public IPatternStorage getPatternStorage() {
        for (Direction direction : Direction.directions) {
            TileEntity target = direction.applyToTileEntity((TileEntity)this);
            if (!(target instanceof IPatternStorage)) continue;
            return (IPatternStorage)target;
        }
        return null;
    }

    public IPatternStorage getPatternStorageFromChunk() {
        if (!this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).field_150816_i.isEmpty()) {
            for (Object tile : new ArrayList(this.func_145831_w().func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).field_150816_i.values())) {
                if (!(tile instanceof IPatternStorage)) continue;
                return (IPatternStorage)tile;
            }
        }
        return null;
    }

    public void setOverclockRates() {
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
            this.refreshInfo();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        IC2.platform.isSimulating();
    }

    public boolean gainFluid() {
        boolean ret = false;
        MutableObject output = new MutableObject();
        if (this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, output, true) && (output.getValue() == null || this.cellSlot.canAdd((ItemStack)output.getValue()))) {
            ret = this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, output, false);
            if (output.getValue() != null) {
                this.cellSlot.add((ItemStack)output.getValue());
            }
        }
        return ret;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        for (int slotIndex = 0; slotIndex < this.patternsSize; ++slotIndex) {
            this.extraUuStored = nbttagcompound.func_74769_h("extraUuStored");
            this.uuProcessed[slotIndex] = nbttagcompound.func_74769_h("uuProcessed");
            this.index[slotIndex] = nbttagcompound.func_74762_e("index");
            int modeIdx = nbttagcompound.func_74762_e("mode");
            this.mode = modeIdx < Mode.values().length ? Mode.values()[modeIdx] : Mode.STOPPED;
            NBTTagCompound contentTag = nbttagcompound.func_74775_l("pattern");
            this.pattern[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)contentTag);
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        for (int slotIndex = 0; slotIndex < this.patternsSize; ++slotIndex) {
            nbttagcompound.func_74780_a("extraUuStored", this.extraUuStored);
            nbttagcompound.func_74780_a("uuProcessed", this.uuProcessed[slotIndex]);
            nbttagcompound.func_74768_a("index", this.index[slotIndex]);
            nbttagcompound.func_74768_a("mode", this.mode.ordinal());
            if (this.pattern[slotIndex] == null) continue;
            NBTTagCompound contentTag = new NBTTagCompound();
            this.pattern[slotIndex].func_77955_b(contentTag);
            nbttagcompound.func_74782_a("pattern", (NBTBase)contentTag);
        }
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        int slotIndex = event >> 16;
        int action = event & 0xFFFF;
        switch (action) {
            case 0: 
            case 1: {
                List patterns;
                IPatternStorage storage;
                if (this.mode != Mode.STOPPED || (storage = this.getPatternStorageFromChunk()) == null || (patterns = storage.getPatterns()).isEmpty()) break;
                if (event == 0) {
                    if (this.index[slotIndex] <= 0) {
                        this.index[slotIndex] = patterns.size() - 1;
                    } else {
                        int n = slotIndex;
                        this.index[n] = this.index[n] - 1;
                    }
                } else if (this.index[slotIndex] >= patterns.size() - 1) {
                    this.index[slotIndex] = 0;
                } else {
                    int n = slotIndex;
                    this.index[n] = this.index[n] + 1;
                }
                this.refreshInfo();
                break;
            }
            default: {
                break;
            }
            case 3: {
                if (this.mode == Mode.STOPPED) break;
                this.uuProcessed[slotIndex] = 0.0;
                this.mode = Mode.STOPPED;
                break;
            }
            case 4: {
                if (this.pattern == null) break;
                this.mode = Mode.SINGLE;
                break;
            }
            case 5: {
                if (this.pattern == null) break;
                this.mode = Mode.CONTINUOUS;
            }
        }
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter) == fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public Mode getMode() {
        return this.mode;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiLegendaryReplicator(new ContainerLegendaryReplicator(entityPlayer, this));
    }

    public ContainerLegendaryReplicator getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerLegendaryReplicator(entityPlayer, this);
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public String func_145825_b() {
        return null;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, new UpgradableProperty[]{UpgradableProperty.RedstoneSensitive, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidConsuming});
    }

    public static enum Mode {
        STOPPED,
        SINGLE,
        CONTINUOUS;

    }
}

