/*
 * Decompiled with CFR 0.152.
 */
package com.elpiksan.mwtechnology.common.tile.tileMechanisms;

import com.elpiksan.mwtechnology.client.gui.guiMechanisms.GuiMythicalBreaker;
import com.elpiksan.mwtechnology.common.container.containerMythical.ContainerMythicalBreaker;
import com.elpiksan.mwtechnology.common.invslot.AutoOutput;
import com.elpiksan.mwtechnology.common.invslot.InvSlotFortuneModule;
import com.elpiksan.mwtechnology.common.invslot.InvSlotOre;
import com.elpiksan.mwtechnology.common.invslot.InvSlotPickaxeSlot;
import com.elpiksan.mwtechnology.common.item.ItemFortuneModule;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.UpgradableProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMythicalBreaker
extends TileEntityElectricMachine
implements IHasGui,
INetworkTileEntityEventListener,
IUpgradableBlock {
    protected short progress = 0;
    private final List<ItemStack> pendingDrops = new ArrayList<ItemStack>();
    public final int defaultEnergyStorage;
    public InvSlot[] inputSlots = new InvSlotOre[8];
    public final InvSlotOutput outputSlot;
    public final InvSlotPickaxeSlot pickaxeSlot;
    public final InvSlotFortuneModule fortuneModuleSlot;
    public int energyConsume;
    public int operationLength = 100;
    public double guiProgress;
    private short facing;
    public double energyOutput;
    public AutoOutput autoOutput;

    public TileEntityMythicalBreaker() {
        super(1000000, 2, 2);
        this.defaultEnergyStorage = 1000000;
        int index = 0;
        for (int i = 0; i < 8; ++i) {
            this.inputSlots[i] = new InvSlotOre(this, "input_" + i, index++, InvSlot.Access.I, 1);
        }
        this.autoOutput = new AutoOutput();
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", index++, 32);
        this.pickaxeSlot = new InvSlotPickaxeSlot((TileEntityInventory)this, "pickaxe", index++, InvSlot.Access.I, 1);
        this.fortuneModuleSlot = new InvSlotFortuneModule((TileEntityInventory)this, "fortune_module", index++, InvSlot.Access.I, 1);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void onLoaded() {
        super.onLoaded();
    }

    public void onUnloaded() {
        super.onUnloaded();
        this.setOverclock();
    }

    public void func_70296_d() {
        super.func_70296_d();
        IC2.platform.isSimulating();
        this.setOverclock();
    }

    public void setFacing(short facing) {
        this.facing = facing;
    }

    public short getFacing() {
        return this.facing;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        nbttagcompound.func_74777_a("Facing", this.facing);
        NBTTagList dropList = new NBTTagList();
        for (ItemStack drop : this.pendingDrops) {
            NBTTagCompound dropNBT = new NBTTagCompound();
            drop.func_77955_b(dropNBT);
            dropList.func_74742_a((NBTBase)dropNBT);
        }
        nbttagcompound.func_74782_a("PendingDrops", (NBTBase)dropList);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
        this.facing = nbttagcompound.func_74765_d("Facing");
        NBTTagList dropList = nbttagcompound.func_150295_c("PendingDrops", 10);
        this.pendingDrops.clear();
        for (int i = 0; i < dropList.func_74745_c(); ++i) {
            NBTTagCompound dropNBT = dropList.func_150305_b(i);
            ItemStack drop = ItemStack.func_77949_a((NBTTagCompound)dropNBT);
            if (drop == null) continue;
            this.pendingDrops.add(drop);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public List<String> getNetworkedFields() {
        List ret = super.getNetworkedFields();
        ret.add("maxEnergy");
        ret.add("energy");
        return ret;
    }

    public String func_145825_b() {
        return "";
    }

    public boolean isPickaxeInSlot() {
        ItemStack stack = this.pickaxeSlot.get();
        return stack != null && stack.func_77973_b() instanceof ItemPickaxe;
    }

    public List<ItemStack> getDropsForOre(ItemStack ore, int amountToProcess) {
        ArrayList<ItemStack> finalDrops = new ArrayList<ItemStack>();
        Block block = Block.func_149634_a((Item)ore.func_77973_b());
        if (block != null) {
            int oreMeta = ore.func_77960_j();
            if (this.getModuleFortuneLevel() + this.getFortuneLevel() >= 1) {
                int fortuneLevel = this.getModuleFortuneLevel() + this.getFortuneLevel() - 1;
                for (int i = 0; i < amountToProcess; ++i) {
                    ArrayList drops = block.getDrops(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, oreMeta, fortuneLevel);
                    for (ItemStack drop : drops) {
                        finalDrops.add(drop.func_77946_l());
                    }
                }
                return finalDrops;
            }
            int fortuneLevel = 0;
            for (int i = 0; i < amountToProcess; ++i) {
                ArrayList drops = block.getDrops(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, oreMeta, fortuneLevel);
                for (ItemStack drop : drops) {
                    finalDrops.add(drop.func_77946_l());
                }
            }
            return finalDrops;
        }
        return finalDrops;
    }

    public void setOverclock() {
        ItemStack pickaxe = this.pickaxeSlot.get();
        if (pickaxe != null && pickaxe.func_77973_b() instanceof ItemPickaxe) {
            int efficiencyLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)pickaxe);
            if (efficiencyLevel > 0) {
                this.operationLength = Math.max(20, this.operationLength - efficiencyLevel * 10);
                this.energyConsume = Math.max(50, this.energyConsume + efficiencyLevel * 10);
            } else {
                this.operationLength = 100;
                this.energyConsume = 300 * (this.getFortuneLevel() + this.getModuleFortuneLevel() * 2);
            }
        }
    }

    public boolean isValidOre(ItemStack ore, ItemStack droppedItem) {
        return droppedItem.func_77973_b() != ore.func_77973_b();
    }

    private int getFortuneLevel() {
        ItemStack stack = this.pickaxeSlot.get();
        int fortune = 0;
        fortune += this.getModuleFortuneLevel();
        if (stack != null) {
            fortune += EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack);
        }
        return fortune;
    }

    private int getModuleFortuneLevel() {
        ItemStack moduleStack = this.fortuneModuleSlot.get();
        int moduleFortune = 0;
        if (moduleStack != null && moduleStack.func_77973_b() instanceof ItemFortuneModule) {
            String unlocalizedName;
            switch (unlocalizedName = moduleStack.func_77977_a()) {
                case "item.mythicalFortuneModule1": {
                    ++moduleFortune;
                    break;
                }
                case "item.mythicalFortuneModule3": {
                    moduleFortune += 3;
                    break;
                }
                case "item.mythicalFortuneModule5": {
                    moduleFortune += 5;
                    break;
                }
                case "item.mythicalFortuneModule10": {
                    moduleFortune += 10;
                    break;
                }
            }
        }
        return moduleFortune;
    }

    public double getProgress() {
        return this.guiProgress;
    }

    public double getChargeLevels() {
        return Math.min(1.0f, (float)this.energy / (float)this.maxEnergy);
    }

    public ContainerBase<? extends TileEntityMythicalBreaker> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMythicalBreaker(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMythicalBreaker(new ContainerMythicalBreaker(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (amount <= this.getEnergy()) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxEnergy) {
            return amount;
        }
        this.energyOutput = voltage;
        this.energy += amount;
        return 0.0;
    }

    public String formatEnergy(int energy) {
        if (energy >= 1000000) {
            return String.format("%.1fM", (double)energy / 1000000.0);
        }
        if (energy >= 1000) {
            return String.format("%.1fK", (double)energy / 1000.0);
        }
        return String.valueOf(energy);
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return Collections.emptySet();
    }

    public void onNetworkEvent(int i) {
    }
}

