/*
 * Decompiled with CFR 0.152.
 */
package com.elpiksan.mwtechnology.common.util;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class TaskScheduler {
    private static final TaskScheduler INSTANCE = new TaskScheduler();
    private final CopyOnWriteArrayList<Task> tasks = new CopyOnWriteArrayList();

    public void schedule(ScheduledTask task, long delay, TimeUnit unit) {
        this.tasks.add(new Task(task, delay, unit, false));
    }

    public void schedule(ScheduledTask task, long delay, TimeUnit unit, boolean isRepeatable) {
        this.tasks.add(new Task(task, delay, unit, isRepeatable));
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Task task : this.tasks) {
                task.incrementPassedTicks();
                if (!task.isFinished()) continue;
                task.getTask().run(task);
                if (task.isMarkedAsRemoved()) {
                    this.tasks.remove(task);
                    continue;
                }
                if (task.isRepeatable()) {
                    task.setPassedTicks(0L);
                    continue;
                }
                this.tasks.remove(task);
            }
        }
    }

    public static TaskScheduler getInstance() {
        return INSTANCE;
    }

    public static class Task {
        private final ScheduledTask task;
        private final long delayInTicks;
        private long passedTicks = 0L;
        private final boolean isRepeatable;
        private boolean markedAsRemoved;

        public Task(ScheduledTask task, long delay, TimeUnit timeUnit, boolean isRepeatable) {
            this.task = task;
            this.delayInTicks = Math.max(TimeUnit.SECONDS.convert(delay, timeUnit) * 20L, 1L);
            this.isRepeatable = isRepeatable;
        }

        public ScheduledTask getTask() {
            return this.task;
        }

        public long getDelayInTicks() {
            return this.delayInTicks;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public long getPassedTicks() {
            return this.passedTicks;
        }

        public void setPassedTicks(long passedTicks) {
            this.passedTicks = passedTicks;
        }

        public boolean isFinished() {
            return this.passedTicks >= this.delayInTicks;
        }

        public void incrementPassedTicks() {
            ++this.passedTicks;
        }

        public boolean isMarkedAsRemoved() {
            return this.markedAsRemoved;
        }

        public void markAsRemoved() {
            this.markedAsRemoved = true;
        }
    }

    @FunctionalInterface
    public static interface ScheduledTask {
        public void run(Task var1);
    }
}

