/*
 * Decompiled with CFR 0.152.
 */
package com.thewhoareyouperson.soundreloader;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="soundreloader", version="1.1")
public class SoundReloaderMod {
    public static final String MODID = "soundreloader";
    public static final String VERSION = "1.1";
    public static final Logger Logger;
    protected static final String mcVersion;
    protected static final boolean debug;
    protected static final boolean devEnv;
    protected static KeyBinding soundBinding;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        Logger.info("Registering Keybindings");
        Logger.info("Minecraft version: '" + mcVersion + "'");
        if (devEnv) {
            Logger.info("Running in Development (Deobfuscated) Environment");
        }
        soundBinding = new KeyBinding("Reload Default Sound", 25, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyBinding)soundBinding);
        if ("1.7.10".equals(mcVersion)) {
            FMLCommonHandler.instance().bus().register((Object)new KeyInputHandler());
        } else if ("1.8.9".equals(mcVersion) || "1.10.2".equals(mcVersion)) {
            MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        } else {
            Logger.warn("Unknown MC Version " + mcVersion + ", not initializing keybind handler.");
        }
    }

    static {
        String tmpMcVersion;
        Field fldMcVersion;
        try {
            fldMcVersion = MinecraftForge.class.getField("MC_VERSION");
        }
        catch (Exception e) {
            fldMcVersion = null;
        }
        try {
            tmpMcVersion = (String)fldMcVersion.get(null);
        }
        catch (IllegalArgumentException e) {
            tmpMcVersion = null;
        }
        catch (IllegalAccessException e) {
            tmpMcVersion = null;
        }
        mcVersion = tmpMcVersion;
        Logger = LogManager.getLogger((String)MODID);
        debug = System.getenv("DEBUG") != null && !System.getenv("DEBUG").isEmpty();
        devEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public static class KeyInputHandler {
        private static SoundManager cachedManager = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onKeyInput(InputEvent.KeyInputEvent event) {
            if (soundBinding.func_151468_f()) {
                Logger.info("Reloading sound system...");
                if (cachedManager == null) {
                    SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
                    SoundManager mngr = null;
                    Exception ex = null;
                    try {
                        if (debug) {
                            for (Field fd : SoundHandler.class.getDeclaredFields()) {
                                Logger.info("SoundHandler Field: '" + fd.getName() + "' of type '" + fd.getType() + "'");
                            }
                        }
                        Field fi = devEnv ? SoundHandler.class.getDeclaredField("sndManager") : SoundHandler.class.getDeclaredField("field_147694_f");
                        fi.setAccessible(true);
                        mngr = (SoundManager)fi.get(handler);
                    }
                    catch (NoSuchFieldException e) {
                        ex = e;
                    }
                    catch (SecurityException e) {
                        ex = e;
                    }
                    catch (IllegalArgumentException e) {
                        ex = e;
                    }
                    catch (IllegalAccessException e) {
                        ex = e;
                    }
                    finally {
                        if (ex != null) {
                            ex.printStackTrace();
                        }
                    }
                    cachedManager = mngr;
                }
                if (cachedManager != null) {
                    cachedManager.func_148596_a();
                    Logger.info("Reloaded sound system");
                } else {
                    Logger.warn("Unable to get sound manager");
                }
            }
        }
    }
}

