/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.waterhooks.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import info.loenwind.waterhooks.config.Config;
import info.loenwind.waterhooks.config.Log;
import info.loenwind.waterhooks.config.PacketConfigSync;
import info.loenwind.waterhooks.config.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.io.File;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static Configuration configuration;
    public static File configDirectory;
    public static boolean configLockedByServer;
    public static boolean iAmTheServer;

    public void init(FMLPreInitializationEvent event) {
        PacketHandler.INSTANCE.registerMessage(PacketConfigSync.class, PacketConfigSync.class, PacketHandler.nextID(), Side.CLIENT);
        FMLCommonHandler.instance().bus().register((Object)new ConfigHandler());
        configDirectory = new File(event.getModConfigurationDirectory(), "waterhooks".toLowerCase());
        if (!configDirectory.exists()) {
            configDirectory.mkdir();
        }
        File configFile = new File(configDirectory, "waterhooks.cfg");
        configuration = new Configuration(configFile);
        ConfigHandler.syncConfig(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncConfig(boolean load) {
        try {
            if (load) {
                configuration.load();
            }
            ConfigHandler.processConfig();
        }
        catch (Exception e) {
            Log.error("waterhooks has a problem loading it's configuration");
            e.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("waterhooks")) {
            Log.info("Updating config...");
            ConfigHandler.syncConfig(false);
        }
    }

    private static void processConfig() {
        ConfigHandler.loadAll(configuration);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void toBytes(ByteBuf buf) {
        for (Config value : Config.values()) {
            if (!value.getSection().sync) continue;
            value.store(buf);
        }
    }

    public static void fromBytes(ByteBuf buf) {
        if (iAmTheServer) {
            return;
        }
        for (Config value : Config.values()) {
            if (!value.getSection().sync) continue;
            value.read(buf);
        }
        configLockedByServer = true;
    }

    @SubscribeEvent
    public void onPlayerLoggon(PlayerEvent.PlayerLoggedInEvent evt) {
        iAmTheServer = true;
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketConfigSync(), (EntityPlayerMP)evt.player);
    }

    @SubscribeEvent
    public void onPlayerLogout(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ConfigHandler.syncConfig(false);
        configLockedByServer = false;
    }

    public static void loadAll(Configuration config) {
        for (Config value : Config.values()) {
            value.load(config);
        }
    }

    public static void loadAll() {
        for (Config value : Config.values()) {
            value.resetToDefault();
        }
    }

    static {
        ConfigHandler.loadAll();
        configLockedByServer = false;
        iAmTheServer = false;
    }
}

