/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.fluidmachines;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IEnergyStorage;
import ic2.core.util.EntityIC2FX;
import java.util.Random;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import ru.wirelessindustry.MainWI;
import ru.wirelessindustry.container.ContainerExpGen;
import ru.wirelessindustry.utils.ExperienceUtils;

public class TileExpGen
extends TileEntity
implements IEnergySink,
IEnergyStorage,
IInventory,
IFluidHandler {
    private final int tier;
    public double energy = 0.0;
    public int maxEnergy;
    public FluidTank fluidTank;
    public boolean initialized;
    public String nametile;
    public boolean active;
    public boolean lastState;
    private boolean addedToEnergyNet = false;
    private boolean loaded = false;
    private EntityPlayer player = null;

    public TileExpGen(int maxenergy, int tier1, String tileName, int maxtankcapacity) {
        this.fluidTank = new FluidTank(1000 * maxtankcapacity);
        this.initialized = false;
        this.loaded = false;
        this.maxEnergy = maxenergy;
        this.tier = tier1;
        this.nametile = tileName;
        this.lastState = false;
        this.active = false;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.active = nbttagcompound.func_74767_n("active");
        this.energy = nbttagcompound.func_74769_h("energy");
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
    }

    public int gaugeLiquidScaled(int i) {
        if (this.getFluidTank().getFluidAmount() <= 0) {
            return 0;
        }
        return this.getFluidTank().getFluidAmount() * i / this.getFluidTank().getCapacity();
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        nbttagcompound.func_74757_a("active", this.active);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.onLoaded();
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onUnloaded() {
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        this.loaded = false;
        this.setActive(false);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.initialized && this.field_145850_b != null) {
            this.intialize();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.energy > (double)this.maxEnergy) {
                this.energy = this.maxEnergy;
            }
            this.attemptGeneration();
            if (this.player != null & this.active) {
                this.transferExpToPlayer(this.player);
                this.player = null;
            } else {
                this.setActive(false);
            }
        }
    }

    protected void transferExpToPlayer(EntityPlayer entityplayer) {
        int actuallydrained;
        FluidStack drained;
        FluidStack fluid = this.getFluidTank().getFluid();
        if (fluid != null && fluid.isFluidEqual(new FluidStack(MainWI.xpJuice, 0)) && fluid.amount > 0 && (drained = this.fluidTank.drain(actuallydrained = Math.min(fluid.amount, 4), true)) != null) {
            int xp = drained.amount;
            ExperienceUtils.addPlayerXP(entityplayer, xp);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, int blockX, int blockY, int blockZ, Random rand) {
        if (this.getActive()) {
            EffectRenderer effect = FMLClientHandler.instance().getClient().field_71452_i;
            for (int particles = 20; particles > 0; --particles) {
                double x = (float)blockX + 0.0f + rand.nextFloat();
                double y = (float)blockY + 0.9f + rand.nextFloat();
                double z = (float)blockZ + 0.0f + rand.nextFloat();
                effect.func_78873_a((EntityFX)new EntityIC2FX(world, x, y, z, 60, new double[]{0.0, 0.1, 0.0}, new float[]{0.5f, 0.72f, 0.0f}));
            }
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean bool) {
        if (this.active != bool) {
            this.active = bool;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void isPlayerStandingOnBlock(EntityPlayer entity) {
        if (this.player == null || this.player.func_110124_au() != entity.func_110124_au()) {
            this.player = entity;
            this.setActive(true);
        }
    }

    public void intialize() {
        this.initialized = true;
        if (!this.addedToEnergyNet) {
            this.onLoaded();
        }
    }

    public void attemptGeneration() {
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return;
        }
        if (this.energy >= 2000.0 && this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
            this.fluidTank.fill(new FluidStack(MainWI.xpJuice, 1), true);
            this.energy -= 2000.0;
        }
    }

    public Container getGuiContainer(InventoryPlayer inventory) {
        return new ContainerExpGen(inventory, this);
    }

    public boolean acceptsEnergyFrom(TileEntity nameTileEntity, ForgeDirection nameForgeDirection) {
        return true;
    }

    public double getDemandedEnergy() {
        return (double)this.maxEnergy - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount == 0.0) {
            return 0.0;
        }
        if (this.energy >= (double)this.maxEnergy) {
            return amount;
        }
        this.energy += Math.min(amount, this.getDemandedEnergy());
        return 0.0;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.getFluidTank().fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.getFluidTank().getFluid())) {
            return null;
        }
        if (!this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.getFluidTank().drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from, null)) {
            return null;
        }
        return this.getFluidTank().drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == MainWI.xpJuice;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getFluidTank().getInfo()};
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public int addEnergy(int amount) {
        this.energy += (double)amount;
        return this.getStored();
    }

    public int getCapacity() {
        return this.maxEnergy;
    }

    public int getOutput() {
        return 128;
    }

    public double getOutputEnergyUnitsPerTick() {
        return 128.0;
    }

    public int getStored() {
        return (int)this.energy;
    }

    public void setStored(int energy) {
        this.energy = energy;
    }

    public boolean isTeleporterCompatible(ForgeDirection arg0) {
        return false;
    }
}

