/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.item.armor;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import org.lwjgl.input.Keyboard;
import ru.wirelessindustry.MainWI;
import ru.wirelessindustry.config.ConfigWI;
import ru.wirelessindustry.utils.HelperUtils;

public class ItemSolarWirelessEURFHelmet
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor {
    protected static final Map<Integer, Integer> potionRemovalCost = new HashMap<Integer, Integer>();
    private final int genDay;
    private final int genNight;
    public double maxenergyEU;
    protected double transferLimit;
    protected int tier;

    public ItemSolarWirelessEURFHelmet(String name) {
        super(ItemArmor.ArmorMaterial.DIAMOND, 0, 0);
        this.func_77655_b(name);
        this.maxenergyEU = 2.5E8;
        this.transferLimit = 250000.0;
        this.tier = 4;
        this.genDay = ConfigWI.EuRfSolarHelmetGenDay;
        this.genNight = ConfigWI.EuRfSolarHelmetGenNight;
        this.func_77656_e(27);
        this.func_77637_a(MainWI.tabwi);
        potionRemovalCost.put(Potion.field_76436_u.field_76415_H, 100);
        potionRemovalCost.put(Potion.field_82731_v.field_76415_H, 100);
        potionRemovalCost.put(Potion.field_76437_t.field_76415_H, 100);
        potionRemovalCost.put(Potion.field_76421_d.field_76415_H, 100);
        potionRemovalCost.put(Potion.field_76438_s.field_76415_H, 200);
        potionRemovalCost.put(Potion.field_76431_k.field_76415_H, 200);
        potionRemovalCost.put(Potion.field_76440_q.field_76415_H, 200);
        potionRemovalCost.put(Potion.field_76433_i.field_76415_H, 200);
        potionRemovalCost.put(IC2Potion.radiation.field_76415_H, 200);
    }

    public ItemSolarWirelessEURFHelmet() {
        this("wirelessuniversalsolarhelmet");
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return MainWI.RARITY_RF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        int nmode = nbt.func_74762_e("NightVisMode");
        String strmode = "";
        switch (nmode) {
            case 0: {
                strmode = EnumChatFormatting.RED + StatCollector.func_74838_a((String)"info.helmet.nightmode.off");
                break;
            }
            case 1: {
                strmode = EnumChatFormatting.DARK_AQUA + StatCollector.func_74838_a((String)"info.helmet.nightmode.auto");
                break;
            }
            case 2: {
                strmode = EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"info.helmet.nightmode.on");
            }
        }
        list.add(StatCollector.func_74838_a((String)"info.wirelesshelmet.about"));
        if (Keyboard.isKeyDown((int)42)) {
            String isonoff = nbt.func_74767_n("active") ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"info.helmet.yes") : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"info.helmet.no");
            list.add(StatCollector.func_74838_a((String)"info.wirelesshelmet.removespotions"));
            list.add(StatCollector.func_74838_a((String)"info.wirelesshelmet.selfcharge"));
            list.add(StatCollector.func_74838_a((String)"info.wirelesshelmet.autofeedplayer"));
            list.add(StatCollector.func_74838_a((String)"info.wirelesshelmet.mode") + ": " + isonoff);
            list.add(StatCollector.func_74838_a((String)"info.wirelesshelmet.radius") + ": " + EnumChatFormatting.DARK_GREEN + ConfigWI.helmetChargingRadius + " " + StatCollector.func_74838_a((String)"info.wirelesscharge.blocks"));
            list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.helmet.sneak.press.mode.key") + " Shift Key  + IC2 Mode Switch Key " + StatCollector.func_74838_a((String)"info.helmet.to.switch"));
            list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.helmet.sneak.press.altmode.key") + " Shift Key + IC2 Alt Key + Mode Switch Key " + StatCollector.func_74838_a((String)"info.helmet.to.switch.nv"));
        } else {
            list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.wirelesshelmet.press.lshift"));
            list.add(StatCollector.func_74838_a((String)"info.wirelesshelmet.nightmode") + ": " + strmode);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        ItemStack stack = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        list.add(stack);
        ItemStack stack1 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(stack1, 0.0, Integer.MAX_VALUE, true, false);
        list.add(stack1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("wirelessindustry:WirelessSolarHelmet");
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "wirelessindustry:textures/armor/wirelessEuRfSolarHelmet.png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean active = nbt.func_74767_n("active");
        byte toggleTimer = nbt.func_74771_c("toggleTimer");
        int nightvisionmode = nbt.func_74762_e("NightVisMode");
        if (!world.field_72995_K) {
            int generating;
            this.gainFuel(player, world, stack);
            if (!player.func_70651_bq().isEmpty()) {
                for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
                    int cost;
                    int potionid = effect.func_76456_a();
                    if (!potionRemovalCost.containsKey(potionid) || !ElectricItem.manager.canUse(stack, (double)((cost = potionRemovalCost.get(potionid).intValue()) * (effect.func_76458_c() + 1)))) continue;
                    ElectricItem.manager.use(stack, (double)cost, (EntityLivingBase)player);
                    player.func_82170_o(potionid);
                }
            }
            if (ElectricItem.manager.canUse(stack, 1000.0) && player.func_71024_bL().func_75116_a() < 18) {
                player.func_71024_bL().func_75122_a(4, 4.0f);
                ElectricItem.manager.use(stack, 1000.0, (EntityLivingBase)player);
                player.field_71069_bz.func_75142_b();
            } else if (player.func_71024_bL().func_75116_a() <= 0) {
                IC2.achievements.issueAchievement(player, "starveWithQHelmet");
            }
            int airLevel = player.func_70086_ai();
            if (ElectricItem.manager.canUse(stack, 1000.0) && airLevel < 100) {
                player.func_70050_g(airLevel + 200);
                ElectricItem.manager.use(stack, 1000.0, (EntityLivingBase)player);
                player.field_71069_bz.func_75142_b();
            }
            if ((generating = nbt.func_74762_e("generating")) > 0) {
                ElectricItem.manager.charge(stack, (double)generating, Integer.MAX_VALUE, false, false);
            }
            for (ItemStack st2 : player.field_71071_by.field_70462_a) {
                if (st2 == null || !(st2.func_77973_b() instanceof IEnergyContainerItem) || !(ElectricItem.manager.getCharge(stack) > 0.0)) continue;
                HelperUtils.chargeRFItemFromArmor2(stack, st2);
            }
        }
        if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            if (++nightvisionmode > 2) {
                nightvisionmode = 0;
            }
            if (IC2.platform.isSimulating()) {
                nbt.func_74768_a("NightVisMode", nightvisionmode);
            }
        }
        if (IC2.keyboard.isSneakKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = active = !active;
            if (IC2.platform.isSimulating()) {
                nbt.func_74757_a("active", active);
                if (active) {
                    HelperUtils.sendColoredMessageToPlayer(player, "chat.message.wirelesschargerf.on", EnumChatFormatting.DARK_GREEN);
                } else {
                    HelperUtils.sendColoredMessageToPlayer(player, "chat.message.wirelesschargerf.off", EnumChatFormatting.DARK_RED);
                }
            }
        }
        if (nightvisionmode == 1 && IC2.platform.isSimulating()) {
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int skylight = player.field_70170_p.func_72957_l(x, y = MathHelper.func_76128_c((double)player.field_70163_u), z = MathHelper.func_76128_c((double)player.field_70161_v));
            if (skylight > 8) {
                IC2.platform.removePotion((EntityLivingBase)player, Potion.field_76439_r.field_76415_H);
            } else {
                player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 0, true));
            }
            player.field_71069_bz.func_75142_b();
        } else if (nightvisionmode == 2 && IC2.platform.isSimulating()) {
            player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 0, true));
            player.field_71069_bz.func_75142_b();
        }
        if (!world.field_72995_K && active && ElectricItem.manager.getCharge(stack) > 0.0) {
            this.checkPlayers(player, world, stack);
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbt.func_74774_a("toggleTimer", toggleTimer);
        }
        if (player.func_70027_ad()) {
            player.func_70066_B();
        }
    }

    protected void checkPlayers(EntityPlayer player, World world, ItemStack thisarmor) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)(player.field_70165_t - (double)ConfigWI.helmetChargingRadius), (double)(player.field_70163_u - (double)ConfigWI.helmetChargingRadius), (double)(player.field_70161_v - (double)ConfigWI.helmetChargingRadius), (double)(player.field_70165_t + (double)ConfigWI.helmetChargingRadius), (double)(player.field_70163_u + (double)ConfigWI.helmetChargingRadius), (double)(player.field_70161_v + (double)ConfigWI.helmetChargingRadius));
        List list = world.func_72839_b((Entity)player, axisalignedbb);
        for (Entity entityinlist : list) {
            if (!(entityinlist instanceof EntityPlayer)) continue;
            this.checkPlayerInventories((EntityPlayer)entityinlist, thisarmor);
        }
    }

    protected void checkPlayerInventories(EntityPlayer player, ItemStack thisarmor) {
        for (ItemStack current : player.field_71071_by.field_70460_b) {
            if (current == null || !(current.func_77973_b() instanceof IEnergyContainerItem)) continue;
            HelperUtils.chargeRFItemFromArmor2(thisarmor, current);
        }
        for (ItemStack current : player.field_71071_by.field_70462_a) {
            if (current == null || !(current.func_77973_b() instanceof IEnergyContainerItem)) continue;
            HelperUtils.chargeRFItemFromArmor2(thisarmor, current);
        }
    }

    protected void gainFuel(EntityPlayer player, World world, ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (world.func_82737_E() % 20L == 0L) {
            this.updateVisibility(player, stack);
        }
        if (nbt.func_74767_n("Sunisup") && nbt.func_74767_n("Skyisvisible")) {
            nbt.func_74768_a("generating", this.genDay);
        } else if (nbt.func_74767_n("Skyisvisible")) {
            nbt.func_74768_a("generating", this.genNight);
        } else {
            nbt.func_74768_a("generating", 0);
        }
    }

    protected void updateVisibility(EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt1 = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean wetBiome1 = player.field_70170_p.func_72959_q().func_76935_a((int)player.field_70165_t, (int)player.field_70161_v).func_76744_g() > 0;
        boolean noSunWorld1 = player.field_70170_p.field_73011_w.field_76576_e;
        boolean rainWeather1 = wetBiome1 && (player.field_70170_p.func_72896_J() || player.field_70170_p.func_72911_I());
        boolean sunIsUp1 = player.field_70170_p.func_72935_r() && !rainWeather1;
        boolean skyIsVisible1 = player.field_70170_p.func_72937_j((int)player.field_70165_t, (int)player.field_70163_u + 1, (int)player.field_70161_v) && !noSunWorld1;
        nbt1.func_74757_a("Wetbiome", wetBiome1);
        nbt1.func_74757_a("Nosunworld", noSunWorld1);
        nbt1.func_74757_a("Sunisup", sunIsUp1);
        nbt1.func_74757_a("Skyisvisible", skyIsVisible1);
    }

    public int getEnergyPerDamage() {
        return 2000;
    }

    public double getDamageAbsorptionRatio() {
        return 1.0;
    }

    private double getBaseAbsorptionRatio() {
        return 0.15;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public boolean isMetalArmor(ItemStack var1, EntityPlayer var2) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack var1) {
        return false;
    }

    public Item getChargedItem(ItemStack var1) {
        return this;
    }

    public Item getEmptyItem(ItemStack var1) {
        return this;
    }

    public double getMaxCharge(ItemStack var1) {
        return this.maxenergyEU;
    }

    public int getTier(ItemStack var1) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack var1) {
        return this.transferLimit;
    }
}

