/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import ic2.core.item.tool.ItemDebug;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import org.lwjgl.input.Keyboard;
import ru.wirelessindustry.MainWI;
import ru.wirelessindustry.config.ConfigWI;
import ru.wirelessindustry.utils.HelperUtils;

public class QuantumChestplateWirelessCharge
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor {
    protected static final List<Integer> listpotionsid = new ArrayList<Integer>();
    public double maxCharge;
    protected double transferLimit;
    protected int tier;

    public QuantumChestplateWirelessCharge(String name) {
        super(ItemArmor.ArmorMaterial.DIAMOND, 0, 1);
        this.func_77655_b(name);
        this.maxCharge = 5.0E8;
        this.transferLimit = 500000.0;
        this.tier = 4;
        this.func_77656_e(27);
        this.func_77637_a(MainWI.tabwi);
        listpotionsid.add(Potion.field_76436_u.field_76415_H);
        listpotionsid.add(Potion.field_82731_v.field_76415_H);
        listpotionsid.add(Potion.field_76437_t.field_76415_H);
        listpotionsid.add(Potion.field_76438_s.field_76415_H);
        listpotionsid.add(Potion.field_76431_k.field_76415_H);
        listpotionsid.add(Potion.field_76440_q.field_76415_H);
        listpotionsid.add(Potion.field_76433_i.field_76415_H);
        listpotionsid.add(Potion.field_76421_d.field_76415_H);
        listpotionsid.add(IC2Potion.radiation.field_76415_H);
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return MainWI.RARITY_CHESTPLATE_WIRELESS;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean active = nbt.func_74767_n("active");
        boolean buffmode = nbt.func_74767_n("potionbuffs");
        byte toggleTimer = nbt.func_74771_c("toggleTimer");
        if (IC2.keyboard.isHudModeKeyDown(player) && player.func_70093_af() && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = active = !active;
            if (IC2.platform.isSimulating()) {
                nbt.func_74757_a("active", active);
                if (active) {
                    HelperUtils.sendColoredMessageToPlayer(player, "chat.message.wirelesscharge.on", EnumChatFormatting.DARK_GREEN);
                } else {
                    HelperUtils.sendColoredMessageToPlayer(player, "chat.message.wirelesscharge.off", EnumChatFormatting.DARK_RED);
                }
            }
        }
        if (IC2.keyboard.isBoostKeyDown(player) && player.func_70093_af() && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = buffmode = !buffmode;
            if (IC2.platform.isSimulating()) {
                nbt.func_74757_a("potionbuffs", buffmode);
                if (buffmode) {
                    HelperUtils.sendColoredMessageToPlayer(player, "chat.message.chestplate.buffs1.on", EnumChatFormatting.DARK_AQUA);
                    HelperUtils.sendColoredMessageToPlayer(player, "chat.message.chestplate.buffs2.on", EnumChatFormatting.DARK_AQUA);
                } else {
                    HelperUtils.sendColoredMessageToPlayer(player, "chat.message.chestplate.buffs.off", EnumChatFormatting.YELLOW);
                }
            }
        }
        if (active) {
            this.checkPlayers(player, world, stack);
        }
        if (buffmode) {
            for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
                int potionid = effect.func_76456_a();
                if (!listpotionsid.contains(potionid) || !ElectricItem.manager.canUse(stack, 100.0)) continue;
                player.func_82170_o(potionid);
                ElectricItem.manager.discharge(stack, 100.0, Integer.MAX_VALUE, true, false, false);
            }
            if (ElectricItem.manager.canUse(stack, 4.0)) {
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 200, 0, true));
                player.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 200, 1, true));
                player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 200, 0, true));
                player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 200, 0, true));
                ElectricItem.manager.discharge(stack, 4.0, Integer.MAX_VALUE, true, false, false);
            }
        }
        boolean jetpack = nbt.func_74767_n("jetpack");
        boolean hoverMode = nbt.func_74767_n("hoverMode");
        boolean jetpackUsed = false;
        if (IC2.keyboard.isSneakKeyDown(player) && IC2.keyboard.isJumpKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            hoverMode = !hoverMode;
            nbt.func_74757_a("hoverMode", hoverMode);
            if (IC2.platform.isSimulating()) {
                if (hoverMode) {
                    HelperUtils.sendColoredMessageToPlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432\u043a\u043b\u044e\u0447\u0451\u043d.", EnumChatFormatting.DARK_GREEN);
                } else {
                    HelperUtils.sendColoredMessageToPlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d.", EnumChatFormatting.DARK_GREEN);
                }
            }
        }
        if (IC2.keyboard.isSneakKeyDown(player) && IC2.keyboard.isAltKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            jetpack = !jetpack;
            nbt.func_74757_a("jetpack", jetpack);
            if (IC2.platform.isSimulating()) {
                if (jetpack) {
                    HelperUtils.sendColoredMessageToPlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043f\u043e\u043b\u0451\u0442\u0430 \u0432\u043a\u043b\u044e\u0447\u0451\u043d.", EnumChatFormatting.DARK_GREEN);
                } else {
                    HelperUtils.sendColoredMessageToPlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043f\u043e\u043b\u0451\u0442\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d.", EnumChatFormatting.DARK_GREEN);
                }
            }
        }
        if (jetpack && (IC2.keyboard.isJumpKeyDown(player) || hoverMode && player.field_70181_x < -0.03)) {
            jetpackUsed = this.useJetpack(player, hoverMode);
        }
        if (jetpackUsed) {
            player.field_71069_bz.func_75142_b();
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbt.func_74774_a("toggleTimer", toggleTimer);
        }
        if (player.func_70027_ad()) {
            player.func_70066_B();
        }
    }

    protected void checkPlayers(EntityPlayer player, World world, ItemStack thisarmor) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)(player.field_70165_t - (double)ConfigWI.chestplateChargingRadius), (double)(player.field_70163_u - (double)ConfigWI.chestplateChargingRadius), (double)(player.field_70161_v - (double)ConfigWI.chestplateChargingRadius), (double)(player.field_70165_t + (double)ConfigWI.chestplateChargingRadius), (double)(player.field_70163_u + (double)ConfigWI.chestplateChargingRadius), (double)(player.field_70161_v + (double)ConfigWI.chestplateChargingRadius));
        List list = world.func_72839_b((Entity)player, axisalignedbb);
        for (Entity entityinlist : list) {
            if (!(entityinlist instanceof EntityPlayer)) continue;
            this.checkInvPlayer((EntityPlayer)entityinlist, thisarmor);
        }
    }

    protected void checkInvPlayer(EntityPlayer player, ItemStack thisarmor) {
        for (ItemStack current : player.field_71071_by.field_70460_b) {
            if (current == null || current.func_77973_b() instanceof ItemDebug || current.func_77973_b() instanceof QuantumChestplateWirelessCharge || !(current.func_77973_b() instanceof IElectricItem)) continue;
            HelperUtils.chargeEUItemFromArmor(current, thisarmor);
        }
        for (ItemStack current : player.field_71071_by.field_70462_a) {
            if (current == null || current.func_77973_b() instanceof ItemDebug || !(current.func_77973_b() instanceof IElectricItem)) continue;
            HelperUtils.chargeEUItemFromArmor(current, thisarmor);
        }
    }

    protected boolean useJetpack(EntityPlayer player, boolean hoverMode) {
        int n;
        double d;
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (ElectricItem.manager.getCharge(jetpack) == 0.0) {
            return false;
        }
        float power = 1.0f;
        float dropPercentage = 0.05f;
        if (ElectricItem.manager.getCharge(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (ElectricItem.manager.getCharge(jetpack) / (this.getMaxCharge(jetpack) * (double)dropPercentage)));
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float f;
            float retruster = 3.5f;
            if (hoverMode) {
                retruster = 0.5f;
            }
            float forwardpower = power * retruster * 2.0f;
            if (f > 0.0f) {
                player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        double y = player.field_70163_u;
        int worldHeight = IC2.getWorldHeight((World)player.field_70170_p);
        if (d > (double)(n - 25)) {
            if (y > (double)worldHeight) {
                y = worldHeight;
            }
            power = (float)((double)power * (((double)worldHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), 0.6);
        if (hoverMode) {
            float maxHoverY = -0.025f;
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = -0.1f;
            }
            if (IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = 0.1f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        double consume = 8.0;
        if (hoverMode) {
            consume = 15.0;
        }
        ElectricItem.manager.discharge(jetpack, consume, Integer.MAX_VALUE, true, false, false);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        list.add(StatCollector.func_74838_a((String)"info.wirelesscharge.about"));
        if (Keyboard.isKeyDown((int)42)) {
            String isonoff = nbt.func_74767_n("active") ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"info.yes") : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"info.no");
            String isBuffOnOff = nbt.func_74767_n("potionbuffs") ? EnumChatFormatting.DARK_AQUA + StatCollector.func_74838_a((String)"info.buffs.yes") : EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"info.buffs.no");
            list.add(StatCollector.func_74838_a((String)"info.wirelesscharge.mode") + ": " + isonoff);
            list.add(StatCollector.func_74838_a((String)"info.wirelesscharge.radius") + ": " + EnumChatFormatting.DARK_GREEN + ConfigWI.chestplateChargingRadius + " " + StatCollector.func_74838_a((String)"info.wirelesscharge.blocks"));
            list.add(isBuffOnOff);
            list.add(EnumChatFormatting.ITALIC + "\u041d\u0430\u0436\u043c\u0438\u0442\u0435 Shift + Alt Key \u0447\u0442\u043e\u0431\u044b \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u043f\u043e\u043b\u0451\u0442\u0430");
            list.add(EnumChatFormatting.ITALIC + "\u041d\u0430\u0436\u043c\u0438\u0442\u0435 Shift + Jump Key \u0447\u0442\u043e\u0431\u044b \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.press.modeswitch.key") + " + Hub Expand Key " + StatCollector.func_74838_a((String)"info.to.switch"));
            list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.press.boost.key") + " " + StatCollector.func_74838_a((String)"info.and.sneak") + " " + StatCollector.func_74838_a((String)"info.to.switch.buff.mode"));
        } else {
            list.add(EnumChatFormatting.ITALIC + I18n.func_135052_a((String)"press.lshift", (Object[])new Object[0]));
        }
    }

    public int getEnergyPerDamage() {
        return 5000;
    }

    public double getDamageAbsorptionRatio() {
        return 1.1;
    }

    private double getBaseAbsorptionRatio() {
        return 0.4;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        ItemStack stack = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        list.add(stack);
        ItemStack stack1 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(stack1, 0.0, Integer.MAX_VALUE, true, false);
        list.add(stack1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("wirelessindustry:wirelesschestplate");
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "wirelessindustry:textures/armor/armor_WirelessChestPlate1710.png";
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public boolean isMetalArmor(ItemStack arg0, EntityPlayer arg1) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack arg0) {
        return true;
    }

    public Item getChargedItem(ItemStack arg0) {
        return this;
    }

    public Item getEmptyItem(ItemStack arg0) {
        return this;
    }

    public double getMaxCharge(ItemStack arg0) {
        return this.maxCharge;
    }

    public int getTier(ItemStack arg0) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack arg0) {
        return this.transferLimit;
    }
}

