/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.item.armor;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import ru.wirelessindustry.MainWI;
import ru.wirelessindustry.config.ConfigWI;
import ru.wirelessindustry.item.armor.IPrivateArmor;
import ru.wirelessindustry.utils.HelperUtils;

public class QuantumEnderChestplate
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor,
IPrivateArmor {
    public double maxCharge;
    protected double transferLimit;
    protected int tier;

    public QuantumEnderChestplate(String name) {
        super(ItemArmor.ArmorMaterial.DIAMOND, 0, 1);
        this.func_77655_b(name);
        this.func_77625_d(1);
        this.func_77656_e(27);
        this.func_77637_a(MainWI.tabwi);
        this.maxCharge = 1.5E7;
        this.transferLimit = 100000.0;
        this.tier = 4;
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("wirelessindustry:itemArmorEnderQuantumChestplate");
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_70170_p.field_73011_w.field_76574_g == 1) {
                return "wirelessindustry:textures/armor/enderquantum_charge.png";
            }
            return "wirelessindustry:textures/armor/enderquantum_1.png";
        }
        return "wirelessindustry:textures/armor/enderquantum_1.png";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        ItemStack stack = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        list.add(stack);
        ItemStack stack1 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(stack1, 0.0, Integer.MAX_VALUE, true, false);
        list.add(stack1);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            if (player.func_70093_af()) {
                if (NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile")) == null) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"chat.message.no.owner"), new Object[0]));
                } else if (!NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile")).equals((Object)player.func_146103_bH())) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"chat.message.you.cannot.clear.owner"), new Object[0]));
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"chat.message.owner.can.clear.owner"), new Object[0]));
                } else {
                    nbt.func_82580_o("ownerGameProfile");
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation(EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"chat.message.owner.successfully.cleared"), new Object[0]));
                }
            }
        }
        return stack;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        byte toggleTimer = nbt.func_74771_c("toggleTimer");
        if (NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile")) == null) {
            this.setArmorOwner(stack, player);
        }
        if (NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile")).equals((Object)player.func_146103_bH())) {
            if (world.field_73011_w.field_76574_g == 1) {
                ElectricItem.manager.charge(stack, (double)ConfigWI.enderChargeArmorValue, Integer.MAX_VALUE, true, false);
            }
            boolean jetpack = nbt.func_74767_n("jetpack");
            boolean hoverMode = nbt.func_74767_n("hoverMode");
            boolean jetpackUsed = false;
            if (IC2.keyboard.isSneakKeyDown(player) && IC2.keyboard.isJumpKeyDown(player) && toggleTimer == 0) {
                toggleTimer = 10;
                hoverMode = !hoverMode;
                nbt.func_74757_a("hoverMode", hoverMode);
                if (IC2.platform.isSimulating()) {
                    if (hoverMode) {
                        HelperUtils.sendColoredMessageToPlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432\u043a\u043b\u044e\u0447\u0451\u043d.", EnumChatFormatting.DARK_GREEN);
                    } else {
                        HelperUtils.sendColoredMessageToPlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d.", EnumChatFormatting.DARK_GREEN);
                    }
                }
            }
            if (IC2.keyboard.isSneakKeyDown(player) && IC2.keyboard.isAltKeyDown(player) && toggleTimer == 0) {
                toggleTimer = 10;
                jetpack = !jetpack;
                nbt.func_74757_a("jetpack", jetpack);
                if (IC2.platform.isSimulating()) {
                    if (jetpack) {
                        HelperUtils.sendColoredMessageToPlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043f\u043e\u043b\u0451\u0442\u0430 \u0432\u043a\u043b\u044e\u0447\u0451\u043d.", EnumChatFormatting.DARK_GREEN);
                    } else {
                        HelperUtils.sendColoredMessageToPlayer(player, "\u0420\u0435\u0436\u0438\u043c \u043f\u043e\u043b\u0451\u0442\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d.", EnumChatFormatting.DARK_GREEN);
                    }
                }
            }
            if (jetpack && (IC2.keyboard.isJumpKeyDown(player) || hoverMode && player.field_70181_x < -0.03)) {
                jetpackUsed = this.useJetpack(player, hoverMode);
            }
            if (toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
                nbt.func_74774_a("toggleTimer", toggleTimer);
            }
            if (jetpackUsed) {
                player.field_71069_bz.func_75142_b();
            }
            if (player.func_70027_ad()) {
                player.func_70066_B();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile")) == null) {
            list.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"info.eqarmor.noowner1"));
            list.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"info.eqarmor.noowner2"));
        } else if (!NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile")).equals((Object)player.func_146103_bH())) {
            list.add(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"info.eqarmor.incorrectowner1"));
            list.add(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"info.eqarmor.incorrectowner2"));
            list.add(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.eqarmor.owner.is") + ": " + NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile")).getName());
        } else {
            list.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"info.eqarmor.correctowner1"));
            list.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"info.eqarmor.correctowner2"));
            list.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"info.eqarmor.you.can.clear"));
            if (player.field_70170_p.field_73011_w.field_76574_g == 1) {
                list.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.eqarmor.is.charging.ender") + ": " + ConfigWI.enderChargeArmorValue + " EU/t");
            } else {
                list.add(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.eqarmor.go.to.ender.dim"));
            }
        }
        list.add(EnumChatFormatting.ITALIC + "\u041d\u0430\u0436\u043c\u0438\u0442\u0435 Shift + Alt Key \u0447\u0442\u043e\u0431\u044b \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u043f\u043e\u043b\u0451\u0442\u0430");
        list.add(EnumChatFormatting.ITALIC + "\u041d\u0430\u0436\u043c\u0438\u0442\u0435 Shift + Jump Key \u0447\u0442\u043e\u0431\u044b \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            if (player != null) {
                NBTTagCompound ownerNbt = new NBTTagCompound();
                NBTUtil.func_152460_a((NBTTagCompound)ownerNbt, (GameProfile)player.func_146103_bH());
                nbt.func_74782_a("ownerGameProfile", (NBTBase)ownerNbt);
            }
        }
    }

    protected boolean useJetpack(EntityPlayer player, boolean hoverMode) {
        int n;
        double d;
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if (ElectricItem.manager.getCharge(jetpack) == 0.0) {
            return false;
        }
        float power = 1.0f;
        float dropPercentage = 0.05f;
        if (ElectricItem.manager.getCharge(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (ElectricItem.manager.getCharge(jetpack) / (this.getMaxCharge(jetpack) * (double)dropPercentage)));
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float f;
            float retruster = 3.5f;
            if (hoverMode) {
                retruster = 0.5f;
            }
            float forwardpower = power * retruster * 2.0f;
            if (f > 0.0f) {
                player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        double y = player.field_70163_u;
        int worldHeight = IC2.getWorldHeight((World)player.field_70170_p);
        if (d > (double)(n - 25)) {
            if (y > (double)worldHeight) {
                y = worldHeight;
            }
            power = (float)((double)power * (((double)worldHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), 0.6);
        if (hoverMode) {
            float maxHoverY = -0.025f;
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = -0.1f;
            }
            if (IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = 0.1f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        double consume = 8.0;
        if (hoverMode) {
            consume = 10.0;
        }
        ElectricItem.manager.discharge(jetpack, consume, Integer.MAX_VALUE, true, false, false);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public double getDamageAbsorptionRatio() {
        return 1.1;
    }

    private double getBaseAbsorptionRatio() {
        return 0.4;
    }

    public int getEnergyPerDamage() {
        return 15000;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)armor);
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = Integer.MAX_VALUE;
        if (energyPerDamage > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
        }
        if (NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile")) == null || player instanceof EntityPlayer && !NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile")).equals((Object)((EntityPlayer)player).func_146103_bH())) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)armor);
        if (NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile")) == null || !NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("ownerGameProfile")).equals((Object)player.func_146103_bH())) {
            return 0;
        }
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public boolean isMetalArmor(ItemStack arg0, EntityPlayer arg1) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack arg0) {
        return false;
    }

    public Item getChargedItem(ItemStack arg0) {
        return this;
    }

    public Item getEmptyItem(ItemStack arg0) {
        return this;
    }

    public double getMaxCharge(ItemStack arg0) {
        return this.maxCharge;
    }

    public int getTier(ItemStack arg0) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack arg0) {
        return this.transferLimit;
    }
}

