/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.item.tool;

import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import ru.wirelessindustry.MainWI;
import ru.wirelessindustry.config.ConfigWI;
import ru.wirelessindustry.utils.HelperUtils;

public class ItemPortableCharger
extends Item
implements IElectricItem {
    protected final int tier;
    protected final double transferLimit;
    protected double maxCharge;

    public ItemPortableCharger() {
        this.func_77655_b("wi.portablecharger");
        this.func_111206_d("wirelessindustry:quantumwirelesscharger");
        this.func_77637_a(MainWI.tabwi);
        this.func_77625_d(1);
        this.func_77656_e(27);
        this.setNoRepair();
        this.maxCharge = 8.0E7;
        this.tier = 4;
        this.transferLimit = 20000.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean extraInformation) {
        if (Keyboard.isKeyDown((int)42)) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            info.add(I18n.func_135052_a((String)"info.wi.qwcharger.about", (Object[])new Object[0]));
            info.add(I18n.func_135052_a((String)"info.wi.qwcharger.radius", (Object[])new Object[0]) + ": " + nbt.func_74762_e("radius") + " " + I18n.func_135052_a((String)"info.wirelesscharge.blocks", (Object[])new Object[0]));
            info.add(I18n.func_135052_a((String)"info.wi.qwcharger.charge.rate", (Object[])new Object[0]) + ": " + String.format("%.0f", this.getRateFromModeRate(nbt.func_74765_d("rate"))) + " EU/t");
            info.add(nbt.func_74767_n("enabled_on") ? EnumChatFormatting.GREEN + I18n.func_135052_a((String)"info.wi.qwcharger.on", (Object[])new Object[0]) : EnumChatFormatting.RED + I18n.func_135052_a((String)"info.wi.qwcharger.off", (Object[])new Object[0]));
        } else {
            info.add(EnumChatFormatting.ITALIC + I18n.func_135052_a((String)"press.lshift", (Object[])new Object[0]));
        }
        if (Keyboard.isKeyDown((int)56)) {
            info.add(I18n.func_135052_a((String)"qwch.tooltip.change.rate", (Object[])new Object[0]) + " IC2 Mode Switch Key + " + I18n.func_135052_a((String)"qwch.tooltip.press.rmb", (Object[])new Object[0]));
            info.add(I18n.func_135052_a((String)"qwch.tooltip.change.radius", (Object[])new Object[0]));
            info.add(I18n.func_135052_a((String)"qwch.tooltip.on_off", (Object[])new Object[0]));
        } else {
            info.add(EnumChatFormatting.ITALIC + I18n.func_135052_a((String)"press.leftalt", (Object[])new Object[0]));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            if (player.func_70093_af()) {
                int radius = nbt.func_74762_e("radius");
                if (++radius > 15) {
                    radius = 1;
                }
                nbt.func_74768_a("radius", radius);
                HelperUtils.sendChatMessageMultiUnicolored(player, "chat.message.portablecharger.radius", EnumChatFormatting.GOLD, new IChatComponent[]{new ChatComponentText(": " + radius + " "), new ChatComponentTranslation("info.wirelesscharge.blocks", new Object[0])});
            } else if (IC2.keyboard.isModeSwitchKeyDown(player)) {
                short chargeModeRate = nbt.func_74765_d("rate");
                if ((chargeModeRate = (short)(chargeModeRate + 1)) > 6) {
                    chargeModeRate = 0;
                }
                nbt.func_74777_a("rate", chargeModeRate);
                HelperUtils.sendChatMessageMultiUnicolored(player, "chat.message.portablecharger.chargerate", EnumChatFormatting.GREEN, new IChatComponent[]{new ChatComponentText(": " + String.format("%.0f", this.getRateFromModeRate(chargeModeRate))), new ChatComponentText(" EU/t")});
            } else {
                boolean enabled = nbt.func_74767_n("enabled_on");
                enabled = !enabled;
                nbt.func_74757_a("enabled_on", enabled);
                HelperUtils.sendColoredMessageToPlayer(player, enabled ? "chat.message.portablecharger.on" : "chat.message.portablecharger.off", enabled ? EnumChatFormatting.AQUA : EnumChatFormatting.LIGHT_PURPLE);
            }
        }
        return stack;
    }

    protected double getRateFromModeRate(short modeRate) {
        switch (modeRate) {
            case 0: {
                return 2048.0;
            }
            case 1: {
                return 4096.0;
            }
            case 2: {
                return 8192.0;
            }
            case 3: {
                return 16384.0;
            }
            case 4: {
                return 32768.0;
            }
            case 5: {
                return 65536.0;
            }
            case 6: {
                return 131072.0;
            }
        }
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this);
        ItemStack discharged = new ItemStack((Item)this);
        ElectricItem.manager.charge(charged, Double.MAX_VALUE, Integer.MAX_VALUE, true, false);
        ElectricItem.manager.charge(discharged, 0.0, Integer.MAX_VALUE, true, false);
        StackUtil.getOrCreateNbtData((ItemStack)charged).func_74768_a("radius", 5);
        StackUtil.getOrCreateNbtData((ItemStack)discharged).func_74768_a("radius", 5);
        itemList.add(charged);
        itemList.add(discharged);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            StackUtil.getOrCreateNbtData((ItemStack)stack).func_74768_a("radius", 5);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            EntityPlayer player = (EntityPlayer)entity;
            int radius = nbt.func_74762_e("radius");
            if (nbt.func_74767_n("enabled_on")) {
                for (double x = player.field_70165_t - (double)radius; x < player.field_70165_t + (double)radius + 1.0; x += 1.0) {
                    for (double y = player.field_70163_u - (double)radius; y < player.field_70163_u + (double)radius + 1.0; y += 1.0) {
                        for (double z = player.field_70161_v - (double)radius; z < player.field_70161_v + (double)radius + 1.0; z += 1.0) {
                            IEnergyReceiver rfTile;
                            TileEntity te = world.func_147438_o((int)x, (int)y, (int)z);
                            short rateMode = nbt.func_74765_d("rate");
                            double qwchCharge = ElectricItem.manager.getCharge(stack);
                            if (te instanceof IEnergySink) {
                                IEnergySink sink = (IEnergySink)te;
                                double demandedEnergy = sink.getDemandedEnergy();
                                if (!(demandedEnergy > 0.0) || !(qwchCharge > 0.0)) continue;
                                double realSent = Math.min(demandedEnergy, Math.min(qwchCharge, this.getRateFromModeRate(rateMode)));
                                sink.injectEnergy(ForgeDirection.UNKNOWN, realSent, 1.0);
                                ElectricItem.manager.discharge(stack, realSent, Integer.MAX_VALUE, true, false, false);
                                continue;
                            }
                            if (!(te instanceof IEnergyReceiver) || (rfTile = (IEnergyReceiver)te).getMaxEnergyStored(ForgeDirection.UNKNOWN) - rfTile.getEnergyStored(ForgeDirection.UNKNOWN) <= 0 || !(qwchCharge > 0.0)) continue;
                            ElectricItem.manager.discharge(stack, (double)rfTile.receiveEnergy(ForgeDirection.UNKNOWN, (int)Math.min(qwchCharge, this.getRateFromModeRate(rateMode)) * ConfigWI.EUToRF_Multiplier, false) / (double)ConfigWI.EUToRF_Multiplier, Integer.MAX_VALUE, true, false, false);
                        }
                    }
                }
            }
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }
}

