/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.item.weapon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import ru.wirelessindustry.MainWI;

public class ItemCompositeSaber
extends ItemTool
implements IElectricItem {
    private final boolean isLooting5;
    private final double useamount;
    private final Set<Object> whitelist = new HashSet<Object>(Arrays.asList(Blocks.field_150321_G, Material.field_151585_k, Material.field_151582_l, Material.field_151589_v, Material.field_151584_j, Material.field_151572_C));
    public double maxenergy;
    protected double transferlimit;
    protected int tier;
    private IIcon[] textures;

    public ItemCompositeSaber(String name, boolean isLootingV, double energymax, int tier, double useAmount) {
        super(0.0f, Item.ToolMaterial.EMERALD, new HashSet());
        this.func_77655_b(name);
        this.maxenergy = energymax;
        this.tier = tier;
        this.transferlimit = 256.0;
        this.isLooting5 = isLootingV;
        this.useamount = useAmount;
        this.func_77656_e(27);
        this.func_77637_a(MainWI.tabwi);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        info.add(StatCollector.func_74838_a((String)"press.rmb.saber"));
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        Material material = block.func_149688_o();
        if (this.whitelist.contains(block) && this.whitelist.contains(material)) {
            return true;
        }
        return super.canHarvestBlock(block, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isLooting5 ? EnumRarity.rare : EnumRarity.uncommon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        ItemStack discharged = new ItemStack((Item)this);
        ItemStack charged = new ItemStack((Item)this);
        ElectricItem.manager.charge(discharged, 0.0, Integer.MAX_VALUE, true, false);
        ElectricItem.manager.charge(charged, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false);
        itemList.add(discharged);
        itemList.add(charged);
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public boolean canProvideEnergy(ItemStack var1) {
        return false;
    }

    public Item getChargedItem(ItemStack var1) {
        return this;
    }

    public Item getEmptyItem(ItemStack var1) {
        return this;
    }

    public double getMaxCharge(ItemStack var1) {
        return this.maxenergy;
    }

    public int getTier(ItemStack var1) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack var1) {
        return this.transferlimit;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityplayer) {
        if (!IC2.platform.isSimulating()) {
            return itemStack;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        if (nbtData.func_74767_n("active")) {
            nbtData.func_74757_a("active", false);
            this.changeEnchantments(itemStack, false);
            this.updateAttributes(nbtData);
        } else if (ElectricItem.manager.canUse(itemStack, 4.0)) {
            nbtData.func_74757_a("active", true);
            this.changeEnchantments(itemStack, true);
            this.updateAttributes(nbtData);
        }
        return super.func_77659_a(itemStack, world, entityplayer);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase source) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (!nbtData.func_74767_n("active")) {
            return true;
        }
        if (IC2.platform.isSimulating()) {
            this.drainSaber(stack, this.useamount, source);
        }
        return true;
    }

    protected void drainSaber(ItemStack itemStack, double amount, EntityLivingBase entity) {
        if (!ElectricItem.manager.use(itemStack, amount, entity)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
            nbtData.func_74757_a("active", false);
            this.changeEnchantments(itemStack, false);
            this.updateAttributes(nbtData);
        }
    }

    public boolean func_150894_a(ItemStack p_150894_1_, World p_150894_2_, Block p_150894_3_, int p_150894_4_, int p_150894_5_, int p_150894_6_, EntityLivingBase p_150894_7_) {
        return true;
    }

    private void changeEnchantments(ItemStack stack, boolean isActiveEnchantment) {
        Map enchmapsaber = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (isActiveEnchantment) {
            if (this.isLooting5) {
                enchmapsaber.put(Enchantment.field_77335_o.field_77352_x, 5);
            } else {
                enchmapsaber.put(Enchantment.field_77335_o.field_77352_x, 3);
            }
        } else {
            enchmapsaber.remove(Enchantment.field_77335_o.field_77352_x);
        }
        EnchantmentHelper.func_82782_a((Map)enchmapsaber, (ItemStack)stack);
    }

    private void updateAttributes(NBTTagCompound nbtData) {
        boolean active = nbtData.func_74767_n("active");
        double damage = active ? 10.0 : (double)Item.ToolMaterial.EMERALD.func_78000_c();
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74778_a("AttributeName", SharedMonsterAttributes.field_111264_e.func_111108_a());
        entry.func_74772_a("UUIDMost", field_111210_e.getMostSignificantBits());
        entry.func_74772_a("UUIDLeast", field_111210_e.getLeastSignificantBits());
        entry.func_74778_a("Name", "Tool modifier");
        entry.func_74780_a("Amount", damage);
        entry.func_74768_a("Operation", 0);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)entry);
        nbtData.func_74782_a("AttributeModifiers", (NBTBase)list);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.textures = new IIcon[4];
        this.textures[0] = iconRegister.func_94245_a("wirelessindustry:itemCompositeLootingSaber_off");
        this.textures[1] = iconRegister.func_94245_a("wirelessindustry:itemCompositeLootingSaber_active");
        this.textures[2] = iconRegister.func_94245_a("wirelessindustry:itemCompositeHunterSaber_off");
        this.textures[3] = iconRegister.func_94245_a("wirelessindustry:itemCompositeHunterSaber_active");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int pass) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        if (nbtData.func_74767_n("active")) {
            if (this.isLooting5) {
                return this.textures[3];
            }
            return this.textures[1];
        }
        if (this.isLooting5) {
            return this.textures[2];
        }
        return this.textures[0];
    }
}

