/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.tiles;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessable;
import ic2.core.network.NetworkManager;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import ru.wirelessindustry.container.ContainerPFPConverter;
import ru.wirelessindustry.gui.GuiPFPConvertor;
import ru.wirelessindustry.slots.InvSlotProcessablePFP;

public class PFPConvertorTile
extends TileEntityInventory
implements IEnergySink,
IHasGui,
INetworkClientTileEntityEventListener {
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "blockoutput", 1, 1);
    public int operationLength = 4;
    public int maxStorageEU = 10000000;
    public double energyEU = 0.0;
    public int tier = 8;
    public String pfpconvertorname = "pfpconverter.name";
    public InvSlotProcessable inputSlotA = new InvSlotProcessablePFP(this, "oreinput", 1, 1);
    protected short progress = 0;
    protected int energyPerTick = 5000;
    private boolean addedToEnergyNet = false;
    private double hot_energy_amount = 1500000.0;

    public RecipeOutput getOutput() {
        if (this.inputSlotA.isEmpty()) {
            return null;
        }
        RecipeOutput output = this.inputSlotA.process();
        if (output == null) {
            return null;
        }
        return this.outputSlot.canAdd(output.items) ? output : null;
    }

    public void operate(RecipeOutput output) {
        this.inputSlotA.consume();
        this.outputSlot.add(output.items);
    }

    public double getHotState() {
        return this.hot_energy_amount;
    }

    public boolean getIsHot() {
        return this.energyEU >= this.getHotState();
    }

    protected void updateEntityServer() {
        RecipeOutput output;
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.energyEU > 0.0) {
            this.energyEU -= Math.min(256.0, this.energyEU);
        }
        if ((output = this.getOutput()) != null && this.getIsHot()) {
            this.setActive(true);
            if (this.progress == 0) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
            }
            this.progress = (short)(this.progress + 1);
            this.energyEU -= (double)this.energyPerTick;
            if (this.progress >= this.operationLength) {
                this.operate(output);
                this.progress = 0;
                needsInvUpdate = true;
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
            }
            if (output == null) {
                this.progress = 0;
            }
            this.setActive(false);
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public int gaugeEnergyScaled(int i) {
        return (int)(this.energyEU * (double)i / (double)this.maxStorageEU);
    }

    public double gaugeProgressScaled() {
        return (double)this.progress / (double)this.operationLength;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        nbttagcompound.func_74780_a("energy", this.energyEU);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
        this.energyEU = nbttagcompound.func_74769_h("energy");
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorageEU - this.energyEU;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double de = this.getDemandedEnergy();
        if (amount == 0.0) {
            return 0.0;
        }
        if (de <= 0.0) {
            return amount;
        }
        if (amount >= de) {
            this.energyEU += de;
            return amount - de;
        }
        this.energyEU += amount;
        return 0.0;
    }

    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return true;
    }

    public void onNetworkEvent(EntityPlayer entityPlayer, int i) {
    }

    public ContainerBase<PFPConvertorTile> getGuiContainer(EntityPlayer player) {
        return new ContainerPFPConverter(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean b) {
        return new GuiPFPConvertor(new ContainerPFPConverter(player, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public String func_145825_b() {
        return "PFP Converter";
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }
}

