/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.tiles;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.network.NetworkManager;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import ru.wirelessindustry.container.ContainerWChargerNew;
import ru.wirelessindustry.gui.GuiWChargerNew;
import ru.wirelessindustry.handlerwireless.WirelessTransfer;
import ru.wirelessindustry.tiles.IWirelessCharger;

public class TileEntityWirelessCharger
extends TileEntityInventory
implements IEnergySink,
IWirelessCharger,
INetworkDataProvider,
IHasGui,
INetworkClientTileEntityEventListener {
    public int maxStorage;
    public double energy = 0.0;
    public int tier;
    public int output;
    public boolean addedToEnergyNet = false;
    public boolean loaded;
    public int playercount = 0;
    public String chargerName;
    protected GameProfile owner = null;
    protected int radiusofcharge = 10;
    protected boolean isPrivate;

    public TileEntityWirelessCharger(String name, boolean isPrivate, int maxstorage, int tier) {
        this.tier = tier;
        this.output = 128;
        this.maxStorage = maxstorage;
        this.isPrivate = isPrivate;
        this.loaded = false;
        this.chargerName = name;
    }

    public boolean getIsPrivate() {
        return this.isPrivate;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.owner != null) {
            NBTTagCompound ownerNbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)ownerNbt, (GameProfile)this.owner);
            nbttagcompound.func_74782_a("ownerGameProfileCharger", (NBTBase)ownerNbt);
        }
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74768_a("maxenergy", this.maxStorage);
        nbttagcompound.func_74768_a("radiusofcharge", this.radiusofcharge);
        nbttagcompound.func_74757_a("isPrivate", this.isPrivate);
    }

    public String func_145825_b() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("ownerGameProfileCharger")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("ownerGameProfileCharger"));
        }
        this.energy = nbttagcompound.func_74769_h("energy");
        this.maxStorage = nbttagcompound.func_74762_e("maxenergy");
        this.radiusofcharge = nbttagcompound.func_74762_e("radiusofcharge");
        this.isPrivate = nbttagcompound.func_74767_n("isPrivate");
    }

    public int gaugeEnergyScaled(int i) {
        return (int)(this.energy * (double)i / (double)this.maxStorage);
    }

    public int getRadiusOfCharge() {
        return this.radiusofcharge;
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    protected void updateEntityServer() {
        if (this.energy > (double)this.maxStorage) {
            this.energy = this.maxStorage;
        }
        this.playercount = WirelessTransfer.chargeplayerhandler.checkPlayersAround(this.isPrivate, this, this.radiusofcharge, this.field_145850_b);
    }

    public void changeRadius(int value) {
        this.radiusofcharge = value < 0 ? Math.max(this.radiusofcharge + value, 1) : Math.min(this.radiusofcharge + value, 25);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double de = this.getDemandedEnergy();
        if (amount == 0.0) {
            return 0.0;
        }
        if (de <= 0.0) {
            return amount;
        }
        if (amount >= de) {
            this.energy += de;
            return amount - de;
        }
        this.energy += amount;
        return 0.0;
    }

    public void setPlayerProfile(GameProfile profile) {
        this.owner = profile;
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "owner");
    }

    public boolean permitsAccess(GameProfile profile) {
        if (profile == null) {
            return this.owner == null;
        }
        if (!this.field_145850_b.field_72995_K && this.owner == null) {
            this.owner = profile;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "owner");
            return true;
        }
        return this.owner.equals((Object)profile);
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void decreaseEnergy(double amount) {
        this.energy -= Math.min(this.energy, amount);
    }

    @Override
    public double getCurrentEnergyInCharger() {
        return this.energy;
    }

    @Override
    public GameProfile getOwnerCharger() {
        return this.owner;
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    public List<String> getNetworkedFields() {
        List ret = super.getNetworkedFields();
        ret.add("owner");
        return ret;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                this.changeRadius(1);
                break;
            }
            case 1: {
                this.changeRadius(-1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiWChargerNew(new ContainerWChargerNew(player, this));
    }

    public ContainerBase<TileEntityWirelessCharger> getGuiContainer(EntityPlayer player) {
        return new ContainerWChargerNew(player, this);
    }

    public void onGuiClosed(EntityPlayer player) {
    }
}

