/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.tiles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityReplicator;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import ru.wirelessindustry.config.ConfigWI;
import ru.wirelessindustry.container.ContainerLiquidMatterCollector;
import ru.wirelessindustry.gui.GuiLiquidMatterCollector;

public class TileLiquidMatterCollector
extends TileEntityInventory
implements IFluidHandler,
IHasGui,
INetworkClientTileEntityEventListener {
    public final String mattercollectorname;
    protected final FluidTank fluidTank = new FluidTank(ConfigWI.matterCollectorCapacity);
    private boolean isActive = false;

    public TileLiquidMatterCollector() {
        this("mattercollector.name");
    }

    public TileLiquidMatterCollector(String collectorname) {
        this.mattercollectorname = collectorname;
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.getIsActive() && !this.field_145850_b.func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).field_150816_i.isEmpty()) {
            for (TileEntity tile : new ArrayList(this.func_145831_w().func_72938_d((int)this.field_145851_c, (int)this.field_145849_e).field_150816_i.values())) {
                if (tile.getClass() == TileEntityReplicator.class || !(tile instanceof TileEntityLiquidTankElectricMachine)) continue;
                this.tryTransferFrom((TileEntityLiquidTankElectricMachine)tile);
            }
        }
    }

    public int getPercentagePart(int factor) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0 : (int)((double)factor * (double)this.getFluidTank().getFluidAmount() / (double)this.getFluidTank().getCapacity());
    }

    public double getLiquidAmountPercentage() {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0.0 : 100.0 * (double)this.getFluidTank().getFluidAmount() / (double)this.getFluidTank().getCapacity();
    }

    public int getIntegerPercentage() {
        return (int)this.getLiquidAmountPercentage();
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void reverseActive() {
        this.isActive = !this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    private void tryTransferFrom(TileEntityLiquidTankElectricMachine targetTile) {
        FluidStack simulateDrainAmount;
        if (targetTile.getFluidStackfromTank() != null && targetTile.getFluidStackfromTank().getFluid() == BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter) && targetTile.getTankAmount() > 0 && (simulateDrainAmount = targetTile.getFluidTank().drain(targetTile.getTankAmount(), false)) != null) {
            int simulateFillAmount = this.getFluidTank().fill(simulateDrainAmount, false);
            int transferAmount = Math.min(simulateFillAmount, simulateDrainAmount.amount);
            this.getFluidTank().fill(targetTile.getFluidTank().drain(transferAmount, true), true);
        }
    }

    public int gaugeLiquidScaled(int i) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0 : this.getFluidTank().getFluidAmount() * i / this.getFluidTank().getCapacity();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return !this.canFill(from, resource.getFluid()) ? 0 : this.getFluidTank().fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && resource.isFluidEqual(this.getFluidTank().getFluid())) {
            return !this.canDrain(from, resource.getFluid()) ? null : this.getFluidTank().drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return !this.canDrain(from, null) ? null : this.getFluidTank().drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == BlocksItems.getFluid((InternalName)InternalName.fluidUuMatter);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getFluidTank().getInfo()};
    }

    public String func_145825_b() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.isActive = nbttagcompound.func_74767_n("active");
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("active", this.isActive);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        ItemStack drop = super.getWrenchDrop(player);
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)drop);
        nbt.func_74757_a("active", this.isActive);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbt.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        return drop;
    }

    public ContainerBase<TileLiquidMatterCollector> getGuiContainer(EntityPlayer player) {
        return new ContainerLiquidMatterCollector(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiLiquidMatterCollector(new ContainerLiquidMatterCollector(player, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public void onNetworkEvent(EntityPlayer player, int id) {
        if (id == 1) {
            this.reverseActive();
        }
    }
}

