/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.tiles;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import ru.wirelessindustry.container.ContainerVajraCharger;

public class TileVajraChargerElectric
extends TileEntity
implements IEnergySink,
IInventory {
    public int tier;
    public int maxStorage;
    public double energy = 0.0;
    public boolean loaded = false;
    private boolean addedToEnergyNet;

    public TileVajraChargerElectric(int tier1, int storage1) {
        this.tier = tier1;
        this.maxStorage = storage1;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.onLoaded();
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void decreaseEnergy(double amountdecrease) {
        this.energy -= Math.min(this.energy, amountdecrease);
    }

    public void onUnloaded() {
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        this.loaded = false;
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer) {
        return new ContainerVajraCharger(inventoryplayer, this);
    }

    public int gaugeEnergyScaled(int i) {
        return (int)(this.energy * (double)i / (double)this.maxStorage);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.energy > (double)this.maxStorage) {
            this.energy = this.maxStorage;
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74769_h("energy");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    public boolean acceptsEnergyFrom(TileEntity nameTileEntity, ForgeDirection nameForgeDirection) {
        return true;
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection nameForgeDirection, double amount, double voltage) {
        double de = this.getDemandedEnergy();
        if (amount == 0.0) {
            return 0.0;
        }
        if (de <= 0.0) {
            return amount;
        }
        if (amount >= de) {
            this.energy += de;
            return amount - de;
        }
        this.energy += amount;
        return 0.0;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }
}

