/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.tiles;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.network.NetworkManager;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import ru.wirelessindustry.container.ContainerWPPersonal;
import ru.wirelessindustry.handlerwireless.WirelessTransfer;
import ru.wirelessindustry.tiles.IWirelessPanel;
import ru.wirelessindustry.tiles.TileWirelessStorageBasePersonal;

public class TileWPBasePersonal
extends TileEntity
implements IEnergySource,
IInventory,
IPersonalBlock,
INetworkDataProvider,
INetworkUpdateListener,
IWirelessPanel,
INetworkClientTileEntityEventListener {
    private final int machineTier;
    private final ItemStack[] chargeSlots;
    public int generating;
    public int genDay;
    public int genNight;
    public boolean initialized;
    public boolean sunIsUp;
    public boolean skyIsVisible;
    public boolean addedToEnergyNet;
    public double storage;
    public String panelName;
    public int production;
    public int maxStorage;
    public boolean loaded = false;
    public int channel;
    public boolean isconnected;
    protected int wirelesstransferlimit;
    protected GameProfile owner = null;
    private boolean noSunWorld;
    private boolean wetBiome;
    private int lastX;
    private int lastY;
    private int lastZ;
    private int numUsingPlayers;

    public TileWPBasePersonal(String name, int tier, int gDay, int gNight, int output, int maxStorage, int wirelesstransfer) {
        this.genDay = gDay;
        this.genNight = gNight;
        this.storage = 0.0;
        this.panelName = name;
        this.sunIsUp = false;
        this.skyIsVisible = false;
        this.maxStorage = maxStorage;
        this.chargeSlots = new ItemStack[4];
        this.initialized = false;
        this.production = output;
        this.lastX = this.field_145851_c;
        this.lastY = this.field_145848_d;
        this.lastZ = this.field_145849_e;
        this.machineTier = tier;
        this.isconnected = false;
        this.wirelesstransferlimit = wirelesstransfer;
        this.channel = 1;
    }

    private static boolean areSameChannel(int channelwpp, int channelwsb, GameProfile id1, GameProfile id2) {
        return channelwpp == channelwsb && (id1 != null && id1.equals((Object)id2) || id1 == id2);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.onLoaded();
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.storage);
        nbttagcompound.func_74757_a("isconnected", this.isconnected);
        nbttagcompound.func_74768_a("channel", this.channel);
        if (this.owner != null) {
            NBTTagCompound ownerNbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)ownerNbt, (GameProfile)this.owner);
            nbttagcompound.func_74782_a("ownerGameProfile", (NBTBase)ownerNbt);
        }
    }

    protected void operateWirelessTransfer() {
        if (!this.field_145850_b.field_72995_K && !this.func_145837_r() && TileWirelessStorageBasePersonal.mapofThis.containsKey(true) & TileWirelessStorageBasePersonal.mapofThis.containsValue(TileWirelessStorageBasePersonal.listofstorages) && !TileWirelessStorageBasePersonal.mapofThis.get(true).isEmpty()) {
            for (TileWirelessStorageBasePersonal te : TileWirelessStorageBasePersonal.mapofThis.get(true)) {
                if (!TileWPBasePersonal.areSameChannel(this.channel, te.channel, this.owner, te.owner)) continue;
                this.isconnected = true;
                WirelessTransfer.transmithandler.transferEnergyWirelessly(this, te);
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("ownerGameProfile")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("ownerGameProfile"));
        }
        this.storage = nbttagcompound.func_74769_h("energy");
        this.isconnected = nbttagcompound.func_74767_n("isconnected");
        this.channel = nbttagcompound.func_74762_e("channel");
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onUnloaded() {
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        this.loaded = false;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.initialized) {
            this.intialize();
        }
        if (this.lastX != this.field_145851_c || this.lastZ != this.field_145849_e || this.lastY != this.field_145848_d) {
            this.lastX = this.field_145851_c;
            this.lastY = this.field_145848_d;
            this.lastZ = this.field_145849_e;
            this.onUnloaded();
            this.intialize();
        }
        this.gainFuel();
        this.operateWirelessTransfer();
        if (this.numUsingPlayers == 0 | this.numUsingPlayers > 0) {
            this.permitsAccess(this.owner);
        }
        if (this.generating > 0) {
            this.storage = this.storage + (double)this.generating <= (double)this.maxStorage ? (this.storage += (double)this.generating) : (double)this.maxStorage;
        }
        boolean needInvUpdate = false;
        for (ItemStack chargeSlot : this.chargeSlots) {
            if (chargeSlot == null || !(chargeSlot.func_77973_b() instanceof IElectricItem) || !(this.storage > 0.0)) continue;
            double sentPacket = ElectricItem.manager.charge(chargeSlot, this.storage, Integer.MAX_VALUE, false, false);
            if (sentPacket > 0.0) {
                needInvUpdate = true;
            }
            this.storage -= sentPacket;
        }
        if (needInvUpdate) {
            this.func_70296_d();
        }
    }

    public void intialize() {
        this.wetBiome = this.field_145850_b.func_72959_q().func_76935_a(this.field_145851_c, this.field_145849_e).func_76744_g() > 0;
        this.noSunWorld = this.field_145850_b.field_73011_w.field_76576_e;
        this.updateVisibility();
        this.initialized = true;
        if (!this.addedToEnergyNet) {
            this.onLoaded();
        }
    }

    public void updateVisibility() {
        boolean rainWeather = this.wetBiome && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
        this.sunIsUp = this.field_145850_b.func_72935_r() && !rainWeather;
        this.skyIsVisible = this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !this.noSunWorld;
    }

    public void gainFuel() {
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.updateVisibility();
        }
        if (this.sunIsUp && this.skyIsVisible) {
            this.generating = this.genDay;
            return;
        }
        if (this.skyIsVisible) {
            this.generating = this.genNight;
            return;
        }
        this.generating = 0;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    public double getOfferedEnergy() {
        return Math.min((double)this.production, this.storage);
    }

    public void drawEnergy(double amount) {
        this.storage -= (double)((int)amount);
    }

    public int getSourceTier() {
        return this.machineTier;
    }

    public void changeChannel(int value) {
        this.channel = Math.max(this.channel + value, 1);
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(int channel) {
        this.channel = channel;
    }

    public void setPlayerProfile(GameProfile profile) {
        this.owner = profile;
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "owner");
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        ++this.numUsingPlayers;
        this.syncNumUsingPlayers();
    }

    public void func_70305_f() {
        --this.numUsingPlayers;
        this.syncNumUsingPlayers();
    }

    public boolean func_145842_c(int event, int data) {
        if (event == 1) {
            this.numUsingPlayers = data;
            return true;
        }
        return false;
    }

    private void syncNumUsingPlayers() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.numUsingPlayers);
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public int gaugeEnergyScaled(int i) {
        return (int)(this.storage * (double)i / (double)this.maxStorage);
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer) {
        return new ContainerWPPersonal(inventoryplayer, this);
    }

    public boolean permitsAccess(GameProfile profile) {
        if (profile == null) {
            return this.owner == null;
        }
        if (!this.field_145850_b.field_72995_K && this.owner == null) {
            this.owner = profile;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "owner");
            return true;
        }
        return this.owner.equals((Object)profile);
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public void onNetworkUpdate(String field) {
    }

    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("owner");
        return ret;
    }

    @Override
    public double getCurrentEnergyInPanel() {
        return this.storage;
    }

    @Override
    public int getWirelessTransferLimit() {
        return this.wirelesstransferlimit;
    }

    @Override
    public void extractEnergy(double amount) {
        this.storage -= Math.min(amount, this.storage);
    }

    public void onNetworkEvent(EntityPlayer player, int id) {
        switch (id) {
            case 0: {
                this.changeChannel(1);
                break;
            }
            case 1: {
                this.changeChannel(-1);
            }
        }
    }
}

