/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.tiles;

import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.util.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import ru.wirelessindustry.container.ContainerWirelessMachinesChargerNew;
import ru.wirelessindustry.gui.GuiWirelessMachinesChargerNew;
import ru.wirelessindustry.tiles.IWirelessMachineCharger;
import ru.wirelessindustry.utils.WirelessUtil;

public class TileWirelessMachinesChargerBase
extends TileEntityInventory
implements IEnergySink,
IWirelessMachineCharger,
IEnergyReceiver,
INetworkClientTileEntityEventListener,
IHasGui {
    public int energyRF;
    public double energyEU = 0.0;
    public String chargername;
    protected int maxStorageRF;
    protected double maxStorageEU;
    protected int tier;
    protected boolean addedToEnergyNet = false;
    private double chargeRate;
    private short mode;
    private boolean chargeEU;
    private boolean chargeRF;
    private boolean blockStoragesCharge = false;

    public TileWirelessMachinesChargerBase(double maxStorageEU, int maxStorageRF, int tier, String name) {
        this.maxStorageEU = maxStorageEU;
        this.energyRF = 0;
        this.maxStorageRF = maxStorageRF;
        this.chargername = name;
        this.tier = tier;
        this.chargeEU = true;
        this.chargeRF = true;
        this.chargeRate = 512.0;
        this.mode = 0;
    }

    public int gaugeEUScaled(int i) {
        return (int)(this.energyEU * (double)i / this.maxStorageEU);
    }

    public int gaugeRFScaled(int i) {
        return (int)((double)this.energyRF * (double)i / (double)this.maxStorageRF);
    }

    public boolean isChargingEU() {
        return this.chargeEU;
    }

    public boolean isChargingRF() {
        return this.chargeRF;
    }

    public boolean isBlockStoragesCharge() {
        return this.blockStoragesCharge;
    }

    @Override
    public double getChargeRate() {
        return this.chargeRate;
    }

    @Override
    public short getMode() {
        return this.mode;
    }

    private void incrementChargeRate() {
        this.mode = (short)(this.mode + 1);
        if (this.mode > 8) {
            this.mode = 0;
        }
        switch (this.mode) {
            case 0: {
                this.chargeRate = 512.0;
                break;
            }
            case 1: {
                this.chargeRate = 1024.0;
                break;
            }
            case 2: {
                this.chargeRate = 2048.0;
                break;
            }
            case 3: {
                this.chargeRate = 4096.0;
                break;
            }
            case 4: {
                this.chargeRate = 8192.0;
                break;
            }
            case 5: {
                this.chargeRate = 16384.0;
                break;
            }
            case 6: {
                this.chargeRate = 32768.0;
                break;
            }
            case 7: {
                this.chargeRate = 65536.0;
            }
        }
    }

    private void decrementChargeRate() {
        this.mode = (short)(this.mode - 1);
        if (this.mode < 0) {
            this.mode = (short)8;
        }
        switch (this.mode) {
            case 0: {
                this.chargeRate = 512.0;
                break;
            }
            case 1: {
                this.chargeRate = 1024.0;
                break;
            }
            case 2: {
                this.chargeRate = 2048.0;
                break;
            }
            case 3: {
                this.chargeRate = 4096.0;
                break;
            }
            case 4: {
                this.chargeRate = 8192.0;
                break;
            }
            case 5: {
                this.chargeRate = 16384.0;
                break;
            }
            case 6: {
                this.chargeRate = 32768.0;
                break;
            }
            case 7: {
                this.chargeRate = 65536.0;
            }
        }
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        WirelessUtil.iterateEnergyTiles(this, this.chargeEU, this.chargeRF, this.blockStoragesCharge);
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        ItemStack drop = super.getWrenchDrop(player);
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)drop);
        nbt.func_74780_a("energyEU", this.energyEU);
        nbt.func_74768_a("energyRF", this.energyRF);
        nbt.func_74757_a("chargeEU", this.chargeEU);
        nbt.func_74757_a("chargeRF", this.chargeRF);
        nbt.func_74780_a("chargeRate", this.chargeRate);
        nbt.func_74777_a("chargerMode", this.mode);
        nbt.func_74757_a("blockStoragesCharge", this.blockStoragesCharge);
        return drop;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("energyEU", this.energyEU);
        nbt.func_74768_a("energyRF", this.energyRF);
        nbt.func_74757_a("chargeEU", this.chargeEU);
        nbt.func_74757_a("chargeRF", this.chargeRF);
        nbt.func_74780_a("chargeRate", this.chargeRate);
        nbt.func_74777_a("chargerMode", this.mode);
        nbt.func_74757_a("blockStoragesCharge", this.blockStoragesCharge);
    }

    public String func_145825_b() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyEU = nbt.func_74769_h("energyEU");
        this.energyRF = nbt.func_74762_e("energyRF");
        this.chargeEU = nbt.func_74767_n("chargeEU");
        this.chargeRF = nbt.func_74767_n("chargeRF");
        this.chargeRate = nbt.func_74769_h("chargeRate");
        this.mode = nbt.func_74765_d("chargerMode");
        this.blockStoragesCharge = nbt.func_74767_n("blockStoragesCharge");
    }

    @Override
    public void decreaseEnergy(double amount) {
        this.energyEU -= Math.min(this.energyEU, amount);
    }

    @Override
    public void decreaseEnergyRF(int amount) {
        this.energyRF -= Math.min(this.energyRF, amount);
    }

    @Override
    public World getChargerWorld() {
        return this.field_145850_b;
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double getDemandedEnergy() {
        return this.maxStorageEU - this.energyEU;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double de = this.getDemandedEnergy();
        if (amount == 0.0) {
            return 0.0;
        }
        if (de <= 0.0) {
            return amount;
        }
        if (amount >= de) {
            this.energyEU += de;
            return amount - de;
        }
        this.energyEU += amount;
        return 0.0;
    }

    @Override
    public double getChargerEnergyEU() {
        return this.energyEU;
    }

    @Override
    public int getChargerEnergyRF() {
        return this.energyRF;
    }

    public double getMaxChargerEUEnergy() {
        return this.maxStorageEU;
    }

    public int getMaxChargerRFEnergy() {
        return this.maxStorageRF;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection dir) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int energyReceivedRF = Math.min(this.getMaxEnergyStored(from) - this.getEnergyStored(from), maxReceive);
        if (!simulate) {
            this.energyRF += energyReceivedRF;
        }
        return energyReceivedRF;
    }

    @Override
    public int getEnergyStored(ForgeDirection var1) {
        return this.energyRF;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection var1) {
        return this.maxStorageRF;
    }

    public void onNetworkEvent(EntityPlayer player, int id) {
        switch (id) {
            case 0: {
                this.chargeEU = !this.chargeEU;
                break;
            }
            case 1: {
                this.chargeRF = !this.chargeRF;
                break;
            }
            case 2: {
                this.incrementChargeRate();
                break;
            }
            case 3: {
                this.decrementChargeRate();
                break;
            }
            case 4: {
                this.blockStoragesCharge = !this.blockStoragesCharge;
            }
        }
    }

    public ContainerBase<TileWirelessMachinesChargerBase> getGuiContainer(EntityPlayer player) {
        return new ContainerWirelessMachinesChargerNew(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiWirelessMachinesChargerNew(new ContainerWirelessMachinesChargerNew(player, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }
}

