/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.tiles;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.core.IC2;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.network.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import ru.wirelessindustry.container.ContainerWSBPersonal;
import ru.wirelessindustry.tiles.IWirelessStorage;

public class TileWirelessStorageBasePersonal
extends TileEntity
implements IEnergySource,
IPersonalBlock,
IWirelessStorage,
INetworkDataProvider,
INetworkClientTileEntityEventListener {
    public static ArrayList<TileWirelessStorageBasePersonal> listofstorages = new ArrayList();
    public static HashMap<Boolean, ArrayList<TileWirelessStorageBasePersonal>> mapofThis = new HashMap();
    public int maxStorage;
    public double energy = 0.0;
    public int output;
    public int tier;
    public boolean targetSet;
    public String wsbPersName;
    public boolean initialized;
    public boolean loaded;
    public int channel;
    protected boolean isconnected;
    protected GameProfile owner = null;
    private boolean addedToEnergyNet;
    private boolean isAddedToMap;

    public TileWirelessStorageBasePersonal(int output, int maxStorage, int tier, String name) {
        this.tier = tier;
        this.output = output;
        this.maxStorage = maxStorage;
        this.loaded = false;
        this.initialized = false;
        this.targetSet = false;
        this.isconnected = false;
        this.wsbPersName = name;
        this.channel = 1;
    }

    public void setPlayerProfile(GameProfile profile) {
        this.owner = profile;
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "owner");
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.initialized) {
            this.intialize();
        }
        if (!this.field_145850_b.field_72995_K & !this.isAddedToMap) {
            if (!listofstorages.contains(this)) {
                listofstorages.add(this);
                if (mapofThis.isEmpty() | mapofThis.containsKey(false) & mapofThis.containsValue(listofstorages)) {
                    mapofThis.clear();
                    mapofThis.put(true, listofstorages);
                }
            }
            this.isAddedToMap = true;
            this.isconnected = true;
        }
        if (this.energy > (double)this.maxStorage) {
            this.energy = this.maxStorage;
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.onLoaded();
        this.isconnected = true;
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
            this.isconnected = true;
        }
        this.loaded = true;
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        this.isconnected = false;
        super.func_145843_s();
    }

    public void onUnloaded() {
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
            if (this.isAddedToMap) {
                listofstorages.remove(this);
                this.isAddedToMap = false;
                this.isconnected = false;
                mapofThis.clear();
                mapofThis.put(true, listofstorages);
            }
        }
        this.loaded = false;
    }

    public void intialize() {
        this.initialized = true;
        if (!this.addedToEnergyNet) {
            this.onLoaded();
        }
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int ch) {
        this.channel = ch;
    }

    public boolean emitsEnergyTo(TileEntity nameTileEntity, ForgeDirection nameForgeDirection) {
        return true;
    }

    public double getOfferedEnergy() {
        if (this.energy >= (double)this.output) {
            return Math.min(this.energy, (double)this.output);
        }
        return 0.0;
    }

    public void drawEnergy(double amount) {
        this.energy -= amount;
    }

    public int getSourceTier() {
        return this.tier;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.owner != null) {
            NBTTagCompound ownerNbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)ownerNbt, (GameProfile)this.owner);
            nbttagcompound.func_74782_a("ownerGameProfile", (NBTBase)ownerNbt);
        }
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74768_a("maxenergy", this.maxStorage);
        nbttagcompound.func_74757_a("targetset", this.targetSet);
        nbttagcompound.func_74757_a("isconnected", this.isconnected);
        nbttagcompound.func_74768_a("channel", this.channel);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("ownerGameProfile")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("ownerGameProfile"));
        }
        this.energy = nbttagcompound.func_74769_h("energy");
        this.maxStorage = nbttagcompound.func_74762_e("maxenergy");
        this.targetSet = nbttagcompound.func_74767_n("targetset");
        this.isconnected = nbttagcompound.func_74767_n("isconnected");
        this.channel = nbttagcompound.func_74762_e("channel");
    }

    public void changeChannel(int value) {
        this.channel = Math.max(this.channel + value, 1);
    }

    public Container getGuiContainer(InventoryPlayer inventory) {
        return new ContainerWSBPersonal(inventory, this);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int gaugeEnergyScaled(int i) {
        return (int)(this.energy * (double)i / (double)this.maxStorage);
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public boolean permitsAccess(GameProfile profile) {
        if (profile == null) {
            return this.owner == null;
        }
        if (!this.field_145850_b.field_72995_K && this.owner == null) {
            this.owner = profile;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "owner");
            return true;
        }
        return this.owner.equals((Object)profile);
    }

    @Override
    public double getMaxCapacityOfStorage() {
        return this.maxStorage;
    }

    @Override
    public double getCurrentEnergyInStorage() {
        return this.energy;
    }

    @Override
    public double getFreeEnergy() {
        return this.getMaxCapacityOfStorage() - this.getCurrentEnergyInStorage();
    }

    @Override
    public void addEnergy(double amount) {
        this.energy += amount;
    }

    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("owner");
        return ret;
    }

    public void onNetworkEvent(EntityPlayer player, int id) {
        switch (id) {
            case 0: {
                this.changeChannel(1);
                break;
            }
            case 1: {
                this.changeChannel(-1);
            }
        }
    }
}

