/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.tiles;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import ru.wirelessindustry.config.ConfigWI;
import ru.wirelessindustry.container.ContainerXPSenderNew;
import ru.wirelessindustry.gui.GuiXPSenderNew;

public class TileXPSenderElectric
extends TileEntity
implements IEnergySink,
IInventory,
IHasGui,
INetworkClientTileEntityEventListener {
    private final int energyperpoint;
    public int maxStorage;
    public double energy;
    public String xpsendername;
    protected int tier;
    protected int sendradius = 5;
    protected int pointsxp;
    protected int playercountinradius = 0;
    private boolean loaded = false;
    private boolean addedToEnergyNet;

    public TileXPSenderElectric(int maxstorage, int tier, String name, int xp, int energyperpoint) {
        this.tier = tier;
        this.maxStorage = maxstorage;
        this.xpsendername = name;
        this.pointsxp = xp;
        this.energyperpoint = energyperpoint;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void func_145843_s() {
        if (this.loaded) {
            if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
                this.addedToEnergyNet = false;
            }
            this.loaded = false;
        }
        super.func_145843_s();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.energy > (double)this.maxStorage) {
            this.energy = this.maxStorage;
        }
        this.countPlayers(this.sendradius);
    }

    protected void consumeEnergyXPSender(double amount) {
        this.energy = Math.max(this.energy - amount, 0.0);
    }

    public int getTotalSpentEUValue() {
        return this.energyperpoint * this.pointsxp;
    }

    public int getXPPointsToSend() {
        return this.pointsxp;
    }

    protected void countPlayers(int radius) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - radius), (double)(this.field_145848_d - radius), (double)(this.field_145849_e - radius), (double)(this.field_145851_c + radius + 1), (double)(this.field_145848_d + radius + 1), (double)(this.field_145849_e + radius + 1));
        List list = this.func_145831_w().func_72872_a(EntityPlayer.class, axisalignedbb);
        if (this.field_145850_b.func_82737_E() % ((long)ConfigWI.secondsXPSender * 20L) == 0L) {
            this.sendXPToPlayersAround(this.pointsxp, list);
        }
        this.playercountinradius = list.size();
    }

    protected void sendXPToPlayersAround(int points, List<EntityPlayer> list) {
        double consume = this.getTotalSpentEUValue();
        for (EntityPlayer player : list) {
            if (player == null || !(this.energy > consume)) continue;
            player.func_71023_q(points);
            this.consumeEnergyXPSender(consume);
        }
    }

    public void changeRadius(int value) {
        this.sendradius = value < 0 ? Math.max(this.sendradius + value, 1) : Math.min(this.sendradius + value, 25);
    }

    public int getSendRadius() {
        return this.sendradius;
    }

    public int getPlayerCount() {
        return this.playercountinradius;
    }

    public int gaugeEnergyScaled(int i) {
        return (int)(this.energy * (double)i / (double)this.maxStorage);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74769_h("energy");
        this.sendradius = nbttagcompound.func_74762_e("radius");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74768_a("radius", this.sendradius);
    }

    public boolean acceptsEnergyFrom(TileEntity tile, ForgeDirection dir) {
        return true;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double de = this.getDemandedEnergy();
        if (amount == 0.0) {
            return 0.0;
        }
        if (de <= 0.0) {
            return amount;
        }
        if (amount >= de) {
            this.energy += de;
            return amount - de;
        }
        this.energy += amount;
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiXPSenderNew(new ContainerXPSenderNew(player, this));
    }

    public ContainerBase<TileXPSenderElectric> getGuiContainer(EntityPlayer player) {
        return new ContainerXPSenderNew(player, this);
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                this.changeRadius(1);
                break;
            }
            case 1: {
                this.changeRadius(-1);
            }
        }
    }
}

