/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.tiles;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.util.EntityIC2FX;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import ru.wirelessindustry.container.ContainerXPTransmitter;
import ru.wirelessindustry.gui.GuiXPTransmitter;
import ru.wirelessindustry.utils.ExperienceUtils;

public class TileXPTransmitter
extends TileEntityInventory
implements IEnergySink,
IHasGui,
INetworkClientTileEntityEventListener,
INetworkDataProvider {
    private final List<EntityPlayer> playersStandingOnTop;
    private final int xpLimit;
    protected double maxEnergy;
    protected double energy = 0.0;
    protected int tier;
    protected boolean addedToEnergyNet = false;
    protected boolean loaded;
    private boolean isOn;
    private boolean sendingXPMode;
    private int amountXPTransmit;
    private int storedXP;
    private int playersCount;

    public TileXPTransmitter() {
        this(1000000.0, 9);
    }

    public TileXPTransmitter(double maxstorage, int tier) {
        this.tier = tier;
        this.maxEnergy = maxstorage;
        this.loaded = false;
        this.sendingXPMode = true;
        this.isOn = true;
        this.amountXPTransmit = 1;
        this.storedXP = 0;
        this.xpLimit = 20000000;
        this.playersStandingOnTop = new ArrayList<EntityPlayer>();
        this.playersCount = 0;
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void setInternalParameters(double energy, int xp, int transmit, boolean mode, boolean isOnOff) {
        this.energy = energy;
        this.storedXP = xp;
        this.amountXPTransmit = transmit;
        this.sendingXPMode = mode;
        this.isOn = isOnOff;
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        ItemStack drop = super.getWrenchDrop(player);
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)drop);
        nbt.func_74780_a("energy", this.energy);
        nbt.func_74768_a("storedXP", this.storedXP);
        nbt.func_74768_a("amountXPTransmit", this.amountXPTransmit);
        nbt.func_74757_a("sendingXPMode", this.sendingXPMode);
        nbt.func_74757_a("isOn", this.isOn);
        return drop;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("energy", this.energy);
        nbt.func_74768_a("storedXP", this.storedXP);
        nbt.func_74768_a("amountXPTransmit", this.amountXPTransmit);
        nbt.func_74757_a("sendingXPMode", this.sendingXPMode);
        nbt.func_74757_a("isOn", this.isOn);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74769_h("energy");
        this.storedXP = nbt.func_74762_e("storedXP");
        this.amountXPTransmit = nbt.func_74762_e("amountXPTransmit");
        this.sendingXPMode = nbt.func_74767_n("sendingXPMode");
        this.isOn = nbt.func_74767_n("isOn");
    }

    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection forgeDirection, double amount, double v1) {
        double de = this.getDemandedEnergy();
        if (amount == 0.0) {
            return 0.0;
        }
        if (de <= 0.0) {
            return amount;
        }
        if (amount >= de) {
            this.energy += de;
            return amount - de;
        }
        this.energy += amount;
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        super.updateEntityClient();
        Random rnd = this.field_145850_b.field_73012_v;
        if (rnd.nextInt(8) != 0) {
            return;
        }
        if (this.getActive()) {
            EffectRenderer effect = FMLClientHandler.instance().getClient().field_71452_i;
            float[] orangeParticles = new float[]{1.0f, 0.55f, 0.0f};
            float[] greenParticles = new float[]{0.5f, 0.72f, 0.0f};
            for (int particles = 20; particles > 0; --particles) {
                double x = (float)this.field_145851_c + 0.0f + rnd.nextFloat();
                double y = (float)this.field_145848_d + 0.9f + rnd.nextFloat();
                double z = (float)this.field_145849_e + 0.0f + rnd.nextFloat();
                effect.func_78873_a((EntityFX)new EntityIC2FX(this.field_145850_b, x, y, z, 45, new double[]{0.0, 0.1, 0.0}, this.sendingXPMode ? greenParticles : orangeParticles));
            }
        }
    }

    public boolean acceptsEnergyFrom(TileEntity te, ForgeDirection dir) {
        return true;
    }

    public void onNetworkEvent(EntityPlayer entityPlayer, int id) {
        switch (id) {
            case 1: {
                this.changeAmountSentToPlayer(1);
                break;
            }
            case 2: {
                this.changeAmountSentToPlayer(-1);
                break;
            }
            case 3: {
                this.toggleWork();
                break;
            }
            case 4: {
                this.invertMode();
                break;
            }
            case 5: {
                this.changeAmountSentToPlayer(10);
                break;
            }
            case 6: {
                this.changeAmountSentToPlayer(-10);
                break;
            }
            case 7: {
                this.changeAmountSentToPlayer(100);
                break;
            }
            case 8: {
                this.changeAmountSentToPlayer(-100);
            }
        }
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.isOn) {
            this.attemptGeneration();
            this.getPlayersStandingOn();
            if (this.sendingXPMode) {
                this.transferXPToPlayers(this.playersStandingOnTop);
            } else {
                this.consumeXPFromPlayers(this.playersStandingOnTop);
            }
        }
    }

    protected void attemptGeneration() {
        if (this.energy >= this.maxEnergy && this.storedXP < this.xpLimit) {
            ++this.storedXP;
            this.energy -= this.maxEnergy;
        }
    }

    protected void getPlayersStandingOn() {
        this.playersStandingOnTop.clear();
        this.playersCount = 0;
        List playersList = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
        if (!playersList.isEmpty()) {
            this.playersStandingOnTop.addAll(playersList);
            this.playersCount = playersList.size();
        }
    }

    protected void transferXPToPlayers(List<EntityPlayer> playersStandingOn) {
        if (!playersStandingOn.isEmpty()) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                for (EntityPlayer player : playersStandingOn) {
                    if (this.storedXP <= 0) continue;
                    int realTransfer = Math.min(this.storedXP, this.amountXPTransmit);
                    this.storedXP -= realTransfer;
                    ExperienceUtils.addPlayerXP(player, realTransfer);
                }
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
    }

    protected void consumeXPFromPlayers(List<EntityPlayer> playersStandingOn) {
        if (!playersStandingOn.isEmpty()) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            for (EntityPlayer player : playersStandingOn) {
                int maxAcceptedXP;
                int playerXP = ExperienceUtils.getPlayerXP(player);
                if (playerXP <= 0 || (maxAcceptedXP = Math.min(Math.min(playerXP, this.amountXPTransmit), this.xpLimit - this.storedXP)) <= 0) continue;
                ExperienceUtils.consumeXPFromPlayer(player, maxAcceptedXP);
                this.storedXP += maxAcceptedXP;
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
    }

    protected void invertMode() {
        this.sendingXPMode = !this.sendingXPMode;
    }

    protected void toggleWork() {
        this.isOn = !this.isOn;
    }

    public int getPercentageGeneration() {
        return (int)(this.energy / this.maxEnergy * 100.0);
    }

    public boolean getIsSendingMode() {
        return this.sendingXPMode;
    }

    public boolean getIsOn() {
        return this.isOn;
    }

    protected void changeAmountSentToPlayer(int amount) {
        this.amountXPTransmit = Math.max(this.amountXPTransmit + amount, 1);
    }

    public double gaugeExperience(int pixels) {
        return (double)this.storedXP * (double)pixels / (double)this.xpLimit;
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public int getAmountXPTransmit() {
        return this.amountXPTransmit;
    }

    public int getXpLimit() {
        return this.xpLimit;
    }

    public int getPlayersCount() {
        return this.playersCount;
    }

    public ContainerBase<TileXPTransmitter> getGuiContainer(EntityPlayer player) {
        return new ContainerXPTransmitter(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean b) {
        return new GuiXPTransmitter(new ContainerXPTransmitter(player, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public String func_145825_b() {
        return null;
    }
}

