/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.tiles;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.network.NetworkManager;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import ru.wirelessindustry.container.ContainerWirelessQuantumGen;
import ru.wirelessindustry.gui.GuiWirelessQuantumGen;
import ru.wirelessindustry.handlerwireless.WirelessTransfer;
import ru.wirelessindustry.tiles.IWirelessQGen;
import ru.wirelessindustry.tiles.TileWirelessStorageBasePersonal;
import ru.wirelessindustry.utils.WirelessUtil;

public class WirelessQuantumGeneratorBase
extends TileEntityInventory
implements IHasGui,
IEnergySource,
INetworkClientTileEntityEventListener,
IWirelessQGen {
    public String wirelessQGenName;
    protected int tier;
    protected GameProfile owner = null;
    protected IWirelessQGen.ChargeStatus chargingStatus;
    protected int modeTransmitting;
    private boolean addedToEnergyNet;
    private int machinesCountInChunk;

    public WirelessQuantumGeneratorBase(int tier, String name) {
        this.tier = tier;
        this.wirelessQGenName = name;
        this.machinesCountInChunk = 0;
        this.chargingStatus = IWirelessQGen.ChargeStatus.NOT_CHARGING;
        this.modeTransmitting = 0;
    }

    private static boolean areSameOwners(GameProfile id1, GameProfile id2) {
        return id1 != null && id1.equals((Object)id2) || id1 == id2;
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        WirelessUtil.doWirelessChargingMachines(this);
        this.operateWirelessTransferFromQGen();
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.owner != null) {
            NBTTagCompound ownerNbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)ownerNbt, (GameProfile)this.owner);
            nbttagcompound.func_74782_a("ownerGameProfile", (NBTBase)ownerNbt);
        }
        nbttagcompound.func_74768_a("modeTransmitting", this.modeTransmitting);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("ownerGameProfile")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("ownerGameProfile"));
        }
        this.modeTransmitting = nbttagcompound.func_74762_e("modeTransmitting");
    }

    protected void operateWirelessTransferFromQGen() {
        if (TileWirelessStorageBasePersonal.mapofThis.containsKey(true) && TileWirelessStorageBasePersonal.mapofThis.containsValue(TileWirelessStorageBasePersonal.listofstorages) && !TileWirelessStorageBasePersonal.mapofThis.get(true).isEmpty()) {
            for (TileWirelessStorageBasePersonal te : TileWirelessStorageBasePersonal.mapofThis.get(true)) {
                if (!WirelessQuantumGeneratorBase.areSameOwners(this.owner, te.owner)) continue;
                WirelessTransfer.transmithandler.transmitEnergyWireleslyQGen(te, this);
            }
        }
    }

    public void setPlayerProfile(GameProfile profile) {
        this.owner = profile;
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "owner");
    }

    public int getWirelessTransferLimitQGen() {
        return this.getChargeRateByMode(this.modeTransmitting);
    }

    @Override
    public int getMachinesCountInChunk() {
        return this.machinesCountInChunk;
    }

    @Override
    public void setMachinesCountInChunk(int value) {
        this.machinesCountInChunk = value;
    }

    @Override
    public IWirelessQGen.ChargeStatus getStatus() {
        return this.chargingStatus;
    }

    @Override
    public void setStatus(IWirelessQGen.ChargeStatus status) {
        this.chargingStatus = status;
    }

    public void onNetworkEvent(EntityPlayer player, int id) {
        if (++this.modeTransmitting > 9) {
            this.modeTransmitting = 0;
        }
    }

    public boolean emitsEnergyTo(TileEntity tile, ForgeDirection dir) {
        return true;
    }

    public void drawEnergy(double amount) {
    }

    public double getOfferedEnergy() {
        return this.getChargeRateByMode(this.modeTransmitting);
    }

    public int getOutput() {
        return this.getChargeRateByMode(this.modeTransmitting);
    }

    public int getSourceTier() {
        return this.tier;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public boolean permitsAccess(GameProfile profile) {
        if (profile == null) {
            return this.owner == null;
        }
        if (!this.field_145850_b.field_72995_K && this.owner == null) {
            this.owner = profile;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "owner");
            return true;
        }
        return this.owner.equals((Object)profile);
    }

    public String func_145825_b() {
        return null;
    }

    public ContainerBase<WirelessQuantumGeneratorBase> getGuiContainer(EntityPlayer player) {
        return new ContainerWirelessQuantumGen(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean b) {
        return new GuiWirelessQuantumGen(new ContainerWirelessQuantumGen(player, this));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public World getQGenWorld() {
        return this.field_145850_b;
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public int getModeTransmitting() {
        return this.modeTransmitting;
    }

    @Override
    public int getChargeRateByMode(int mode) {
        return (int)(1024.0 * Math.pow(2.0, mode));
    }
}

