/*
 * Decompiled with CFR 0.152.
 */
package ru.wirelessindustry.utils;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.item.ElectricItem;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import physica.api.core.electricity.IElectricityReceiver;
import ru.wirelessindustry.config.ConfigWI;
import ru.wirelessindustry.tiles.IWirelessCharger;
import ru.wirelessindustry.tiles.IWirelessMachineCharger;
import ru.wirelessindustry.tiles.IWirelessQGen;
import ru.wirelessindustry.tiles.TileWirelessMachinesChargerBase;
import ru.wirelessindustry.tiles.WirelessQuantumGeneratorBase;

public class WirelessUtil {
    public static void chargeItemEU(IWirelessCharger tile, ItemStack currentItemStackEU) {
        if (ElectricItem.manager.charge(currentItemStackEU, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true) > 0.0) {
            tile.decreaseEnergy(ElectricItem.manager.charge(currentItemStackEU, tile.getCurrentEnergyInCharger(), Integer.MAX_VALUE, false, false));
        }
    }

    public static void chargeItemRF(IWirelessCharger tile, ItemStack currentItemStackRF) {
        IEnergyContainerItem item = (IEnergyContainerItem)currentItemStackRF.func_77973_b();
        if (item.receiveEnergy(currentItemStackRF, Integer.MAX_VALUE, true) > 0) {
            int euFinallySent = item.receiveEnergy(currentItemStackRF, (int)(tile.getCurrentEnergyInCharger() * (double)ConfigWI.EUToRF_Multiplier), false) / ConfigWI.EUToRF_Multiplier;
            tile.decreaseEnergy(euFinallySent);
        }
    }

    private static void sendRFToReceiver(IWirelessMachineCharger charger, IEnergyReceiver receiver) {
        if (receiver.getMaxEnergyStored(ForgeDirection.UNKNOWN) - receiver.getEnergyStored(ForgeDirection.UNKNOWN) > 0 && charger.getChargerEnergyRF() > 0) {
            charger.decreaseEnergyRF(receiver.receiveEnergy(ForgeDirection.UNKNOWN, charger.getChargerEnergyRF(), false));
        }
    }

    private static void sendEUToEnergySink(IWirelessMachineCharger charger, IEnergySink sink) {
        double demEnergy = sink.getDemandedEnergy();
        if (demEnergy > 0.0) {
            double sentreal = charger.getMode() == 8 ? Math.min(demEnergy, charger.getChargerEnergyEU()) : Math.min(demEnergy, Math.min(charger.getChargerEnergyEU(), charger.getChargeRate()));
            sink.injectEnergy(ForgeDirection.UNKNOWN, sentreal, 1.0);
            charger.decreaseEnergy(sentreal);
        }
    }

    public static void doWirelessChargingMachines(IWirelessQGen qGen) {
        Map teMap = qGen.getQGenWorld().func_72938_d((int)qGen.getXCoord(), (int)qGen.getZCoord()).field_150816_i;
        if (!teMap.isEmpty()) {
            List<IEnergySink> listSinks = teMap.values().stream().filter(tile -> tile instanceof IEnergySink).map(tile -> (IEnergySink)tile).collect(Collectors.toList());
            AtomicInteger mutuallySinkReceiverCount = new AtomicInteger();
            List<IEnergyReceiver> listReceivers = teMap.values().stream().filter(tile -> {
                boolean b1 = tile instanceof IEnergyReceiver;
                if (b1 && tile instanceof IEnergySink) {
                    mutuallySinkReceiverCount.getAndIncrement();
                }
                return b1;
            }).map(tile -> (IEnergyReceiver)tile).collect(Collectors.toList());
            int sizeAll = listSinks.size() + listReceivers.size() - mutuallySinkReceiverCount.get();
            if (sizeAll > 0) {
                qGen.setMachinesCountInChunk(sizeAll);
                qGen.setStatus(IWirelessQGen.ChargeStatus.WAITING);
            } else {
                qGen.setMachinesCountInChunk(0);
                qGen.setStatus(IWirelessQGen.ChargeStatus.NOT_CHARGING);
            }
            if (!listSinks.isEmpty()) {
                listSinks.forEach(sink -> {
                    if (sink.getDemandedEnergy() > 0.0) {
                        sink.injectEnergy(ForgeDirection.UNKNOWN, (double)qGen.getChargeRateByMode(qGen.getModeTransmitting()), 1.0);
                        qGen.setStatus(IWirelessQGen.ChargeStatus.CHARGING);
                    }
                });
            }
            if (!listReceivers.isEmpty()) {
                listReceivers.forEach(receiver -> {
                    if (receiver.getMaxEnergyStored(ForgeDirection.UNKNOWN) - receiver.getEnergyStored(ForgeDirection.UNKNOWN) > 0) {
                        receiver.receiveEnergy(ForgeDirection.UNKNOWN, qGen.getChargeRateByMode(qGen.getModeTransmitting()), false);
                        qGen.setStatus(IWirelessQGen.ChargeStatus.CHARGING);
                    }
                });
            }
        } else {
            qGen.setMachinesCountInChunk(0);
            qGen.setStatus(IWirelessQGen.ChargeStatus.NOT_CHARGING);
        }
    }

    public static boolean iterateEnergyTilesQGen(WirelessQuantumGeneratorBase qgen) {
        boolean ret = false;
        Map teMap = qgen.func_145831_w().func_72938_d((int)qgen.field_145851_c, (int)qgen.field_145849_e).field_150816_i;
        if (!teMap.isEmpty()) {
            for (TileEntity tile : teMap.values()) {
                IEnergyReceiver receiver;
                int demandedenergy;
                if (tile instanceof IEnergySink && !(tile instanceof TileWirelessMachinesChargerBase)) {
                    IEnergySink sink = (IEnergySink)tile;
                    double demEnergy = sink.getDemandedEnergy();
                    if (!(demEnergy > 0.0)) continue;
                    ret = true;
                    sink.injectEnergy(ForgeDirection.UNKNOWN, demEnergy, 1.0);
                    continue;
                }
                if (!(tile instanceof IEnergyReceiver) || tile instanceof IEnergySink || (demandedenergy = (receiver = (IEnergyReceiver)tile).getMaxEnergyStored(ForgeDirection.UNKNOWN) - receiver.getEnergyStored(ForgeDirection.UNKNOWN)) <= 0) continue;
                ret = true;
                receiver.receiveEnergy(ForgeDirection.UNKNOWN, demandedenergy, false);
            }
        }
        return ret;
    }

    public static void iterateEnergyTiles(IWirelessMachineCharger charger, boolean chargeEU, boolean chargeRF, boolean blockStoragesCharge) {
        Map teMap = charger.getChargerWorld().func_72938_d((int)charger.getXCoord(), (int)charger.getZCoord()).field_150816_i;
        if (!teMap.isEmpty()) {
            for (TileEntity tile : teMap.values()) {
                if (tile instanceof IEnergySource && blockStoragesCharge) continue;
                if (tile instanceof IEnergySink && !(tile instanceof TileWirelessMachinesChargerBase)) {
                    if (!chargeEU) continue;
                    WirelessUtil.sendEUToEnergySink(charger, (IEnergySink)tile);
                    continue;
                }
                if (!(tile instanceof IEnergyReceiver) || tile instanceof IEnergySink || tile instanceof IElectricityReceiver || !chargeRF) continue;
                WirelessUtil.sendRFToReceiver(charger, (IEnergyReceiver)tile);
            }
        }
    }
}

