/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.core.LiteLoaderEnumerator;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.interfaces.LoadableMod;

class Mod
extends ModInfo<LoadableMod<?>> {
    private final Class<? extends LiteMod> modClass;
    private final String key;
    private final String identifier;
    private LiteMod instance;
    private String name;
    private String version;

    public Mod(LoadableMod<?> container, Class<? extends LiteMod> modClass) {
        this(container, modClass, container != null ? container.getIdentifier() : LiteLoaderEnumerator.getModClassName(modClass));
    }

    public Mod(LoadableMod<?> container, Class<? extends LiteMod> modClass, String identifier) {
        super(container != null ? container : LoadableMod.NONE, true);
        this.modClass = modClass;
        this.key = modClass.getSimpleName();
        this.identifier = identifier.toLowerCase();
        this.name = ((LoadableMod)this.container).getDisplayName();
        this.version = ((LoadableMod)this.container).getVersion();
    }

    LiteMod newInstance() throws InstantiationException, IllegalAccessException {
        String version;
        if (this.instance != null) {
            throw new InstantiationException("Attempted to create an instance of " + this.key + " but the instance was already created");
        }
        this.instance = this.modClass.newInstance();
        String name = this.instance.getName();
        if (name != null) {
            this.name = name;
        }
        if ((version = this.instance.getVersion()) != null) {
            this.version = version;
        }
        return this.instance;
    }

    @Override
    public boolean isToggleable() {
        return true;
    }

    @Override
    public LiteMod getMod() {
        return this.instance;
    }

    @Override
    public Class<? extends LiteMod> getModClass() {
        return this.modClass;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getModClassName() {
        return this.modClass.getName();
    }

    @Override
    public String getModClassSimpleName() {
        return this.key;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public boolean matchesName(String name) {
        return name.equalsIgnoreCase(this.instance.getName()) || name.equalsIgnoreCase(this.identifier) || name.equalsIgnoreCase(this.key);
    }

    public boolean matchesIdentifier(String identifier) {
        return identifier.equalsIgnoreCase(this.identifier);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Mod)) {
            return false;
        }
        return ((Mod)other).key.equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

