/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.launch;

import com.mumfrey.liteloader.launch.ClassTransformerManager;
import com.mumfrey.liteloader.launch.LoaderBootstrap;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.launch.StartupEnvironment;
import com.mumfrey.liteloader.util.SortableValue;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class LiteLoaderTweaker
implements ITweaker {
    public static final int ENV_TYPE_CLIENT = 0;
    public static final int ENV_TYPE_DEDICATEDSERVER = 1;
    public static final String VERSION = "1.7.10";
    protected static final String bootstrapClassName = "com.mumfrey.liteloader.core.LiteLoaderBootstrap";
    protected static LiteLoaderTweaker instance;
    protected static URL jarUrl;
    protected int tweakOrder = 0;
    protected Set<String> allCascadingTweaks = new HashSet<String>();
    protected Set<SortableValue<String>> sortedCascadingTweaks = new TreeSet<SortableValue<String>>();
    protected boolean isPrimary;
    protected StartupEnvironment env;
    protected LoaderBootstrap bootstrap;
    protected ClassTransformerManager transformerManager;

    public void acceptOptions(List<String> args, File gameDirectory, File assetsDirectory, String profile) {
        Launch.classLoader.addClassLoaderExclusion("com.google.common.");
        instance = this;
        this.onPrepare(args, gameDirectory, assetsDirectory, profile);
        this.onPreInit();
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        classLoader.addClassLoaderExclusion("com.mumfrey.liteloader.core.runtime.Obf");
        classLoader.addClassLoaderExclusion("com.mumfrey.liteloader.core.runtime.Packets");
        this.transformerManager.injectUpstreamTransformers(classLoader);
        for (String transformerClassName : this.bootstrap.getRequiredDownstreamTransformers()) {
            LiteLoaderLogger.info("Queuing required class transformer '%s'", transformerClassName);
            this.transformerManager.injectTransformer(transformerClassName);
        }
    }

    public String getLaunchTarget() {
        this.isPrimary = true;
        this.onPreBeginGame();
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        return this.env.getLaunchArguments();
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public ClassTransformerManager getTransformerManager() {
        return this.transformerManager;
    }

    private void onPrepare(List<String> args, File gameDirectory, File assetsDirectory, String profile) {
        LiteLoaderLogger.info("Bootstrapping LiteLoader 1.7.10", new Object[0]);
        try {
            this.initEnvironment(args, gameDirectory, assetsDirectory, profile);
            this.bootstrap = this.spawnBootstrap(bootstrapClassName, (ClassLoader)Launch.classLoader);
            this.transformerManager = new ClassTransformerManager(this.bootstrap.getRequiredTransformers());
            this.transformerManager.injectTransformers(this.bootstrap.getPacketTransformers());
            StartupState.PREPARE.completed();
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error during LiteLoader PREPARE: %s %s", th.getClass().getName(), th.getMessage());
        }
    }

    private void onPreInit() {
        StartupState.PREINIT.gotoState();
        try {
            this.bootstrap.preInit(Launch.classLoader, true, this.env.getModFilterList());
            this.injectDiscoveredTweakClasses();
            StartupState.PREINIT.completed();
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error during LiteLoader PREINIT: %s %s", th.getClass().getName(), th.getMessage());
        }
    }

    private void onPreBeginGame() {
        StartupState.BEGINGAME.gotoState();
        try {
            this.transformerManager.injectDownstreamTransformers(Launch.classLoader);
            this.bootstrap.preBeginGame();
            StartupState.BEGINGAME.completed();
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error during LiteLoader BEGINGAME: %s %s", th.getClass().getName(), th.getMessage());
        }
    }

    private void onInit() {
        StartupState.INIT.gotoState();
        try {
            this.bootstrap.init();
            StartupState.INIT.completed();
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error during LiteLoader INIT: %s %s", th.getClass().getName(), th.getMessage());
        }
    }

    private void onPostInit() {
        StartupState.POSTINIT.gotoState();
        try {
            this.bootstrap.postInit();
            StartupState.POSTINIT.completed();
            StartupState.DONE.gotoState();
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error during LiteLoader POSTINIT: %s %s", th.getClass().getName(), th.getMessage());
        }
    }

    private void initEnvironment(List<String> args, File gameDirectory, File assetsDirectory, String profile) {
        this.env = this.spawnStartupEnvironment(args, gameDirectory, assetsDirectory, profile);
        URL[] urls = Launch.classLoader.getURLs();
        jarUrl = urls[urls.length - 1];
    }

    private void injectDiscoveredTweakClasses() {
        if (this.sortedCascadingTweaks.size() > 0) {
            if (StartupState.getCurrent() != StartupState.PREINIT || !StartupState.PREINIT.isInState()) {
                LiteLoaderLogger.warning("Failed to inject cascaded tweak classes because preInit is already complete", new Object[0]);
                return;
            }
            LiteLoaderLogger.info("Injecting cascaded tweakers...", new Object[0]);
            List tweakClasses = (List)Launch.blackboard.get("TweakClasses");
            List tweakers = (List)Launch.blackboard.get("Tweaks");
            if (tweakClasses != null && tweakers != null) {
                for (SortableValue<String> tweak : this.sortedCascadingTweaks) {
                    String tweakClass = tweak.getValue();
                    LiteLoaderLogger.info("Injecting tweak class %s with priority %d", tweakClass, tweak.getPriority());
                    this.injectTweakClass(tweakClass, tweakClasses, tweakers);
                }
            }
            this.sortedCascadingTweaks.clear();
        }
    }

    private void injectTweakClass(String tweakClass, List<String> tweakClasses, List<ITweaker> tweakers) {
        if (!tweakClasses.contains(tweakClass)) {
            for (ITweaker existingTweaker : tweakers) {
                if (!tweakClass.equals(existingTweaker.getClass().getName())) continue;
                return;
            }
            tweakClasses.add(tweakClass);
        }
    }

    public boolean addCascadedTweaker(String tweakClass, int priority) {
        if (tweakClass != null && !this.allCascadingTweaks.contains(tweakClass)) {
            if (this.getClass().getName().equals(tweakClass)) {
                return false;
            }
            if (LiteLoaderTweaker.isTweakAlreadyEnqueued(tweakClass)) {
                return false;
            }
            this.allCascadingTweaks.add(tweakClass);
            this.sortedCascadingTweaks.add(new SortableValue<String>(priority, this.tweakOrder++, tweakClass));
            return true;
        }
        return false;
    }

    protected LoaderBootstrap spawnBootstrap(String bootstrapClassName, ClassLoader classLoader) {
        if (!StartupState.PREPARE.isInState()) {
            throw new IllegalStateException("spawnBootstrap is not valid outside PREPARE");
        }
        try {
            Class<?> bootstrapClass = Class.forName(bootstrapClassName, false, classLoader);
            Constructor<?> bootstrapCtor = bootstrapClass.getDeclaredConstructor(StartupEnvironment.class, ITweaker.class);
            bootstrapCtor.setAccessible(true);
            return (LoaderBootstrap)bootstrapCtor.newInstance(this.env, this);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    protected StartupEnvironment spawnStartupEnvironment(List<String> args, File gameDirectory, File assetsDirectory, String profile) {
        return new StartupEnvironment(args, gameDirectory, assetsDirectory, profile){

            @Override
            public void registerCoreAPIs(List<String> apisToLoad) {
                apisToLoad.add(0, "com.mumfrey.liteloader.client.api.LiteLoaderCoreAPIClient");
            }

            @Override
            public int getEnvironmentTypeId() {
                return 0;
            }
        };
    }

    public static URL getJarUrl() {
        return jarUrl;
    }

    public static boolean addURLToParentClassLoader(URL url) {
        if (StartupState.getCurrent() == StartupState.PREINIT && StartupState.PREINIT.isInState()) {
            try {
                URLClassLoader classLoader = (URLClassLoader)Launch.class.getClassLoader();
                Method mAddUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                mAddUrl.setAccessible(true);
                mAddUrl.invoke((Object)classLoader, url);
                return true;
            }
            catch (Exception ex) {
                LiteLoaderLogger.warning(ex, "addURLToParentClassLoader failed: %s", ex.getMessage());
            }
        }
        return false;
    }

    private static boolean isTweakAlreadyEnqueued(String clazz) {
        List tweakClasses = (List)Launch.blackboard.get("TweakClasses");
        List tweakers = (List)Launch.blackboard.get("Tweaks");
        if (tweakClasses != null) {
            for (String tweakClass : tweakClasses) {
                if (!tweakClass.equals(clazz)) continue;
                return true;
            }
        }
        if (tweakers != null) {
            for (ITweaker tweaker : tweakers) {
                if (!tweaker.getClass().getName().equals(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean loadingBarEnabled() {
        LoaderProperties properties = LiteLoaderTweaker.instance.bootstrap.getProperties();
        return properties != null && properties.getBooleanProperty("loadingbar");
    }

    public static void preBeginGame() {
        instance.onPreBeginGame();
    }

    public static void init() {
        instance.onInit();
    }

    public static void postInit() {
        instance.onPostInit();
    }

    static enum StartupState {
        PREPARE,
        PREINIT,
        BEGINGAME,
        INIT,
        POSTINIT,
        DONE;

        private static StartupState currentState;
        private boolean inState;
        private boolean completed;

        public boolean isCompleted() {
            return this.completed;
        }

        public boolean isInState() {
            return this.inState;
        }

        public StartupState gotoState() {
            for (StartupState otherState : StartupState.values()) {
                if (!otherState.isInState() || otherState == this) continue;
                if (otherState.canGotoState(this)) {
                    otherState.leaveState();
                    continue;
                }
                throw new IllegalStateException(String.format("Cannot go to state <%s> as %s %s", new Object[]{this.name(), otherState, otherState.getNextState() == this ? "" : "and expects \"" + otherState.getNextState().name() + "\" instead"}), LiteLoaderLogger.getLastThrowable());
            }
            LiteLoaderLogger.clearLastThrowable();
            currentState = this;
            this.inState = true;
            this.completed = false;
            return this;
        }

        public String toString() {
            return String.format("<%s> is %s %s", this.name(), this.inState ? "[ACTIVE]" : "[INACTIVE]", this.completed ? "and [COMPLETED]" : "but [INCOMPLETE]");
        }

        public void leaveState() {
            this.inState = false;
        }

        public void completed() {
            if (!this.inState || this.completed) {
                throw new IllegalStateException("Attempted to complete state " + this.name() + " but the state is already completed or is not active", LiteLoaderLogger.getLastThrowable());
            }
            this.completed = true;
        }

        private StartupState getNextState() {
            return this.ordinal() < StartupState.values().length - 1 ? StartupState.values()[this.ordinal() + 1] : DONE;
        }

        public boolean canGotoState(StartupState next) {
            if (this.inState && next == this.getNextState()) {
                return this.completed;
            }
            return !this.inState;
        }

        public static StartupState getCurrent() {
            return currentState;
        }

        static {
            currentState = PREPARE.gotoState();
        }
    }
}

