/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.transformers.ClassTransformer;
import com.mumfrey.liteloader.transformers.PacketHandlerException;
import com.mumfrey.liteloader.util.SortableValue;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;

@Deprecated
public abstract class PacketTransformer
extends ClassTransformer {
    private static final Set<String> transformedPackets = new HashSet<String>();
    private static int transformerOrder = 0;
    private final String packetClass;
    private final String packetClassObf;
    private final String handlerClassName;
    private final String handlerMethodName;
    private final boolean prepend;
    private final int priority;
    private final int order;

    protected PacketTransformer(Obf packetClass, String handlerClassName, String handlerMethodName) {
        this(packetClass.name, packetClass.obf, handlerClassName, handlerMethodName, 0);
    }

    protected PacketTransformer(String packetClass, String packetClassObf, String handlerClassName, String handlerMethodName) {
        this(packetClass, packetClassObf, handlerClassName, handlerMethodName, 0);
    }

    protected PacketTransformer(Obf packetClass, String handlerClassName, String handlerMethodName, int priority) {
        this(packetClass.name, packetClass.obf, handlerClassName, handlerMethodName, priority);
    }

    protected PacketTransformer(String packetClass, String packetClassObf, String handlerClassName, String handlerMethodName, int priority) {
        this.packetClass = packetClass;
        this.packetClassObf = packetClassObf;
        this.handlerClassName = handlerClassName.replace('.', '/');
        this.handlerMethodName = handlerMethodName;
        this.prepend = transformedPackets.contains(packetClass);
        transformedPackets.add(packetClass);
        this.priority = priority;
        this.order = transformerOrder++;
    }

    public final byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass != null && (this.packetClass.equals(transformedName) || this.packetClassObf.equals(transformedName))) {
            LiteLoaderLogger.info("PacketTransformer: Running transformer %s for %s", this.getClass().getName(), name);
            try {
                byte[] transformedClass = this.transformClass(transformedName, basicClass);
                this.notifyInjected();
                return transformedClass;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return basicClass;
    }

    private byte[] transformClass(String className, byte[] basicClass) {
        ClassNode classNode = this.readClass(basicClass, true);
        if (!(this.tryTransformMethod(className, classNode, Obf.processPacket.obf, Obf.INetHandler.obf) || this.tryTransformMethod(className, classNode, Obf.processPacket.srg, Obf.INetHandler.ref) || this.tryTransformMethod(className, classNode, Obf.processPacket.name, Obf.INetHandler.ref))) {
            LiteLoaderLogger.warning("PacketTransformer: failed transforming class '%s' (%s)", this.packetClass, this.packetClassObf);
        }
        return this.writeClass(classNode);
    }

    private boolean tryTransformMethod(String className, ClassNode classNode, String functionName, String netHandlerClassName) {
        MethodNode method = this.findMethodByNameAndSignature(classNode.methods, functionName, "(L" + netHandlerClassName + ";)V");
        if (method != null) {
            String targetMethodSig = "(L" + netHandlerClassName + ";L" + className.replace('.', '/') + ";)V";
            this.transformMethod(className, method, targetMethodSig);
            return true;
        }
        return false;
    }

    private void transformMethod(String className, MethodNode method, String targetMethodSig) {
        if (this.prepend) {
            InsnList insns = new InsnList();
            insns.add((AbstractInsnNode)new VarInsnNode(25, 1));
            insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insns.add((AbstractInsnNode)new MethodInsnNode(184, this.handlerClassName, this.handlerMethodName, targetMethodSig, false));
            method.instructions.insert(method.instructions.getFirst(), insns);
        } else {
            LabelNode tryLabel = new LabelNode();
            LabelNode catchLabel = new LabelNode();
            method.tryCatchBlocks.clear();
            method.tryCatchBlocks.add(new TryCatchBlockNode(tryLabel, catchLabel, catchLabel, PacketHandlerException.class.getName().replace('.', '/')));
            method.instructions.clear();
            method.instructions.add((AbstractInsnNode)tryLabel);
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, this.handlerClassName, this.handlerMethodName, targetMethodSig, false));
            method.instructions.add((AbstractInsnNode)new InsnNode(177));
            method.instructions.add((AbstractInsnNode)catchLabel);
            method.instructions.add((AbstractInsnNode)new InsnNode(177));
        }
    }

    public final String getPacketClass() {
        return this.packetClass;
    }

    public final int getPriority() {
        return this.priority;
    }

    protected abstract void notifyInjected();

    protected abstract void notifyInjectionFailed();

    private MethodNode findMethodByNameAndSignature(List<MethodNode> methods, String funcName, String funcSig) {
        for (MethodNode method : methods) {
            if (!funcName.equals(method.name) || !funcSig.equals(method.desc)) continue;
            return method;
        }
        return null;
    }

    public final SortableValue<String> getInfo(String className) {
        return new SortableValue<String>(this.priority, this.order, className);
    }
}

