#version 120

/*
BSL Shaders by Capt Tatsu
http://bitslablab.wixsite.com/main
*/

#define LightShaft

const bool colortex1MipmapEnabled = true;

varying vec3 upVec;
varying vec3 sunVec;

varying vec2 texcoord;

uniform int isEyeInWater;
uniform int worldTime;

uniform float blindness;
uniform float rainStrength;

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 sunPosition;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D depthtex0;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;
float sunVisibility = pow(clamp(dot(sunVec,upVec)+0.05,0.0,0.1)/0.1,2.0);
float nolight = 1.0-(clamp((time-12200.0)/500.0,0.0,1.0)-clamp((time-13000.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23250.0)/500.0,0.0,1.0));

#include "lib/color/lightColor.glsl"

void main() {
	vec4 color = texture2D(colortex0,texcoord.xy);
	
	//Light Shafts
	#ifdef LightShaft
	vec3 vl = texture2DLod(colortex1,texcoord.xy,1.5).rgb;
	float z = texture2D(depthtex0,texcoord.xy).r;
	
	vec4 fragpos = gbufferProjectionInverse * (vec4(texcoord.x, texcoord.y, z, 1.0) * 2.0 - 1.0);
	fragpos /= fragpos.w;
	
	float cosS = dot(normalize(fragpos.xyz),sunVec*(1.0-2.0*float(worldTime > 12700 && worldTime < 23250)));
	
	float b = clamp(blindness*2.0-1.0,0.0,1.0);
	b = b*b;
	
	color.rgb += vl * vl * light * (0.25 * mix(1.0,pow(max(cosS*0.5+0.5,0.0),5.0+10.0*tB*tB*(1.0-rainStrength)),0.5+0.5*eBS) * (1.0-rainStrength*eBS*0.5) * nolight * (1.0-b));
	//color.rgb = vl * vl;
	#endif
	
/*DRAWBUFFERS:0*/
	gl_FragData[0] = color;

}
