#version 120

/*
BSL Shaders by Capt Tatsu
http://bitslablab.wixsite.com/main
*/

#define FXAA
//#define RPSupport
#define RPSReflection

#define About 0 //[0]

//Buffer Format
const int R11F_G11F_B10F = 0;
const int RGB10_A2 = 1;
const int RGB16 = 2;
const int RGB8 = 3;
const int R32F = 4;
const int R16 = 5;

const int colortex0Format = R11F_G11F_B10F; //main
const int colortex1Format = RGB8; //raw translucent, bloom
const int colortex2Format = R16; //temporal stuff

const int gaux1Format = R32F; //depth
const int gaux2Format = RGB10_A2; //reflection image

#ifdef RPSupport
#ifdef RPSReflection
const int colortex3Format = RGB8; //reflection information
const int gaux3Format = RGB16; //normals
const int gaux4Format = RGB16; //raw solids
#endif
#endif

const float sunPathRotation = -40.0; //[-60.0 -55.0 -50.0 -45.0 -40.0 -35.0 -30.0 -25.0 -20.0 -15.0 -10.0 -5.0 0.0 5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 45.0 50.0 55.0 60.0]
const int noiseTextureResolution = 1024;
const bool shadowHardwareFiltering = true;
const float drynessHalflife = 10.0f;
const float wetnessHalflife = 15.0f;

varying vec2 texcoord;

uniform float aspectRatio;
uniform float frameTimeCounter;
uniform float viewWidth;
uniform float viewHeight;

uniform sampler2D colortex1;

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

void main() {
	
	vec3 color = texture2D(colortex1,texcoord.xy).rgb;
	
	#ifdef FXAA
	//FXAA from http://horde3d.org/wiki/index.php5?title=Shading_Technique_-_FXAA
	float FXAA_LUMA_THRESOLD = 1.0/16.0;
	float FXAA_SPAN_MAX = 8.0;
	float FXAA_REDUCE_MUL = 1.0/8.0;
	float FXAA_REDUCE_MIN = 1.0/128.0;
	
	vec2 view = vec2(viewWidth,viewHeight);
	
	vec3 rgbNW = texture2D(colortex1,texcoord.xy+(vec2(-1.0,-1.0)/view)).rgb;
	vec3 rgbNE = texture2D(colortex1,texcoord.xy+(vec2(1.0,-1.0)/view)).rgb;
	vec3 rgbSW = texture2D(colortex1,texcoord.xy+(vec2(-1.0,1.0)/view)).rgb;
	vec3 rgbSE = texture2D(colortex1,texcoord.xy+(vec2(1.0,1.0)/view)).rgb;
	vec3 rgbM  = color;
	
	float lumaNW = luma(rgbNW);
	float lumaNE = luma(rgbNE);
	float lumaSW = luma(rgbSW);
	float lumaSE = luma(rgbSE);
	float lumaM  = luma(rgbM);
	
	float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
	float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));
	
	if (lumaMax - lumaMin > lumaMax * FXAA_LUMA_THRESOLD){
		vec2 dir = vec2(0.0);
		dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
		dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
		
		float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_REDUCE_MUL),FXAA_REDUCE_MIN);
		
		float rcpDirMin = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);
		
		dir = clamp(dir*rcpDirMin,vec2(-FXAA_SPAN_MAX),vec2(FXAA_SPAN_MAX))/view;
		
		vec3 rgbA = 0.5 * (texture2D(colortex1, texcoord.xy + dir * (1.0/3.0 - 0.5)).xyz + texture2D(colortex1, texcoord.xy + dir * (2.0/3.0 - 0.5)).xyz);
		vec3 rgbB = rgbA * 0.5 + 0.25 * (texture2D(colortex1, texcoord.xy + dir * (0.0/3.0 - 0.5)).xyz + texture2D(colortex1, texcoord.xy + dir * (3.0/3.0 - 0.5)).xyz);
		float lumaB = luma(rgbB);

		if((lumaB < lumaMin) || (lumaB > lumaMax)){
				color=rgbA;
		}else{
				color=rgbB;
		}
		
	}
	#endif
	
	#ifdef About
	#endif
	
	gl_FragColor = vec4(color,1.0);

}
