#version 120

/*
BSL Shaders by Capt Tatsu
http://bitslablab.wixsite.com/main
*/

//#define RoundSunMoon

varying vec3 upVec;
varying vec3 sunVec;

uniform int isEyeInWater;
uniform int worldTime;

uniform float nightVision;
uniform float rainStrength;
uniform float viewWidth;
uniform float viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform mat4 gbufferProjectionInverse;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;
float sunVisibility = pow(clamp(dot(sunVec,upVec)+0.1,0.0,0.1)/0.1,2.0);
float moonVisibility = pow(clamp(dot(-sunVec,upVec)+0.1,0.0,0.1)/0.1,2.0);

#include "lib/color/lightColor.glsl"
#include "lib/color/skyColor.glsl"
#include "lib/common/sky.glsl"

void main() {
	//NDC Coordinate
	vec4 fragpos = gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z,1.0)*2.0-1.0);
	fragpos /= fragpos.w;
	
	//Render Sky
	vec3 albedo = getSkyColor(fragpos.xyz,light);
	
	//Round Sun & Moon
	#ifdef RoundSunMoon
	float cosS = dot(normalize(fragpos.xyz),sunVec);
	float sun = pow(abs(cosS),800.0) * (1.0-sqrt(rainStrength));
	vec3 light_me = mix(light_m,light_a,mefade);
	vec3 suncol = mix(sqrt(light_n)*moonVisibility,mix(light_me,light_d*light_me,tB)*sunVisibility,float(cosS > 0.0));
	albedo += (sun * 32.0) * suncol;
	#endif
	
	albedo *= 1.0+nightVision;
	
/* DRAWBUFFERS:0 */

	gl_FragData[0] = vec4(albedo,1.0);
}