#version 120

/*
BSL Shaders by Capt Tatsu
http://bitslablab.wixsite.com/main
*/

#define SkyBrightness 2.00 //[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00]
#define SkyDesaturation

varying vec2 texcoord;

varying vec3 upVec;
varying vec3 sunVec;

varying vec4 color;

uniform int isEyeInWater;
uniform int worldTime;

uniform float nightVision;
uniform float rainStrength;
uniform float viewWidth;
uniform float viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform mat4 gbufferProjectionInverse;

uniform sampler2D texture;

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;
float sunVisibility = pow(clamp(dot(sunVec,upVec)+0.1,0.0,0.1)/0.1,2.0);

#include "lib/color/lightColor.glsl"

void main() {
	//Texture
	vec4 albedo = texture2D(texture, texcoord.xy) * color;
	
	//Convert to linear color space
	albedo.rgb = pow(albedo.rgb,vec3(2.2)) * SkyBrightness * (1.0 - sqrt(rainStrength)) * albedo.a;
	
	#ifdef SkyDesaturation
	albedo.rgb = mix(length(albedo.rgb)*pow(light_n,vec3(0.8))*2.0,albedo.rgb,sunVisibility);
	#endif
	
/* DRAWBUFFERS:0 */

	gl_FragData[0] = albedo;
}