//#define CloudLighting
#define CloudThickness 4 //[1 2 4 8 16]
#define CloudAmount 11.0 //[13.0 12.0 11.0 10.0 9.0]
#define CloudHeight 16.0 //[8.0 12.0 16.0 20.0 24.0]
#define CloudOpacity 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

float cloudNoise(vec2 coord, vec2 wind){
	float noise = texture2D(noisetex,coord*0.5+wind*0.55).x;
	noise+= texture2D(noisetex,coord*0.25+wind*0.45).x*2;
	noise+= texture2D(noisetex,coord*0.125+wind*0.35).x*3;
	noise+= texture2D(noisetex,coord*0.0625+wind*0.25).x*4;
	noise+= texture2D(noisetex,coord*0.03125+wind*0.15).x*5;
	noise+= texture2D(noisetex,coord*0.016125+wind*0.05).x*6;
	return noise;
}

float cloudCoverage(float noise, float cosT, float step){
	return max(mix(noise, 21.0, 0.4 * wetness) * min(sqrt(cosT * 6.0), 1.0) - (CloudAmount + pow(abs(step) / 2.0, 2.0)), 0.0) * (1.0 - 0.5 * wetness) * sqrt(CloudThickness / 4.0);
}

vec3 drawCloud(vec3 fragpos, float dither, vec3 color, vec3 light, vec3 ambient) {
	float cosT = dot(normalize(fragpos),upVec);
	float cosS = dot(sunVec,normalize(fragpos));
	float abstB = abs(sin(time/12000*22/7));
	const float pi = 3.1415927;
	
	vec2 wind = vec2(frametime*0.001,0.0);

	float cloud = 0.0;
	vec3 cloudcolor = vec3(0.0);
	float cloudgradient = 0.0;
	float colmix = 0.125*dither;
	float colmult = (sunVisibility*0.35+0.15)*(1.0-rainStrength*(0.8-0.4*sunVisibility));
	float scattering = (0.25*sunVisibility+0.75)*pow(cosS*0.5*(2.0*sunVisibility-1.0)+0.5,12.0);

	if (cosT > 0.05){
		vec3 wpos = normalize((gbufferModelViewInverse * vec4(fragpos,1.0)).xyz);
		
		#ifdef CloudLighting
		vec3 wposl = normalize((gbufferModelViewInverse * vec4(fragpos+8.0*sqrt(cosT)*(2.0*sunVisibility-1.0)*sunVec,1.0)).xyz);
		#endif
		for (int i = 0; i < 8; i++) {
			vec3 intersection = wpos*((CloudHeight+(i+dither)/2.0)/wpos.y) * 0.002;
			vec2 coord = cameraPosition.xz * 0.00025 + intersection.xz;
			float noise = 0.0;
			
			#ifdef CloudLighting
			vec3 intersectionl = wposl*((CloudHeight+(i+dither)/2.0)/wposl.y) * 0.002;
			vec2 coordl = cameraPosition.xz * 0.00025 + intersectionl.xz;
			coordl += texture2D(noisetex,-coordl.xy+wind*0.55).xy * 0.001 - 0.0005;
			float noisel = 0.0;
			#endif
			
			if (cloud < 0.999){
				noise = cloudNoise(coord,wind);
				noise = cloudCoverage(noise, cosT, float(i-4.0+dither));
				noise = noise/pow(1.0+pow(noise,CloudThickness),1.0/CloudThickness);
				
				#ifdef CloudLighting
				noisel = cloudNoise(coordl,wind);
				noisel = cloudCoverage(noisel, cosT, float(i-4.0+dither));
				noisel = sqrt(clamp(noisel*clamp(sqrt(cosT*2.0),0.0,1.0)*0.5,0.0,1.0));
				#endif
			}
			#ifdef CloudLighting
			cloudgradient = mix(cloudgradient,mix(1.0-noisel,pow(colmix,2.5),0.5+0.25*abstB),noise*(1.0-cloud*cloud));
			colmult *= 1.0+(1.0-noisel)*scattering*noise*(1.0-cloud*cloud);
			#else
			cloudgradient = mix(cloudgradient,pow(colmix,2.0),noise*(1.0-cloud*cloud));
			#endif
			cloud = max(cloud,noise);
			colmix += 0.125;
		}
		cloudcolor = mix(ambient*((1.0-0.2*rainStrength)*(0.25*sunVisibility+0.75)),light,cloudgradient)*(2.0-eBS)*(1.0+nightVision);
		cloud *= sqrt(clamp(cosT*10.0-0.5,0.0,1.0))*(1.0-0.5*rainStrength*rainStrength);
	}
	return mix(color,cloudcolor*colmult,cloud*cloud*CloudOpacity);
}
float getnoise(vec2 pos){
	return fract(sin(dot(pos, vec2(12.9898, 4.1414))) * 43758.5453);
}

vec3 drawStars(vec3 fragpos, vec3 color, vec3 light){
	vec3 wpos = vec3(gbufferModelViewInverse * vec4(fragpos,1.0));
	vec3 intersection = wpos/(wpos.y+length(wpos.xz));
	vec2 wind = vec2(frametime,0.0);
	vec2 coord = floor((intersection.xz*0.4+cameraPosition.xz*0.0001+wind*0.00125)*1024.0)/1024.0;
	
	float NdotU = sqrt(sqrt(max(dot(normalize(fragpos),normalize(upVec)),0.0)));
	
	float star = 1.0;
	if (NdotU > 0.0){
		star *= getnoise(coord.xy);
		star *= getnoise(coord.xy+0.1);
		star *= getnoise(coord.xy+0.23);
	}
	star = max(star-0.825,0.0)*5.0*NdotU*(1.0-rainStrength)*moonVisibility;
		
	return color + star*pow(light,vec3(0.8));
}