vec3 getFogColor(vec3 fragpos, vec3 light){
vec3 fog_col = fog_c;
vec3 nfragpos = normalize(fragpos);
float lfragpos = length(fragpos)/64.0;
lfragpos /= 1.0+lfragpos;

float NdotS = dot(nfragpos,sunVec)*0.5+0.5;

float lightmix = NdotS*(1.0-sqrt(tB))*sunVisibility*(1.0-rainStrength)*lfragpos*eBS;

fog_col = (mix(fog_col*pow(max(1-lightmix,0.0),2.0),pow(light,vec3(1.5)),lightmix)*sunVisibility + light_n*0.4)*1.2;
fog_col = mix(fog_col,weather*(0.035+0.455*sunVisibility),rainStrength)*0.5;

return pow(fog_col,vec3(1.15));
}

vec3 calcNormalFog(vec3 color, vec3 fragpos, vec3 light){
float fog = length(fragpos)/(16.0*FogRange*(1.0+sunVisibility))*eBS*(0.875*rainStrength+0.125);
fog = fog/sqrt(sqrt((fog*fog)*(fog*fog)+1.0));
return mix(color,getFogColor(fragpos,light),fog);
}

vec3 calcBlindFog(vec3 color, vec3 fragpos, float blindness){
	float b = clamp(blindness*2.0-1.0,0.0,1.0);
	b = b*b;
	float fog = pow(min(length(fragpos)/(5.0/b),1.0),1.0/2.2)*b;
	return mix(color,vec3(0.0),fog);
}

vec3 calcLavaFog(vec3 color, vec3 fragpos){
	float fog = min(length(fragpos)/(2.0),1.0);
	#ifdef EmissiveRecolor
	return mix(color,pow(Torch,vec3(4.0))*4.0,fog);
	#else
	return mix(color,vec3(1.0,0.3,0.01),fog);
	#endif
}

vec3 calcFog(vec3 color, vec3 fragpos, vec3 light, float blindness){
	color = calcNormalFog(color, fragpos, light);
	if (isEyeInWater == 2.0) color = calcLavaFog(color, fragpos);
	if (blindness > 0.0) color = calcBlindFog(color, fragpos, blindness);
	return color;
}