vec3 getSkyColor(vec3 fragpos, vec3 light){
vec3 sky_col = sky_c;
vec3 nfragpos = normalize(fragpos);

float NdotUp = dot(nfragpos,upVec);
float NdotS = dot(nfragpos,sunVec)*0.5+0.5;

float top = pow(max(NdotUp,0.1),0.25)*0.475;
float horizon = pow(1.0-abs(NdotUp),2.5)*(0.4*sunVisibility+0.2)*(1-rainStrength*0.75);
float lightmix = (NdotS*NdotS*(1-max(NdotUp,0.0))*pow(1.0-tB,3.0) + horizon*0.1*tB)*sunVisibility*(1.0-rainStrength);

#ifdef SkyV
sky_col = mix(sky_col,fog_c,max(1.0-abs(NdotUp),0.0));
#endif

float mult = 0.5 - top*(1.0-rainStrength*rainStrength*0.4) + horizon;

sky_col = (mix(sky_col*pow(max(1-lightmix,0.0),2.0),pow(light,vec3(1.5)),lightmix)*sunVisibility + light_n*0.4);
sky_col = mix(sky_col,pow(mult,0.2)*weather*(0.05+0.65*sunVisibility),rainStrength)*mult*(3.0-2.0*eBS);

return pow(sky_col,vec3(1.15));
}