vec3 calcNormalFog(vec3 color, vec3 fragpos){
float fog = length(fragpos)/far*1.2;
return mix(color,nether_c*0.005,min(fog,1.0));
}

vec3 calcBlindFog(vec3 color, vec3 fragpos, float blindness){
	float b = clamp(blindness*2.0-1.0,0.0,1.0);
	b = b*b;
	float fog = pow(min(length(fragpos)/(5.0/b),1.0),1.0/2.2)*b;
	return mix(color,vec3(0.0),fog);
}

vec3 calcLavaFog(vec3 color, vec3 fragpos){
	float fog = min(length(fragpos)/(2.0),1.0);
	#ifdef EmissiveRecolor
	return mix(color,pow(Torch,vec3(4.0))*4.0,fog);
	#else
	return mix(color,vec3(1.0,0.3,0.01),fog);
	#endif
}

vec3 calcFog(vec3 color, vec3 fragpos, float blindness){
	color = calcNormalFog(color, fragpos);
	if (isEyeInWater == 2.0) color = calcLavaFog(color, fragpos);
	if (blindness > 0.0) color = calcBlindFog(color, fragpos, blindness);
	return color;
}