#version 120

/*
BSL Shaders by Capt Tatsu
http://bitslablab.wixsite.com/main
*/

/*
Note : gbuffers_basic, gbuffers_entities, gbuffers_hand, gbuffers_terrain, gbuffers_textured, and gbuffers_water contains mostly the same code. If you edited one of these files, you need to do the same thing for the rest of the file listed.
*/

#define Desaturation
//#define DisableTexture

#define ShadowColor
#define ShadowFilter

const int shadowMapResolution = 2048; //[1024 2048 3072 4096]
const float shadowDistance = 256.0; //[128.0 256.0 512.0 1024.0]
const float shadowMapBias = 1.0-25.6/shadowDistance;

varying float mat;

varying vec2 lmcoord;
varying vec2 texcoord;

varying vec3 normal;
varying vec3 upVec;
varying vec3 sunVec;

varying vec4 color;

uniform int isEyeInWater;
uniform int worldTime;

uniform float frameTimeCounter;
uniform float nightVision;
uniform float rainStrength;
uniform float viewWidth;
uniform float viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform sampler2DShadow shadowtex0;
#ifdef ShadowColor
uniform sampler2DShadow shadowtex1;
uniform sampler2D shadowcolor0;
#endif

float time = float(worldTime);
float tB = max(sin(time/12000*22/7),0.0);
float eBS = eyeBrightnessSmooth.y/240.0;
float sunVisibility = pow(clamp(dot(sunVec,upVec)+0.1,0.0,0.1)/0.1,2.0);

float nolight = 1.0-(clamp((time-12200.0)/500.0,0.0,1.0)-clamp((time-13000.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23250.0)/500.0,0.0,1.0));

float luma(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

#include "lib/color/dimensionColor.glsl"
#include "lib/color/torchColor.glsl"
#include "lib/common/spaceConversion.glsl"

void main() {
	//Texture
	vec4 albedo = color;
	
	if (albedo.a > 0.0){
		//Modify Alpha
		albedo.a = albedo.a * 0.5 + 0.5;
		
		//NDC Coordinate
		vec3 fragpos = toNDC(vec3(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z));
		
		//World Space Coordinate
		vec3 worldpos = toWorld(fragpos);
		
		//Convert to linear color space
		albedo.rgb = pow(albedo.rgb, vec3(2.2));
		
		#ifdef DisableTexture
		if (dot(albedo.rgb,albedo.rgb) > 0.001) albedo.rgb = vec3(0.5);
		#endif
		
		//Lightmap
		#ifdef LightmapBanding
		float torchmap = floor(lmcoord.x*15.999) * floor(lmcoord.x*15.999) / 225;
		float skymap = floor(lmcoord.y*15.999) * floor(lmcoord.y*15.999) / 225;
		#else
		float torchmap = lmcoord.x * lmcoord.x;
		float skymap = lmcoord.y * lmcoord.y;
		#endif
		
		//Shadows
		float shadow = 0.0;
		vec3 shadowcol = vec3(0.0);
		
		float NdotL = clamp(dot(normal,sunVec)*1.05-0.05,0.0,1.0);
		
		worldpos = toShadow(worldpos);
		
		float distb = sqrt(worldpos.x * worldpos.x + worldpos.y * worldpos.y);
		float distortFactor = 1.0 - shadowMapBias + distb * shadowMapBias;
		
		worldpos.xy /= distortFactor;
		worldpos.z *= 0.2;
		worldpos = worldpos*0.5+0.5;
		
		if (NdotL > 0.0){
			float diffthresh = (0.1 + 8.0 * distortFactor * distortFactor * tan(acos(abs((NdotL+0.05)/1.05))) * pow(shadowDistance/256.0, 2.0)) / shadowMapResolution;
			float step = 1.0/shadowMapResolution;
			
			#ifdef ShadowFilter
			shadow = shadow2D(shadowtex0,vec3(worldpos.st, worldpos.z-diffthresh)).x;
			shadow += shadow2D(shadowtex0,vec3(worldpos.st+vec2(step,0), worldpos.z-diffthresh)).x;
			shadow += shadow2D(shadowtex0,vec3(worldpos.st+vec2(-step,0), worldpos.z-diffthresh)).x;
			shadow += shadow2D(shadowtex0,vec3(worldpos.st+vec2(0,step), worldpos.z-diffthresh)).x;
			shadow += shadow2D(shadowtex0,vec3(worldpos.st+vec2(0,-step), worldpos.z-diffthresh)).x;
			shadow += shadow2D(shadowtex0,vec3(worldpos.st+vec2(step,step)*0.7, worldpos.z-diffthresh)).x;
			shadow += shadow2D(shadowtex0,vec3(worldpos.st+vec2(step,-step)*0.7, worldpos.z-diffthresh)).x;
			shadow += shadow2D(shadowtex0,vec3(worldpos.st+vec2(-step,step)*0.7, worldpos.z-diffthresh)).x;
			shadow += shadow2D(shadowtex0,vec3(worldpos.st+vec2(-step,-step)*0.7, worldpos.z-diffthresh)).x;
			shadow /= 9;
			#else
			shadow = shadow2D(shadowtex0,vec3(worldpos.st, worldpos.z-diffthresh)).x;
			#endif
			
			if (shadow < 0.999){
				#ifdef ShadowColor
					#ifdef ShadowFilter
					shadowcol = texture2D(shadowcolor0,worldpos.st).rgb*shadow2D(shadowtex1,vec3(worldpos.st, worldpos.z-diffthresh)).x;
					shadowcol += texture2D(shadowcolor0,worldpos.st+vec2(step,0)).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(step,0), worldpos.z-diffthresh)).x;
					shadowcol += texture2D(shadowcolor0,worldpos.st+vec2(-step,0)).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(-step,0), worldpos.z-diffthresh)).x;
					shadowcol += texture2D(shadowcolor0,worldpos.st+vec2(0,step)).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(0,step), worldpos.z-diffthresh)).x;
					shadowcol += texture2D(shadowcolor0,worldpos.st+vec2(0,-step)).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(0,-step), worldpos.z-diffthresh)).x;
					shadowcol += texture2D(shadowcolor0,worldpos.st+vec2(step,step)*0.7).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(step,step)*0.7, worldpos.z-diffthresh)).x;
					shadowcol += texture2D(shadowcolor0,worldpos.st+vec2(step,-step)*0.7).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(step,step)*0.7, worldpos.z-diffthresh)).x;
					shadowcol += texture2D(shadowcolor0,worldpos.st+vec2(-step,step)*0.7).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(step,step)*0.7, worldpos.z-diffthresh)).x;
					shadowcol += texture2D(shadowcolor0,worldpos.st+vec2(-step,-step)*0.7).rgb*shadow2D(shadowtex1,vec3(worldpos.st+vec2(step,step)*0.7, worldpos.z-diffthresh)).x;
					shadowcol /= 9;
					#else
					shadowcol = texture2D(shadowcolor0,worldpos.st).rgb*shadow2D(shadowtex1,vec3(worldpos.st, worldpos.z-diffthresh)).x;
					#endif
				#endif
			}
		}
		
		vec3 fullshading = max(vec3(shadow), shadowcol) * NdotL;
		
		//Lighting Calculation
		vec3 scenelight = mix(end_c*0.025, end_c*0.1, fullshading);
		float newtorchmap = clamp(torchmap-0.7,0.0,1.0) * 4.0;
		newtorchmap = newtorchmap * newtorchmap + (torchmap * 0.75);
		
		vec3 torchlight = (newtorchmap * newtorchmap) * torch_c;
		float minlight = 0.01*(1.0-eBS);
		
		vec3 finallight = scenelight + torchlight + nightVision + minlight;
		albedo.rgb /= sqrt(albedo.rgb * albedo.rgb + 1.0);
		albedo.rgb *= finallight;
		
		#ifdef Desaturation
		float desat = clamp(sqrt(torchmap), 0.2 ,1.0);
		vec3 desat_c = end_c*0.125*(1.0-desat);
		albedo.rgb = mix(dot(albedo.rgb,vec3(0.299, 0.587, 0.114))*desat_c*6.0,albedo.rgb,desat);
		#endif
	}
	
/* DRAWBUFFERS:0 */

	gl_FragData[0] = albedo;
}