#define AORadius 0 //[0 1 2]
float dither5x3()
{
	const int ditherPattern[15] = int[15](
		 9, 3, 7,12, 0,
		11, 5, 1,14, 8,
		 2,13,10, 4, 6);

    vec2 position = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), vec2(5.0,3.0)));

	int dither = ditherPattern[int(position.x) + int(position.y) * 5];

	return float(dither) / 15.0f;
}

float dbao(sampler2D depth, float dither){
	float ao = 0.0;
	
	const int aoloop = 2*AORadius+3;
	const int aoside = 2*AORadius+6;
	float size = 0.2 * gbufferProjection[1][1] / 2.74747742;
	for(int i=0;i<AORadius;i++) size *= 0.5;
	float dither2 = fract(dither5x3()-dither);
	float d = ld(texture2D(depth,texcoord.xy).r);
	const float piangle = 0.0174603175;
	float rot = (360.0/aoside)*(dither2+0.5)+90.0;
	float scale = size*dither;
	float sd = 0.0;
	float angle = 0.0;
	float dist = 0.0;
	
	
	for (int i = 0; i < aoloop; i++) {
		for (int j = 0; j < aoside; j++) {
			sd = ld(texture2D(depth,texcoord.xy+vec2(cos(rot*piangle),sin(rot*piangle))*scale/max(far*d,4.0)*vec2(1.0/aspectRatio,1.0)).r);
			angle += clamp(1.0-1.0/size*far*(d-sd),0.0,2.0);
			dist += clamp(0.125/size*far*(d-sd),0.0,2.0);
			rot += 360.0/aoside;
		}
		rot += 180.0/aoside;
		scale = size*dither+size;
		size *= 2.0;
		ao += clamp((angle+dist)/aoside,0.0,1.0);
		angle = 0.0;
		dist = 0.0;
	}
	
	ao /= aoloop;
	
	return pow(ao,0.5*AORadius+1.5);
}