/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.linux.proc;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.FileUtil;
import oshi.util.platform.linux.ProcPath;

@ThreadSafe
public final class Auxv {
    public static final int AT_PAGESZ = 6;
    public static final int AT_HWCAP = 16;
    public static final int AT_CLKTCK = 17;

    private Auxv() {
    }

    public static Map<Integer, Long> queryAuxv() {
        int n;
        ByteBuffer byteBuffer = FileUtil.readAllBytesAsBuffer(ProcPath.AUXV);
        HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
        do {
            if ((n = FileUtil.readNativeLongFromBuffer(byteBuffer).intValue()) <= 0) continue;
            hashMap.put(n, FileUtil.readNativeLongFromBuffer(byteBuffer).longValue());
        } while (n > 0);
        return hashMap;
    }
}

