/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.SetupApi;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APITypeMapper;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.jna.ByRef;
import oshi.jna.Struct;
import oshi.jna.platform.windows.PowrProf;

@ThreadSafe
public final class WindowsPowerSource
extends AbstractPowerSource {
    private static final Guid.GUID GUID_DEVCLASS_BATTERY = Guid.GUID.fromString("{72631E54-78A4-11D0-BCF7-00AA00B7B32A}");
    private static final int CHAR_WIDTH = W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE ? 2 : 1;
    private static final boolean X64 = Platform.is64Bit();
    private static final int BATTERY_SYSTEM_BATTERY = Integer.MIN_VALUE;
    private static final int BATTERY_IS_SHORT_TERM = 0x20000000;
    private static final int BATTERY_POWER_ON_LINE = 1;
    private static final int BATTERY_DISCHARGING = 2;
    private static final int BATTERY_CHARGING = 4;
    private static final int BATTERY_CAPACITY_RELATIVE = 0x40000000;
    private static final int IOCTL_BATTERY_QUERY_TAG = 2703424;
    private static final int IOCTL_BATTERY_QUERY_STATUS = 2703436;
    private static final int IOCTL_BATTERY_QUERY_INFORMATION = 2703428;

    public WindowsPowerSource(String string, String string2, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, PowerSource.CapacityUnits capacityUnits, int n, int n2, int n3, int n4, String string3, LocalDate localDate, String string4, String string5, double d7) {
        super(string, string2, d, d2, d3, d4, d5, d6, bl, bl2, bl3, capacityUnits, n, n2, n3, n4, string3, localDate, string4, string5, d7);
    }

    public static List<PowerSource> getPowerSources() {
        return Arrays.asList(WindowsPowerSource.getPowerSource("System Battery"));
    }

    private static WindowsPowerSource getPowerSource(String string) {
        String string2 = string;
        String string3 = "unknown";
        double d = 1.0;
        double d2 = -1.0;
        double d3 = 0.0;
        int n = 0;
        double d4 = -1.0;
        double d5 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        PowerSource.CapacityUnits capacityUnits = PowerSource.CapacityUnits.RELATIVE;
        int n2 = 0;
        int n3 = 1;
        int n4 = 1;
        int n5 = -1;
        String string4 = "unknown";
        LocalDate localDate = null;
        String string5 = "unknown";
        String string6 = "unknown";
        double d6 = 0.0;
        try (Object object = new PowrProf.SystemBatteryState();){
            if (0 == PowrProf.INSTANCE.CallNtPowerInformation(5, null, 0, ((Structure)object).getPointer(), ((Structure)object).size()) && ((PowrProf.SystemBatteryState)object).batteryPresent > 0) {
                if (((PowrProf.SystemBatteryState)object).acOnLine == 0 && ((PowrProf.SystemBatteryState)object).charging == 0 && ((PowrProf.SystemBatteryState)object).discharging > 0) {
                    d2 = ((PowrProf.SystemBatteryState)object).estimatedTime;
                } else if (((PowrProf.SystemBatteryState)object).charging > 0) {
                    d2 = -2.0;
                }
                n3 = ((PowrProf.SystemBatteryState)object).maxCapacity;
                n2 = ((PowrProf.SystemBatteryState)object).remainingCapacity;
                d = Math.min(1.0, (double)n2 / (double)n3);
                n = ((PowrProf.SystemBatteryState)object).rate;
            }
        }
        object = SetupApi.INSTANCE.SetupDiGetClassDevs(GUID_DEVCLASS_BATTERY, null, null, 18);
        if (!WinBase.INVALID_HANDLE_VALUE.equals(object)) {
            boolean bl4 = false;
            for (int i = 0; !bl4 && i < 100; ++i) {
                try (Struct.CloseableSpDeviceInterfaceData closeableSpDeviceInterfaceData = new Struct.CloseableSpDeviceInterfaceData();
                     ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();
                     ByRef.CloseableIntByReference closeableIntByReference2 = new ByRef.CloseableIntByReference();
                     ByRef.CloseableIntByReference closeableIntByReference3 = new ByRef.CloseableIntByReference();
                     ByRef.CloseableIntByReference closeableIntByReference4 = new ByRef.CloseableIntByReference();){
                    closeableSpDeviceInterfaceData.cbSize = closeableSpDeviceInterfaceData.size();
                    if (SetupApi.INSTANCE.SetupDiEnumDeviceInterfaces((WinNT.HANDLE)object, null, GUID_DEVCLASS_BATTERY, i, closeableSpDeviceInterfaceData)) {
                        SetupApi.INSTANCE.SetupDiGetDeviceInterfaceDetail((WinNT.HANDLE)object, closeableSpDeviceInterfaceData, null, 0, closeableIntByReference, null);
                        if (122 != Kernel32.INSTANCE.GetLastError()) continue;
                        try (Memory memory = new Memory(closeableIntByReference.getValue());){
                            WinNT.HANDLE hANDLE;
                            block95: {
                                String string7;
                                memory.setInt(0L, 4 + (X64 ? 4 : CHAR_WIDTH));
                                if (!SetupApi.INSTANCE.SetupDiGetDeviceInterfaceDetail((WinNT.HANDLE)object, closeableSpDeviceInterfaceData, memory, (int)memory.size(), closeableIntByReference, null) || WinBase.INVALID_HANDLE_VALUE.equals(hANDLE = Kernel32.INSTANCE.CreateFile(string7 = CHAR_WIDTH > 1 ? memory.getWideString(4L) : memory.getString(4L), -1073741824, 3, null, 3, 128, null))) continue;
                                try (PowrProf.BATTERY_QUERY_INFORMATION bATTERY_QUERY_INFORMATION = new PowrProf.BATTERY_QUERY_INFORMATION();
                                     PowrProf.BATTERY_INFORMATION bATTERY_INFORMATION = new PowrProf.BATTERY_INFORMATION();
                                     PowrProf.BATTERY_WAIT_STATUS bATTERY_WAIT_STATUS = new PowrProf.BATTERY_WAIT_STATUS();
                                     PowrProf.BATTERY_STATUS bATTERY_STATUS = new PowrProf.BATTERY_STATUS();
                                     PowrProf.BATTERY_MANUFACTURE_DATE bATTERY_MANUFACTURE_DATE = new PowrProf.BATTERY_MANUFACTURE_DATE();){
                                    if (!Kernel32.INSTANCE.DeviceIoControl(hANDLE, 2703424, closeableIntByReference2.getPointer(), 4, closeableIntByReference3.getPointer(), 4, closeableIntByReference4, null)) break block95;
                                    bATTERY_QUERY_INFORMATION.BatteryTag = closeableIntByReference3.getValue();
                                    if (bATTERY_QUERY_INFORMATION.BatteryTag <= 0) break block95;
                                    bATTERY_QUERY_INFORMATION.InformationLevel = PowrProf.BATTERY_QUERY_INFORMATION_LEVEL.BatteryInformation.ordinal();
                                    bATTERY_QUERY_INFORMATION.write();
                                    if (!Kernel32.INSTANCE.DeviceIoControl(hANDLE, 2703428, bATTERY_QUERY_INFORMATION.getPointer(), bATTERY_QUERY_INFORMATION.size(), bATTERY_INFORMATION.getPointer(), bATTERY_INFORMATION.size(), closeableIntByReference4, null)) break block95;
                                    bATTERY_INFORMATION.read();
                                    if (0 != (bATTERY_INFORMATION.Capabilities & Integer.MIN_VALUE) && 0 == (bATTERY_INFORMATION.Capabilities & 0x20000000)) {
                                        if (0 == (bATTERY_INFORMATION.Capabilities & 0x40000000)) {
                                            capacityUnits = PowerSource.CapacityUnits.MWH;
                                        }
                                        string4 = Native.toString(bATTERY_INFORMATION.Chemistry, StandardCharsets.US_ASCII);
                                        n4 = bATTERY_INFORMATION.DesignedCapacity;
                                        n3 = bATTERY_INFORMATION.FullChargedCapacity;
                                        n5 = bATTERY_INFORMATION.CycleCount;
                                        bATTERY_WAIT_STATUS.BatteryTag = bATTERY_QUERY_INFORMATION.BatteryTag;
                                        bATTERY_WAIT_STATUS.write();
                                        if (Kernel32.INSTANCE.DeviceIoControl(hANDLE, 2703436, bATTERY_WAIT_STATUS.getPointer(), bATTERY_WAIT_STATUS.size(), bATTERY_STATUS.getPointer(), bATTERY_STATUS.size(), closeableIntByReference4, null)) {
                                            bATTERY_STATUS.read();
                                            if (0 != (bATTERY_STATUS.PowerState & 1)) {
                                                bl = true;
                                            }
                                            if (0 != (bATTERY_STATUS.PowerState & 2)) {
                                                bl3 = true;
                                            }
                                            if (0 != (bATTERY_STATUS.PowerState & 4)) {
                                                bl2 = true;
                                            }
                                            n2 = bATTERY_STATUS.Capacity;
                                            d4 = bATTERY_STATUS.Voltage > 0 ? (double)bATTERY_STATUS.Voltage / 1000.0 : (double)bATTERY_STATUS.Voltage;
                                            n = bATTERY_STATUS.Rate;
                                            if (d4 > 0.0) {
                                                d5 = (double)n / d4;
                                            }
                                        }
                                    }
                                    string3 = WindowsPowerSource.batteryQueryString(hANDLE, closeableIntByReference3.getValue(), PowrProf.BATTERY_QUERY_INFORMATION_LEVEL.BatteryDeviceName.ordinal());
                                    string5 = WindowsPowerSource.batteryQueryString(hANDLE, closeableIntByReference3.getValue(), PowrProf.BATTERY_QUERY_INFORMATION_LEVEL.BatteryManufactureName.ordinal());
                                    string6 = WindowsPowerSource.batteryQueryString(hANDLE, closeableIntByReference3.getValue(), PowrProf.BATTERY_QUERY_INFORMATION_LEVEL.BatterySerialNumber.ordinal());
                                    bATTERY_QUERY_INFORMATION.InformationLevel = PowrProf.BATTERY_QUERY_INFORMATION_LEVEL.BatteryManufactureDate.ordinal();
                                    bATTERY_QUERY_INFORMATION.write();
                                    if (Kernel32.INSTANCE.DeviceIoControl(hANDLE, 2703428, bATTERY_QUERY_INFORMATION.getPointer(), bATTERY_QUERY_INFORMATION.size(), bATTERY_MANUFACTURE_DATE.getPointer(), bATTERY_MANUFACTURE_DATE.size(), closeableIntByReference4, null)) {
                                        bATTERY_MANUFACTURE_DATE.read();
                                        if (bATTERY_MANUFACTURE_DATE.Year > 1900 && bATTERY_MANUFACTURE_DATE.Month > 0 && bATTERY_MANUFACTURE_DATE.Day > 0) {
                                            localDate = LocalDate.of((int)bATTERY_MANUFACTURE_DATE.Year, bATTERY_MANUFACTURE_DATE.Month, (int)bATTERY_MANUFACTURE_DATE.Day);
                                        }
                                    }
                                    bATTERY_QUERY_INFORMATION.InformationLevel = PowrProf.BATTERY_QUERY_INFORMATION_LEVEL.BatteryTemperature.ordinal();
                                    bATTERY_QUERY_INFORMATION.write();
                                    try (ByRef.CloseableIntByReference closeableIntByReference5 = new ByRef.CloseableIntByReference();){
                                        if (Kernel32.INSTANCE.DeviceIoControl(hANDLE, 2703428, bATTERY_QUERY_INFORMATION.getPointer(), bATTERY_QUERY_INFORMATION.size(), closeableIntByReference5.getPointer(), 4, closeableIntByReference4, null)) {
                                            d6 = (double)closeableIntByReference5.getValue() / 10.0 - 273.15;
                                        }
                                    }
                                    bATTERY_QUERY_INFORMATION.InformationLevel = PowrProf.BATTERY_QUERY_INFORMATION_LEVEL.BatteryEstimatedTime.ordinal();
                                    if (n != 0) {
                                        bATTERY_QUERY_INFORMATION.AtRate = n;
                                    }
                                    bATTERY_QUERY_INFORMATION.write();
                                    closeableIntByReference5 = new ByRef.CloseableIntByReference();
                                    try {
                                        if (Kernel32.INSTANCE.DeviceIoControl(hANDLE, 2703428, bATTERY_QUERY_INFORMATION.getPointer(), bATTERY_QUERY_INFORMATION.size(), closeableIntByReference5.getPointer(), 4, closeableIntByReference4, null)) {
                                            d3 = closeableIntByReference5.getValue();
                                        }
                                    }
                                    finally {
                                        closeableIntByReference5.close();
                                    }
                                    if (d3 < 0.0 && n != 0 && (d3 = (double)(n3 - n2) * 3600.0 / (double)n) < 0.0) {
                                        d3 *= -1.0;
                                    }
                                    bl4 = true;
                                }
                            }
                            Kernel32.INSTANCE.CloseHandle(hANDLE);
                            continue;
                        }
                    }
                    if (259 != Kernel32.INSTANCE.GetLastError()) continue;
                    break;
                }
            }
            SetupApi.INSTANCE.SetupDiDestroyDeviceInfoList((WinNT.HANDLE)object);
        }
        return new WindowsPowerSource(string2, string3, d, d2, d3, n, d4, d5, bl, bl2, bl3, capacityUnits, n2, n3, n4, n5, string4, localDate, string5, string6, d6);
    }

    /*
     * Exception decompiling
     */
    private static String batteryQueryString(WinNT.HANDLE var0, int var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

