/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.unix.openbsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.ByRef;
import oshi.jna.platform.unix.OpenBsdLibc;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class OpenBsdSysctlUtil {
    private static final String SYSCTL_N = "sysctl -n ";
    private static final Logger LOG = LoggerFactory.getLogger(OpenBsdSysctlUtil.class);
    private static final String SYSCTL_FAIL = "Failed sysctl call: {}, Error code: {}";

    private OpenBsdSysctlUtil() {
    }

    public static int sysctl(int[] nArray, int n) {
        int n2 = OpenBsdLibc.INT_SIZE;
        try (Memory memory = new Memory(n2);){
            ByRef.CloseableSizeTByReference closeableSizeTByReference;
            block12: {
                closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)n2);
                try {
                    if (0 == OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) break block12;
                    LOG.warn(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
                    int n3 = n;
                    closeableSizeTByReference.close();
                    return n3;
                }
                catch (Throwable throwable) {
                    try {
                        closeableSizeTByReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            int n4 = memory.getInt(0L);
            closeableSizeTByReference.close();
            return n4;
        }
    }

    public static long sysctl(int[] nArray, long l) {
        int n = OpenBsdLibc.UINT64_SIZE;
        try (Memory memory = new Memory(n);){
            ByRef.CloseableSizeTByReference closeableSizeTByReference;
            block12: {
                closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)n);
                try {
                    if (0 == OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) break block12;
                    LOG.warn(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
                    long l2 = l;
                    closeableSizeTByReference.close();
                    return l2;
                }
                catch (Throwable throwable) {
                    try {
                        closeableSizeTByReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            long l3 = memory.getLong(0L);
            closeableSizeTByReference.close();
            return l3;
        }
    }

    public static String sysctl(int[] nArray, String string) {
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference();){
            Memory memory;
            block14: {
                if (0 != OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, null, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                    LOG.warn(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
                    String string2 = string;
                    return string2;
                }
                memory = new Memory(closeableSizeTByReference.longValue() + 1L);
                try {
                    if (0 == OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) break block14;
                    LOG.warn(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
                    String string3 = string;
                    memory.close();
                    return string3;
                }
                catch (Throwable throwable) {
                    try {
                        memory.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            String string4 = memory.getString(0L);
            memory.close();
            return string4;
        }
    }

    public static boolean sysctl(int[] nArray, Structure structure) {
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)structure.size());){
            if (0 != OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, structure.getPointer(), closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                LOG.error(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
                boolean bl = false;
                return bl;
            }
        }
        structure.read();
        return true;
    }

    public static Memory sysctl(int[] nArray) {
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference();){
            if (0 != OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, null, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                LOG.error(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
                Memory memory = null;
                return memory;
            }
            Memory memory = new Memory(closeableSizeTByReference.longValue());
            if (0 != OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                LOG.error(SYSCTL_FAIL, (Object)nArray, (Object)Native.getLastError());
                memory.close();
                Memory memory2 = null;
                return memory2;
            }
            Memory memory3 = memory;
            return memory3;
        }
    }

    public static int sysctl(String string, int n) {
        return ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer(SYSCTL_N + string), n);
    }

    public static long sysctl(String string, long l) {
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer(SYSCTL_N + string), l);
    }

    public static String sysctl(String string, String string2) {
        String string3 = ExecutingCommand.getFirstAnswer(SYSCTL_N + string);
        if (null == string3 || string3.isEmpty()) {
            return string2;
        }
        return string3;
    }
}

