/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.utils.helper.IOHelper;

public final class PlayerProfile {
    public final UUID uuid;
    public final String username;
    public final float money;
    public final Map<String, Texture> assets;
    public final Map<String, String> properties;

    @Deprecated
    public PlayerProfile(UUID uUID, String string, Texture texture, Texture texture2) {
        this(uUID, string, texture, texture2, new HashMap<String, String>());
    }

    @Deprecated
    public PlayerProfile(UUID uUID, String string, Texture texture, Texture texture2, Map<String, String> map) {
        this.uuid = Objects.requireNonNull(uUID, "uuid");
        this.username = string;
        this.assets = new HashMap<String, Texture>();
        if (texture != null) {
            this.assets.put("SKIN", texture);
        }
        if (texture2 != null) {
            this.assets.put("CAPE", texture2);
        }
        this.properties = map;
        this.money = 0.0f;
    }

    public PlayerProfile(UUID uUID, String string, Map<String, Texture> map, Map<String, String> map2) {
        this.uuid = uUID;
        this.username = string;
        this.assets = map;
        this.properties = map2;
        this.money = 0.0f;
    }

    public PlayerProfile(UUID uUID, String string, Map<String, Texture> map, Map<String, String> map2, float f) {
        this.uuid = uUID;
        this.username = string;
        this.assets = map;
        this.properties = map2;
        this.money = f;
    }

    public static PlayerProfile newOfflineProfile(String string) {
        return new PlayerProfile(PlayerProfile.offlineUUID(string), string, new HashMap<String, Texture>(), new HashMap<String, String>());
    }

    public static UUID offlineUUID(String string) {
        return UUID.nameUUIDFromBytes(IOHelper.encodeASCII("OfflinePlayer:" + string));
    }
}

