/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import java.util.concurrent.TimeUnit;
import pro.gravit.launcher.request.websockets.ClientJSONPoint;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.SimpleChannelInboundHandler;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import pro.gravit.repackage.io.netty.util.CharsetUtil;
import pro.gravit.utils.helper.LogHelper;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClientHandshaker handshaker;
    private final ClientJSONPoint clientJSONPoint;
    private ChannelPromise handshakeFuture;

    public WebSocketClientHandler(WebSocketClientHandshaker webSocketClientHandshaker, ClientJSONPoint clientJSONPoint) {
        this.handshaker = webSocketClientHandshaker;
        this.clientJSONPoint = clientJSONPoint;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.handshakeFuture = channelHandlerContext.newPromise();
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        this.handshaker.handshake(channelHandlerContext.channel());
        this.clientJSONPoint.onOpen();
        channelHandlerContext.executor().scheduleWithFixedDelay(() -> channelHandlerContext.channel().writeAndFlush(new PingWebSocketFrame()), 20L, 20L, TimeUnit.SECONDS);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.clientJSONPoint.onDisconnect();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext channelHandlerContext, Object object) {
        Channel channel = channelHandlerContext.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            this.handshaker.finishHandshake(channel, (FullHttpResponse)object);
            this.handshakeFuture.setSuccess();
            return;
        }
        if (object instanceof FullHttpResponse) {
            FullHttpResponse fullHttpResponse = (FullHttpResponse)object;
            throw new Exception("Unexpected FullHttpResponse (getStatus=" + fullHttpResponse.status() + ", content=" + fullHttpResponse.content().toString(CharsetUtil.UTF_8) + ')');
        }
        WebSocketFrame webSocketFrame = (WebSocketFrame)object;
        if (webSocketFrame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)webSocketFrame;
            if (LogHelper.isDevEnabled()) {
                LogHelper.dev("Message: %s", textWebSocketFrame.text());
            }
            this.clientJSONPoint.onMessage(textWebSocketFrame.text());
        } else if (webSocketFrame instanceof PingWebSocketFrame) {
            webSocketFrame.content().retain();
            channel.writeAndFlush(new PongWebSocketFrame(webSocketFrame.content()), channel.voidPromise());
        } else if (!(webSocketFrame instanceof PongWebSocketFrame)) {
            if (webSocketFrame instanceof CloseWebSocketFrame) {
                channel.close();
            } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
                // empty if block
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(throwable);
        } else {
            LogHelper.error(throwable);
        }
        channelHandlerContext.close();
    }
}

