/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pro.gravit.repackage.io.netty.buffer.AbstractByteBuf;
import pro.gravit.repackage.io.netty.buffer.AbstractReferenceCountedByteBuf;
import pro.gravit.repackage.io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.CompositeByteBuf$1;
import pro.gravit.repackage.io.netty.buffer.CompositeByteBuf$2;
import pro.gravit.repackage.io.netty.buffer.CompositeByteBuf$ByteWrapper;
import pro.gravit.repackage.io.netty.buffer.CompositeByteBuf$Component;
import pro.gravit.repackage.io.netty.buffer.CompositeByteBuf$CompositeByteBufIterator;
import pro.gravit.repackage.io.netty.buffer.DuplicatedByteBuf;
import pro.gravit.repackage.io.netty.buffer.PooledDuplicatedByteBuf;
import pro.gravit.repackage.io.netty.buffer.PooledSlicedByteBuf;
import pro.gravit.repackage.io.netty.buffer.SwappedByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.buffer.WrappedByteBuf;
import pro.gravit.repackage.io.netty.buffer.WrappedCompositeByteBuf;
import pro.gravit.repackage.io.netty.util.ByteProcessor;
import pro.gravit.repackage.io.netty.util.IllegalReferenceCountException;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.RecyclableArrayList;

public class CompositeByteBuf
extends AbstractReferenceCountedByteBuf
implements Iterable<ByteBuf> {
    private static final ByteBuffer EMPTY_NIO_BUFFER = Unpooled.EMPTY_BUFFER.nioBuffer();
    private static final Iterator<ByteBuf> EMPTY_ITERATOR = Collections.emptyList().iterator();
    private final ByteBufAllocator alloc;
    private final boolean direct;
    private final int maxNumComponents;
    private int componentCount;
    private CompositeByteBuf$Component[] components;
    private boolean freed;
    static final CompositeByteBuf$ByteWrapper<byte[]> BYTE_ARRAY_WRAPPER = new CompositeByteBuf$1();
    static final CompositeByteBuf$ByteWrapper<ByteBuffer> BYTE_BUFFER_WRAPPER = new CompositeByteBuf$2();
    private CompositeByteBuf$Component lastAccessed;

    private CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n, int n2) {
        super(Integer.MAX_VALUE);
        this.alloc = ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        if (n < 1) {
            throw new IllegalArgumentException("maxNumComponents: " + n + " (expected: >= 1)");
        }
        this.direct = bl;
        this.maxNumComponents = n;
        this.components = CompositeByteBuf.newCompArray(n2, n);
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n) {
        this(byteBufAllocator, bl, n, 0);
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n, ByteBuf ... byteBufArray) {
        this(byteBufAllocator, bl, n, byteBufArray, 0);
    }

    CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n, ByteBuf[] byteBufArray, int n2) {
        this(byteBufAllocator, bl, n, byteBufArray.length - n2);
        this.addComponents0(false, 0, byteBufArray, n2);
        this.consolidateIfNeeded();
        this.setIndex0(0, this.capacity());
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n, Iterable<ByteBuf> iterable) {
        this(byteBufAllocator, bl, n, iterable instanceof Collection ? ((Collection)iterable).size() : 0);
        this.addComponents(false, 0, iterable);
        this.setIndex(0, this.capacity());
    }

    <T> CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n, CompositeByteBuf$ByteWrapper<T> compositeByteBuf$ByteWrapper, T[] TArray, int n2) {
        this(byteBufAllocator, bl, n, TArray.length - n2);
        this.addComponents0(false, 0, compositeByteBuf$ByteWrapper, TArray, n2);
        this.consolidateIfNeeded();
        this.setIndex(0, this.capacity());
    }

    private static CompositeByteBuf$Component[] newCompArray(int n, int n2) {
        int n3 = Math.min(16, n2);
        return new CompositeByteBuf$Component[Math.max(n, n3)];
    }

    CompositeByteBuf(ByteBufAllocator byteBufAllocator) {
        super(Integer.MAX_VALUE);
        this.alloc = byteBufAllocator;
        this.direct = false;
        this.maxNumComponents = 0;
        this.components = null;
    }

    public CompositeByteBuf addComponent(ByteBuf byteBuf) {
        return this.addComponent(false, byteBuf);
    }

    public CompositeByteBuf addComponents(ByteBuf ... byteBufArray) {
        return this.addComponents(false, byteBufArray);
    }

    public CompositeByteBuf addComponents(Iterable<ByteBuf> iterable) {
        return this.addComponents(false, iterable);
    }

    public CompositeByteBuf addComponent(int n, ByteBuf byteBuf) {
        return this.addComponent(false, n, byteBuf);
    }

    public CompositeByteBuf addComponent(boolean bl, ByteBuf byteBuf) {
        return this.addComponent(bl, this.componentCount, byteBuf);
    }

    public CompositeByteBuf addComponents(boolean bl, ByteBuf ... byteBufArray) {
        ObjectUtil.checkNotNull(byteBufArray, "buffers");
        this.addComponents0(bl, this.componentCount, byteBufArray, 0);
        this.consolidateIfNeeded();
        return this;
    }

    public CompositeByteBuf addComponents(boolean bl, Iterable<ByteBuf> iterable) {
        return this.addComponents(bl, this.componentCount, iterable);
    }

    public CompositeByteBuf addComponent(boolean bl, int n, ByteBuf byteBuf) {
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        this.addComponent0(bl, n, byteBuf);
        this.consolidateIfNeeded();
        return this;
    }

    private static void checkForOverflow(int n, int n2) {
        if (n + n2 < 0) {
            throw new IllegalArgumentException("Can't increase by " + n2 + " as capacity(" + n + ") would overflow " + Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addComponent0(boolean bl, int n, ByteBuf byteBuf) {
        assert (byteBuf != null);
        boolean bl2 = false;
        try {
            this.checkComponentIndex(n);
            CompositeByteBuf$Component compositeByteBuf$Component = this.newComponent(CompositeByteBuf.ensureAccessible(byteBuf), 0);
            int n2 = compositeByteBuf$Component.length();
            CompositeByteBuf.checkForOverflow(this.capacity(), n2);
            this.addComp(n, compositeByteBuf$Component);
            bl2 = true;
            if (n2 > 0 && n < this.componentCount - 1) {
                this.updateComponentOffsets(n);
            } else if (n > 0) {
                compositeByteBuf$Component.reposition(this.components[n - 1].endOffset);
            }
            if (bl) {
                this.writerIndex += n2;
            }
            int n3 = n;
            return n3;
        }
        finally {
            if (!bl2) {
                byteBuf.release();
            }
        }
    }

    private static ByteBuf ensureAccessible(ByteBuf byteBuf) {
        if (checkAccessible && !byteBuf.isAccessible()) {
            throw new IllegalReferenceCountException(0);
        }
        return byteBuf;
    }

    private CompositeByteBuf$Component newComponent(ByteBuf byteBuf, int n) {
        int n2 = byteBuf.readerIndex();
        int n3 = byteBuf.readableBytes();
        ByteBuf byteBuf2 = byteBuf;
        int n4 = n2;
        while (byteBuf2 instanceof WrappedByteBuf || byteBuf2 instanceof SwappedByteBuf) {
            byteBuf2 = byteBuf2.unwrap();
        }
        if (byteBuf2 instanceof AbstractUnpooledSlicedByteBuf) {
            n4 += ((AbstractUnpooledSlicedByteBuf)byteBuf2).idx(0);
            byteBuf2 = byteBuf2.unwrap();
        } else if (byteBuf2 instanceof PooledSlicedByteBuf) {
            n4 += ((PooledSlicedByteBuf)byteBuf2).adjustment;
            byteBuf2 = byteBuf2.unwrap();
        } else if (byteBuf2 instanceof DuplicatedByteBuf || byteBuf2 instanceof PooledDuplicatedByteBuf) {
            byteBuf2 = byteBuf2.unwrap();
        }
        ByteBuf byteBuf3 = byteBuf.capacity() == n3 ? byteBuf : null;
        return new CompositeByteBuf$Component(byteBuf.order(ByteOrder.BIG_ENDIAN), n2, byteBuf2.order(ByteOrder.BIG_ENDIAN), n4, n, n3, byteBuf3);
    }

    public CompositeByteBuf addComponents(int n, ByteBuf ... byteBufArray) {
        ObjectUtil.checkNotNull(byteBufArray, "buffers");
        this.addComponents0(false, n, byteBufArray, 0);
        this.consolidateIfNeeded();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeByteBuf addComponents0(boolean bl, int n, ByteBuf[] byteBufArray, int n2) {
        ByteBuf byteBuf;
        int n3;
        int n4 = byteBufArray.length;
        int n5 = n4 - n2;
        int n6 = 0;
        int n7 = this.capacity();
        for (n3 = n2; n3 < byteBufArray.length && (byteBuf = byteBufArray[n3]) != null; ++n3) {
            CompositeByteBuf.checkForOverflow(n7, n6 += byteBuf.readableBytes());
        }
        n3 = Integer.MAX_VALUE;
        try {
            ByteBuf byteBuf2;
            this.checkComponentIndex(n);
            this.shiftComps(n, n5);
            int n8 = n > 0 ? this.components[n - 1].endOffset : 0;
            n3 = n;
            while (n2 < n4 && (byteBuf2 = byteBufArray[n2]) != null) {
                CompositeByteBuf$Component compositeByteBuf$Component;
                this.components[n3] = compositeByteBuf$Component = this.newComponent(CompositeByteBuf.ensureAccessible(byteBuf2), n8);
                n8 = compositeByteBuf$Component.endOffset;
                ++n2;
                ++n3;
            }
            byteBuf2 = this;
            return byteBuf2;
        }
        finally {
            if (n3 < this.componentCount) {
                if (n3 < n + n5) {
                    this.removeCompRange(n3, n + n5);
                    while (n2 < n4) {
                        ReferenceCountUtil.safeRelease(byteBufArray[n2]);
                        ++n2;
                    }
                }
                this.updateComponentOffsets(n3);
            }
            if (bl && n3 > n && n3 <= this.componentCount) {
                this.writerIndex += this.components[n3 - 1].endOffset - this.components[n].offset;
            }
        }
    }

    private <T> int addComponents0(boolean bl, int n, CompositeByteBuf$ByteWrapper<T> compositeByteBuf$ByteWrapper, T[] TArray, int n2) {
        T t;
        this.checkComponentIndex(n);
        int n3 = TArray.length;
        for (int i = n2; i < n3 && (t = TArray[i]) != null; ++i) {
            int n4;
            if (compositeByteBuf$ByteWrapper.isEmpty(t) || (n = this.addComponent0(bl, n, compositeByteBuf$ByteWrapper.wrap(t)) + 1) <= (n4 = this.componentCount)) continue;
            n = n4;
        }
        return n;
    }

    public CompositeByteBuf addComponents(int n, Iterable<ByteBuf> iterable) {
        return this.addComponents(false, n, iterable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeByteBuf addFlattenedComponents(boolean bl, ByteBuf byteBuf) {
        int n;
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        int n2 = byteBuf.readerIndex();
        int n3 = byteBuf.writerIndex();
        if (n2 == n3) {
            byteBuf.release();
            return this;
        }
        if (!(byteBuf instanceof CompositeByteBuf)) {
            this.addComponent0(bl, this.componentCount, byteBuf);
            this.consolidateIfNeeded();
            return this;
        }
        CompositeByteBuf compositeByteBuf = byteBuf instanceof WrappedCompositeByteBuf ? (CompositeByteBuf)byteBuf.unwrap() : (CompositeByteBuf)byteBuf;
        compositeByteBuf.checkIndex(n2, n3 - n2);
        CompositeByteBuf$Component[] compositeByteBuf$ComponentArray = compositeByteBuf.components;
        int n4 = this.componentCount;
        int n5 = this.writerIndex;
        try {
            int n6 = compositeByteBuf.toComponentIndex0(n2);
            n = this.capacity();
            while (true) {
                CompositeByteBuf$Component compositeByteBuf$Component = compositeByteBuf$ComponentArray[n6];
                int n7 = compositeByteBuf$Component.offset;
                int n8 = Math.max(n2, n7);
                int n9 = Math.min(n3, compositeByteBuf$Component.endOffset);
                int n10 = n9 - n8;
                if (n10 > 0) {
                    this.addComp(this.componentCount, new CompositeByteBuf$Component(compositeByteBuf$Component.srcBuf.retain(), compositeByteBuf$Component.srcIdx(n8), compositeByteBuf$Component.buf, compositeByteBuf$Component.idx(n8), n, n10, null));
                }
                if (n3 == n9) break;
                n += n10;
                ++n6;
            }
            if (bl) {
                this.writerIndex = n5 + (n3 - n2);
            }
            this.consolidateIfNeeded();
            byteBuf.release();
            byteBuf = null;
            CompositeByteBuf compositeByteBuf2 = this;
            return compositeByteBuf2;
        }
        finally {
            if (byteBuf != null) {
                if (bl) {
                    this.writerIndex = n5;
                }
                for (n = this.componentCount - 1; n >= n4; --n) {
                    this.components[n].free();
                    this.removeComp(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeByteBuf addComponents(boolean bl, int n, Iterable<ByteBuf> iterable) {
        if (iterable instanceof ByteBuf) {
            return this.addComponent(bl, n, (ByteBuf)((Object)iterable));
        }
        ObjectUtil.checkNotNull(iterable, "buffers");
        Iterator<ByteBuf> iterator = iterable.iterator();
        try {
            this.checkComponentIndex(n);
            while (iterator.hasNext()) {
                ByteBuf byteBuf = iterator.next();
                if (byteBuf == null) {
                    break;
                }
                n = this.addComponent0(bl, n, byteBuf) + 1;
                n = Math.min(n, this.componentCount);
            }
        }
        finally {
            while (iterator.hasNext()) {
                ReferenceCountUtil.safeRelease(iterator.next());
            }
        }
        this.consolidateIfNeeded();
        return this;
    }

    private void consolidateIfNeeded() {
        int n = this.componentCount;
        if (n > this.maxNumComponents) {
            this.consolidate0(0, n);
        }
    }

    private void checkComponentIndex(int n) {
        this.ensureAccessible();
        if (n < 0 || n > this.componentCount) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d (expected: >= 0 && <= numComponents(%d))", n, this.componentCount));
        }
    }

    private void checkComponentIndex(int n, int n2) {
        this.ensureAccessible();
        if (n < 0 || n + n2 > this.componentCount) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d, numComponents: %d (expected: cIndex >= 0 && cIndex + numComponents <= totalNumComponents(%d))", n, n2, this.componentCount));
        }
    }

    private void updateComponentOffsets(int n) {
        int n2;
        int n3 = this.componentCount;
        if (n3 <= n) {
            return;
        }
        int n4 = n2 = n > 0 ? this.components[n - 1].endOffset : 0;
        while (n < n3) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n];
            compositeByteBuf$Component.reposition(n2);
            n2 = compositeByteBuf$Component.endOffset;
            ++n;
        }
    }

    public CompositeByteBuf removeComponent(int n) {
        this.checkComponentIndex(n);
        CompositeByteBuf$Component compositeByteBuf$Component = this.components[n];
        if (this.lastAccessed == compositeByteBuf$Component) {
            this.lastAccessed = null;
        }
        compositeByteBuf$Component.free();
        this.removeComp(n);
        if (compositeByteBuf$Component.length() > 0) {
            this.updateComponentOffsets(n);
        }
        return this;
    }

    public CompositeByteBuf removeComponents(int n, int n2) {
        this.checkComponentIndex(n, n2);
        if (n2 == 0) {
            return this;
        }
        int n3 = n + n2;
        boolean bl = false;
        for (int i = n; i < n3; ++i) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[i];
            if (compositeByteBuf$Component.length() > 0) {
                bl = true;
            }
            if (this.lastAccessed == compositeByteBuf$Component) {
                this.lastAccessed = null;
            }
            compositeByteBuf$Component.free();
        }
        this.removeCompRange(n, n3);
        if (bl) {
            this.updateComponentOffsets(n);
        }
        return this;
    }

    @Override
    public Iterator<ByteBuf> iterator() {
        this.ensureAccessible();
        return this.componentCount == 0 ? EMPTY_ITERATOR : new CompositeByteBuf$CompositeByteBufIterator(this);
    }

    @Override
    protected int forEachByteAsc0(int n, int n2, ByteProcessor byteProcessor) {
        if (n2 <= n) {
            return -1;
        }
        int n3 = this.toComponentIndex0(n);
        int n4 = n2 - n;
        while (n4 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n3];
            if (compositeByteBuf$Component.offset != compositeByteBuf$Component.endOffset) {
                int n5;
                ByteBuf byteBuf = compositeByteBuf$Component.buf;
                int n6 = compositeByteBuf$Component.idx(n);
                int n7 = Math.min(n4, compositeByteBuf$Component.endOffset - n);
                int n8 = n5 = byteBuf instanceof AbstractByteBuf ? ((AbstractByteBuf)byteBuf).forEachByteAsc0(n6, n6 + n7, byteProcessor) : byteBuf.forEachByte(n6, n7, byteProcessor);
                if (n5 != -1) {
                    return n5 - compositeByteBuf$Component.adjustment;
                }
                n += n7;
                n4 -= n7;
            }
            ++n3;
        }
        return -1;
    }

    @Override
    protected int forEachByteDesc0(int n, int n2, ByteProcessor byteProcessor) {
        if (n2 > n) {
            return -1;
        }
        int n3 = this.toComponentIndex0(n);
        int n4 = 1 + n - n2;
        while (n4 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n3];
            if (compositeByteBuf$Component.offset != compositeByteBuf$Component.endOffset) {
                int n5;
                ByteBuf byteBuf = compositeByteBuf$Component.buf;
                int n6 = compositeByteBuf$Component.idx(n4 + n2);
                int n7 = Math.min(n4, n6);
                int n8 = n6 - n7;
                int n9 = n5 = byteBuf instanceof AbstractByteBuf ? ((AbstractByteBuf)byteBuf).forEachByteDesc0(n6 - 1, n8, byteProcessor) : byteBuf.forEachByteDesc(n8, n7, byteProcessor);
                if (n5 != -1) {
                    return n5 - compositeByteBuf$Component.adjustment;
                }
                n4 -= n7;
            }
            --n3;
        }
        return -1;
    }

    public List<ByteBuf> decompose(int n, int n2) {
        ByteBuf byteBuf;
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return Collections.emptyList();
        }
        int n3 = this.toComponentIndex0(n);
        int n4 = n2;
        CompositeByteBuf$Component compositeByteBuf$Component = this.components[n3];
        if ((n4 -= (byteBuf = compositeByteBuf$Component.srcBuf.slice(compositeByteBuf$Component.srcIdx(n), Math.min(compositeByteBuf$Component.endOffset - n, n4))).readableBytes()) == 0) {
            return Collections.singletonList(byteBuf);
        }
        ArrayList<ByteBuf> arrayList = new ArrayList<ByteBuf>(this.componentCount - n3);
        arrayList.add(byteBuf);
        do {
            CompositeByteBuf$Component compositeByteBuf$Component2 = this.components[++n3];
            byteBuf = compositeByteBuf$Component2.srcBuf.slice(compositeByteBuf$Component2.srcIdx(compositeByteBuf$Component2.offset), Math.min(compositeByteBuf$Component2.length(), n4));
            arrayList.add(byteBuf);
        } while ((n4 -= byteBuf.readableBytes()) > 0);
        return arrayList;
    }

    @Override
    public boolean isDirect() {
        int n = this.componentCount;
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.components[i].buf.isDirect()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasArray() {
        switch (this.componentCount) {
            case 0: {
                return true;
            }
            case 1: {
                return this.components[0].buf.hasArray();
            }
        }
        return false;
    }

    @Override
    public byte[] array() {
        switch (this.componentCount) {
            case 0: {
                return EmptyArrays.EMPTY_BYTES;
            }
            case 1: {
                return this.components[0].buf.array();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        switch (this.componentCount) {
            case 0: {
                return 0;
            }
            case 1: {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components[0];
                return compositeByteBuf$Component.idx(compositeByteBuf$Component.buf.arrayOffset());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.hasMemoryAddress();
            }
            case 1: {
                return this.components[0].buf.hasMemoryAddress();
            }
        }
        return false;
    }

    @Override
    public long memoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.memoryAddress();
            }
            case 1: {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components[0];
                return compositeByteBuf$Component.buf.memoryAddress() + (long)compositeByteBuf$Component.adjustment;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int capacity() {
        int n = this.componentCount;
        return n > 0 ? this.components[n - 1].endOffset : 0;
    }

    @Override
    public CompositeByteBuf capacity(int n) {
        this.checkNewCapacity(n);
        int n2 = this.componentCount;
        int n3 = this.capacity();
        if (n > n3) {
            int n4 = n - n3;
            ByteBuf byteBuf = this.allocBuffer(n4).setIndex(0, n4);
            this.addComponent0(false, n2, byteBuf);
            if (this.componentCount >= this.maxNumComponents) {
                this.consolidateIfNeeded();
            }
        } else if (n < n3) {
            int n5;
            this.lastAccessed = null;
            int n6 = n3 - n;
            for (n5 = n2 - 1; n5 >= 0; --n5) {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components[n5];
                int n7 = compositeByteBuf$Component.length();
                if (n6 < n7) {
                    compositeByteBuf$Component.endOffset -= n6;
                    ByteBuf byteBuf = CompositeByteBuf$Component.access$100(compositeByteBuf$Component);
                    if (byteBuf == null) break;
                    CompositeByteBuf$Component.access$102(compositeByteBuf$Component, byteBuf.slice(0, compositeByteBuf$Component.length()));
                    break;
                }
                compositeByteBuf$Component.free();
                n6 -= n7;
            }
            this.removeCompRange(n5 + 1, n2);
            if (this.readerIndex() > n) {
                this.setIndex0(n, n);
            } else if (this.writerIndex > n) {
                this.writerIndex = n;
            }
        }
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public int numComponents() {
        return this.componentCount;
    }

    public int maxNumComponents() {
        return this.maxNumComponents;
    }

    public int toComponentIndex(int n) {
        this.checkIndex(n);
        return this.toComponentIndex0(n);
    }

    private int toComponentIndex0(int n) {
        int n2;
        int n3 = this.componentCount;
        if (n == 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.components[n2].endOffset <= 0) continue;
                return n2;
            }
        }
        if (n3 <= 2) {
            return n3 == 1 || n < this.components[0].endOffset ? 0 : 1;
        }
        n2 = 0;
        int n4 = n3;
        while (n2 <= n4) {
            int n5 = n2 + n4 >>> 1;
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n5];
            if (n >= compositeByteBuf$Component.endOffset) {
                n2 = n5 + 1;
                continue;
            }
            if (n < compositeByteBuf$Component.offset) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        throw new Error("should not reach here");
    }

    public int toByteIndex(int n) {
        this.checkComponentIndex(n);
        return this.components[n].offset;
    }

    @Override
    public byte getByte(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n);
        return compositeByteBuf$Component.buf.getByte(compositeByteBuf$Component.idx(n));
    }

    @Override
    protected byte _getByte(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        return compositeByteBuf$Component.buf.getByte(compositeByteBuf$Component.idx(n));
    }

    @Override
    protected short _getShort(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 2 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getShort(compositeByteBuf$Component.idx(n));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(n) & 0xFF) << 8 | this._getByte(n + 1) & 0xFF);
        }
        return (short)(this._getByte(n) & 0xFF | (this._getByte(n + 1) & 0xFF) << 8);
    }

    @Override
    protected short _getShortLE(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 2 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getShortLE(compositeByteBuf$Component.idx(n));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)(this._getByte(n) & 0xFF | (this._getByte(n + 1) & 0xFF) << 8);
        }
        return (short)((this._getByte(n) & 0xFF) << 8 | this._getByte(n + 1) & 0xFF);
    }

    @Override
    protected int _getUnsignedMedium(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 3 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getUnsignedMedium(compositeByteBuf$Component.idx(n));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n) & 0xFFFF) << 8 | this._getByte(n + 2) & 0xFF;
        }
        return this._getShort(n) & 0xFFFF | (this._getByte(n + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getUnsignedMediumLE(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 3 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getUnsignedMediumLE(compositeByteBuf$Component.idx(n));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n) & 0xFFFF | (this._getByte(n + 2) & 0xFF) << 16;
        }
        return (this._getShortLE(n) & 0xFFFF) << 8 | this._getByte(n + 2) & 0xFF;
    }

    @Override
    protected int _getInt(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 4 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getInt(compositeByteBuf$Component.idx(n));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n) & 0xFFFF) << 16 | this._getShort(n + 2) & 0xFFFF;
        }
        return this._getShort(n) & 0xFFFF | (this._getShort(n + 2) & 0xFFFF) << 16;
    }

    @Override
    protected int _getIntLE(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 4 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getIntLE(compositeByteBuf$Component.idx(n));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n) & 0xFFFF | (this._getShortLE(n + 2) & 0xFFFF) << 16;
        }
        return (this._getShortLE(n) & 0xFFFF) << 16 | this._getShortLE(n + 2) & 0xFFFF;
    }

    @Override
    protected long _getLong(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 8 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getLong(compositeByteBuf$Component.idx(n));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(n) & 0xFFFFFFFFL) << 32 | (long)this._getInt(n + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(n) & 0xFFFFFFFFL | ((long)this._getInt(n + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    protected long _getLongLE(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 8 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getLongLE(compositeByteBuf$Component.idx(n));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (long)this._getIntLE(n) & 0xFFFFFFFFL | ((long)this._getIntLE(n + 4) & 0xFFFFFFFFL) << 32;
        }
        return ((long)this._getIntLE(n) & 0xFFFFFFFFL) << 32 | (long)this._getIntLE(n + 4) & 0xFFFFFFFFL;
    }

    @Override
    public CompositeByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkDstIndex(n, n3, n2, byArray.length);
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        while (n3 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n4];
            int n5 = Math.min(n3, compositeByteBuf$Component.endOffset - n);
            compositeByteBuf$Component.buf.getBytes(compositeByteBuf$Component.idx(n), byArray, n2, n5);
            n += n5;
            n2 += n5;
            n3 -= n5;
            ++n4;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.remaining();
        this.checkIndex(n, n3);
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        try {
            while (n3 > 0) {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components[n4];
                int n5 = Math.min(n3, compositeByteBuf$Component.endOffset - n);
                byteBuffer.limit(byteBuffer.position() + n5);
                compositeByteBuf$Component.buf.getBytes(compositeByteBuf$Component.idx(n), byteBuffer);
                n += n5;
                n3 -= n5;
                ++n4;
            }
        }
        finally {
            byteBuffer.limit(n2);
        }
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkDstIndex(n, n3, n2, byteBuf.capacity());
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        while (n3 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n4];
            int n5 = Math.min(n3, compositeByteBuf$Component.endOffset - n);
            compositeByteBuf$Component.buf.getBytes(compositeByteBuf$Component.idx(n), byteBuf, n2, n5);
            n += n5;
            n2 += n5;
            n3 -= n5;
            ++n4;
        }
        return this;
    }

    @Override
    public int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        int n3 = this.nioBufferCount();
        if (n3 == 1) {
            return gatheringByteChannel.write(this.internalNioBuffer(n, n2));
        }
        long l = gatheringByteChannel.write(this.nioBuffers(n, n2));
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        int n3 = this.nioBufferCount();
        if (n3 == 1) {
            return fileChannel.write(this.internalNioBuffer(n, n2), l);
        }
        long l2 = 0L;
        for (ByteBuffer byteBuffer : this.nioBuffers(n, n2)) {
            l2 += (long)fileChannel.write(byteBuffer, l + l2);
        }
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public CompositeByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return this;
        }
        int n3 = this.toComponentIndex0(n);
        while (n2 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n3];
            int n4 = Math.min(n2, compositeByteBuf$Component.endOffset - n);
            compositeByteBuf$Component.buf.getBytes(compositeByteBuf$Component.idx(n), outputStream, n4);
            n += n4;
            n2 -= n4;
            ++n3;
        }
        return this;
    }

    @Override
    public CompositeByteBuf setByte(int n, int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n);
        compositeByteBuf$Component.buf.setByte(compositeByteBuf$Component.idx(n), n2);
        return this;
    }

    @Override
    protected void _setByte(int n, int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        compositeByteBuf$Component.buf.setByte(compositeByteBuf$Component.idx(n), n2);
    }

    @Override
    public CompositeByteBuf setShort(int n, int n2) {
        this.checkIndex(n, 2);
        this._setShort(n, n2);
        return this;
    }

    @Override
    protected void _setShort(int n, int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 2 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setShort(compositeByteBuf$Component.idx(n), n2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(n, (byte)(n2 >>> 8));
            this._setByte(n + 1, (byte)n2);
        } else {
            this._setByte(n, (byte)n2);
            this._setByte(n + 1, (byte)(n2 >>> 8));
        }
    }

    @Override
    protected void _setShortLE(int n, int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 2 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setShortLE(compositeByteBuf$Component.idx(n), n2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(n, (byte)n2);
            this._setByte(n + 1, (byte)(n2 >>> 8));
        } else {
            this._setByte(n, (byte)(n2 >>> 8));
            this._setByte(n + 1, (byte)n2);
        }
    }

    @Override
    public CompositeByteBuf setMedium(int n, int n2) {
        this.checkIndex(n, 3);
        this._setMedium(n, n2);
        return this;
    }

    @Override
    protected void _setMedium(int n, int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 3 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setMedium(compositeByteBuf$Component.idx(n), n2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(n, (short)(n2 >> 8));
            this._setByte(n + 2, (byte)n2);
        } else {
            this._setShort(n, (short)n2);
            this._setByte(n + 2, (byte)(n2 >>> 16));
        }
    }

    @Override
    protected void _setMediumLE(int n, int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 3 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setMediumLE(compositeByteBuf$Component.idx(n), n2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShortLE(n, (short)n2);
            this._setByte(n + 2, (byte)(n2 >>> 16));
        } else {
            this._setShortLE(n, (short)(n2 >> 8));
            this._setByte(n + 2, (byte)n2);
        }
    }

    @Override
    public CompositeByteBuf setInt(int n, int n2) {
        this.checkIndex(n, 4);
        this._setInt(n, n2);
        return this;
    }

    @Override
    protected void _setInt(int n, int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 4 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setInt(compositeByteBuf$Component.idx(n), n2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(n, (short)(n2 >>> 16));
            this._setShort(n + 2, (short)n2);
        } else {
            this._setShort(n, (short)n2);
            this._setShort(n + 2, (short)(n2 >>> 16));
        }
    }

    @Override
    protected void _setIntLE(int n, int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 4 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setIntLE(compositeByteBuf$Component.idx(n), n2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShortLE(n, (short)n2);
            this._setShortLE(n + 2, (short)(n2 >>> 16));
        } else {
            this._setShortLE(n, (short)(n2 >>> 16));
            this._setShortLE(n + 2, (short)n2);
        }
    }

    @Override
    public CompositeByteBuf setLong(int n, long l) {
        this.checkIndex(n, 8);
        this._setLong(n, l);
        return this;
    }

    @Override
    protected void _setLong(int n, long l) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 8 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setLong(compositeByteBuf$Component.idx(n), l);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setInt(n, (int)(l >>> 32));
            this._setInt(n + 4, (int)l);
        } else {
            this._setInt(n, (int)l);
            this._setInt(n + 4, (int)(l >>> 32));
        }
    }

    @Override
    protected void _setLongLE(int n, long l) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent0(n);
        if (n + 8 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setLongLE(compositeByteBuf$Component.idx(n), l);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setIntLE(n, (int)l);
            this._setIntLE(n + 4, (int)(l >>> 32));
        } else {
            this._setIntLE(n, (int)(l >>> 32));
            this._setIntLE(n + 4, (int)l);
        }
    }

    @Override
    public CompositeByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkSrcIndex(n, n3, n2, byArray.length);
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        while (n3 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n4];
            int n5 = Math.min(n3, compositeByteBuf$Component.endOffset - n);
            compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n), byArray, n2, n5);
            n += n5;
            n2 += n5;
            n3 -= n5;
            ++n4;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.remaining();
        this.checkIndex(n, n3);
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        try {
            while (n3 > 0) {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components[n4];
                int n5 = Math.min(n3, compositeByteBuf$Component.endOffset - n);
                byteBuffer.limit(byteBuffer.position() + n5);
                compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n), byteBuffer);
                n += n5;
                n3 -= n5;
                ++n4;
            }
        }
        finally {
            byteBuffer.limit(n2);
        }
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkSrcIndex(n, n3, n2, byteBuf.capacity());
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex0(n);
        while (n3 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n4];
            int n5 = Math.min(n3, compositeByteBuf$Component.endOffset - n);
            compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n), byteBuf, n2, n5);
            n += n5;
            n2 += n5;
            n3 -= n5;
            ++n4;
        }
        return this;
    }

    @Override
    public int setBytes(int n, InputStream inputStream, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return inputStream.read(EmptyArrays.EMPTY_BYTES);
        }
        int n3 = this.toComponentIndex0(n);
        int n4 = 0;
        do {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n3];
            int n5 = Math.min(n2, compositeByteBuf$Component.endOffset - n);
            if (n5 == 0) {
                ++n3;
                continue;
            }
            int n6 = compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n), inputStream, n5);
            if (n6 < 0) {
                if (n4 != 0) break;
                return -1;
            }
            n += n6;
            n2 -= n6;
            n4 += n6;
            if (n6 != n5) continue;
            ++n3;
        } while (n2 > 0);
        return n4;
    }

    @Override
    public int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return scatteringByteChannel.read(EMPTY_NIO_BUFFER);
        }
        int n3 = this.toComponentIndex0(n);
        int n4 = 0;
        do {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n3];
            int n5 = Math.min(n2, compositeByteBuf$Component.endOffset - n);
            if (n5 == 0) {
                ++n3;
                continue;
            }
            int n6 = compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n), scatteringByteChannel, n5);
            if (n6 == 0) break;
            if (n6 < 0) {
                if (n4 != 0) break;
                return -1;
            }
            n += n6;
            n2 -= n6;
            n4 += n6;
            if (n6 != n5) continue;
            ++n3;
        } while (n2 > 0);
        return n4;
    }

    @Override
    public int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return fileChannel.read(EMPTY_NIO_BUFFER, l);
        }
        int n3 = this.toComponentIndex0(n);
        int n4 = 0;
        do {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n3];
            int n5 = Math.min(n2, compositeByteBuf$Component.endOffset - n);
            if (n5 == 0) {
                ++n3;
                continue;
            }
            int n6 = compositeByteBuf$Component.buf.setBytes(compositeByteBuf$Component.idx(n), fileChannel, l + (long)n4, n5);
            if (n6 == 0) break;
            if (n6 < 0) {
                if (n4 != 0) break;
                return -1;
            }
            n += n6;
            n2 -= n6;
            n4 += n6;
            if (n6 != n5) continue;
            ++n3;
        } while (n2 > 0);
        return n4;
    }

    @Override
    public ByteBuf copy(int n, int n2) {
        this.checkIndex(n, n2);
        ByteBuf byteBuf = this.allocBuffer(n2);
        if (n2 != 0) {
            this.copyTo(n, n2, this.toComponentIndex0(n), byteBuf);
        }
        return byteBuf;
    }

    private void copyTo(int n, int n2, int n3, ByteBuf byteBuf) {
        int n4 = 0;
        int n5 = n3;
        while (n2 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n5];
            int n6 = Math.min(n2, compositeByteBuf$Component.endOffset - n);
            compositeByteBuf$Component.buf.getBytes(compositeByteBuf$Component.idx(n), byteBuf, n4, n6);
            n += n6;
            n4 += n6;
            n2 -= n6;
            ++n5;
        }
        byteBuf.writerIndex(byteBuf.capacity());
    }

    public ByteBuf component(int n) {
        this.checkComponentIndex(n);
        return this.components[n].duplicate();
    }

    public ByteBuf componentAtOffset(int n) {
        return this.findComponent(n).duplicate();
    }

    public ByteBuf internalComponent(int n) {
        this.checkComponentIndex(n);
        return this.components[n].slice();
    }

    public ByteBuf internalComponentAtOffset(int n) {
        return this.findComponent(n).slice();
    }

    private CompositeByteBuf$Component findComponent(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.lastAccessed;
        if (compositeByteBuf$Component != null && n >= compositeByteBuf$Component.offset && n < compositeByteBuf$Component.endOffset) {
            this.ensureAccessible();
            return compositeByteBuf$Component;
        }
        this.checkIndex(n);
        return this.findIt(n);
    }

    private CompositeByteBuf$Component findComponent0(int n) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.lastAccessed;
        if (compositeByteBuf$Component != null && n >= compositeByteBuf$Component.offset && n < compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component;
        }
        return this.findIt(n);
    }

    private CompositeByteBuf$Component findIt(int n) {
        int n2 = 0;
        int n3 = this.componentCount;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            CompositeByteBuf$Component compositeByteBuf$Component = this.components[n4];
            if (compositeByteBuf$Component == null) {
                throw new IllegalStateException("No component found for offset. Composite buffer layout might be outdated, e.g. from a discardReadBytes call.");
            }
            if (n >= compositeByteBuf$Component.endOffset) {
                n2 = n4 + 1;
                continue;
            }
            if (n < compositeByteBuf$Component.offset) {
                n3 = n4 - 1;
                continue;
            }
            this.lastAccessed = compositeByteBuf$Component;
            return compositeByteBuf$Component;
        }
        throw new Error("should not reach here");
    }

    @Override
    public int nioBufferCount() {
        int n = this.componentCount;
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return this.components[0].buf.nioBufferCount();
            }
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.components[i].buf.nioBufferCount();
        }
        return n2;
    }

    @Override
    public ByteBuffer internalNioBuffer(int n, int n2) {
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                return this.components[0].internalNioBuffer(n, n2);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer nioBuffer(int n, int n2) {
        Comparable<ByteBuf> comparable;
        ByteBuffer[] byteBufferArray;
        this.checkIndex(n, n2);
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                byteBufferArray = this.components[0];
                comparable = byteBufferArray.buf;
                if (((ByteBuf)comparable).nioBufferCount() != 1) break;
                return ((ByteBuf)comparable).nioBuffer(byteBufferArray.idx(n), n2);
            }
        }
        byteBufferArray = this.nioBuffers(n, n2);
        if (byteBufferArray.length == 1) {
            return byteBufferArray[0];
        }
        comparable = ByteBuffer.allocate(n2).order(this.order());
        for (ByteBuffer byteBuffer : byteBufferArray) {
            ((ByteBuffer)comparable).put(byteBuffer);
        }
        ((ByteBuffer)comparable).flip();
        return comparable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer[] nioBuffers(int n, int n2) {
        this.checkIndex(n, n2);
        if (n2 == 0) {
            return new ByteBuffer[]{EMPTY_NIO_BUFFER};
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance(this.componentCount);
        try {
            ByteBuffer[] byteBufferArray;
            int n3 = this.toComponentIndex0(n);
            while (n2 > 0) {
                byteBufferArray = this.components[n3];
                ByteBuf byteBuf = byteBufferArray.buf;
                int n4 = Math.min(n2, byteBufferArray.endOffset - n);
                switch (byteBuf.nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        recyclableArrayList.add(byteBuf.nioBuffer(byteBufferArray.idx(n), n4));
                        break;
                    }
                    default: {
                        Collections.addAll(recyclableArrayList, byteBuf.nioBuffers(byteBufferArray.idx(n), n4));
                    }
                }
                n += n4;
                n2 -= n4;
                ++n3;
            }
            byteBufferArray = recyclableArrayList.toArray(EmptyArrays.EMPTY_BYTE_BUFFERS);
            return byteBufferArray;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    public CompositeByteBuf consolidate() {
        this.ensureAccessible();
        this.consolidate0(0, this.componentCount);
        return this;
    }

    public CompositeByteBuf consolidate(int n, int n2) {
        this.checkComponentIndex(n, n2);
        this.consolidate0(n, n2);
        return this;
    }

    private void consolidate0(int n, int n2) {
        if (n2 <= 1) {
            return;
        }
        int n3 = n + n2;
        int n4 = n != 0 ? this.components[n].offset : 0;
        int n5 = this.components[n3 - 1].endOffset - n4;
        ByteBuf byteBuf = this.allocBuffer(n5);
        for (int i = n; i < n3; ++i) {
            this.components[i].transferTo(byteBuf);
        }
        this.lastAccessed = null;
        this.removeCompRange(n + 1, n3);
        this.components[n] = this.newComponent(byteBuf, 0);
        if (n != 0 || n2 != this.componentCount) {
            this.updateComponentOffsets(n);
        }
    }

    public CompositeByteBuf discardReadComponents() {
        int n;
        this.ensureAccessible();
        int n2 = this.readerIndex();
        if (n2 == 0) {
            return this;
        }
        int n3 = this.writerIndex();
        if (n2 == n3 && n3 == this.capacity()) {
            int n4 = this.componentCount;
            for (int i = 0; i < n4; ++i) {
                this.components[i].free();
            }
            this.lastAccessed = null;
            this.clearComps();
            this.setIndex(0, 0);
            this.adjustMarkers(n2);
            return this;
        }
        CompositeByteBuf$Component compositeByteBuf$Component = null;
        int n5 = this.componentCount;
        for (n = 0; n < n5; ++n) {
            compositeByteBuf$Component = this.components[n];
            if (compositeByteBuf$Component.endOffset > n2) break;
            compositeByteBuf$Component.free();
        }
        if (n == 0) {
            return this;
        }
        CompositeByteBuf$Component compositeByteBuf$Component2 = this.lastAccessed;
        if (compositeByteBuf$Component2 != null && compositeByteBuf$Component2.endOffset <= n2) {
            this.lastAccessed = null;
        }
        this.removeCompRange(0, n);
        int n6 = compositeByteBuf$Component.offset;
        this.updateComponentOffsets(0);
        this.setIndex(n2 - n6, n3 - n6);
        this.adjustMarkers(n6);
        return this;
    }

    @Override
    public CompositeByteBuf discardReadBytes() {
        CompositeByteBuf$Component compositeByteBuf$Component;
        int n;
        this.ensureAccessible();
        int n2 = this.readerIndex();
        if (n2 == 0) {
            return this;
        }
        int n3 = this.writerIndex();
        if (n2 == n3 && n3 == this.capacity()) {
            int n4 = this.componentCount;
            for (int i = 0; i < n4; ++i) {
                this.components[i].free();
            }
            this.lastAccessed = null;
            this.clearComps();
            this.setIndex(0, 0);
            this.adjustMarkers(n2);
            return this;
        }
        CompositeByteBuf$Component compositeByteBuf$Component2 = null;
        int n5 = this.componentCount;
        for (n = 0; n < n5; ++n) {
            compositeByteBuf$Component2 = this.components[n];
            if (compositeByteBuf$Component2.endOffset > n2) break;
            compositeByteBuf$Component2.free();
        }
        n5 = n2 - compositeByteBuf$Component2.offset;
        compositeByteBuf$Component2.offset = 0;
        compositeByteBuf$Component2.endOffset -= n2;
        compositeByteBuf$Component2.srcAdjustment += n2;
        compositeByteBuf$Component2.adjustment += n2;
        ByteBuf byteBuf = CompositeByteBuf$Component.access$100(compositeByteBuf$Component2);
        if (byteBuf != null) {
            CompositeByteBuf$Component.access$102(compositeByteBuf$Component2, byteBuf.slice(n5, compositeByteBuf$Component2.length()));
        }
        if ((compositeByteBuf$Component = this.lastAccessed) != null && compositeByteBuf$Component.endOffset <= n2) {
            this.lastAccessed = null;
        }
        this.removeCompRange(0, n);
        this.updateComponentOffsets(0);
        this.setIndex(0, n3 - n2);
        this.adjustMarkers(n2);
        return this;
    }

    private ByteBuf allocBuffer(int n) {
        return this.direct ? this.alloc().directBuffer(n) : this.alloc().heapBuffer(n);
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = string.substring(0, string.length() - 1);
        return string + ", components=" + this.componentCount + ')';
    }

    @Override
    public CompositeByteBuf readerIndex(int n) {
        super.readerIndex(n);
        return this;
    }

    @Override
    public CompositeByteBuf writerIndex(int n) {
        super.writerIndex(n);
        return this;
    }

    @Override
    public CompositeByteBuf setIndex(int n, int n2) {
        super.setIndex(n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf clear() {
        super.clear();
        return this;
    }

    @Override
    public CompositeByteBuf markReaderIndex() {
        super.markReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf resetReaderIndex() {
        super.resetReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf markWriterIndex() {
        super.markWriterIndex();
        return this;
    }

    @Override
    public CompositeByteBuf resetWriterIndex() {
        super.resetWriterIndex();
        return this;
    }

    @Override
    public CompositeByteBuf ensureWritable(int n) {
        super.ensureWritable(n);
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n, ByteBuf byteBuf) {
        return this.getBytes(n, byteBuf, byteBuf.writableBytes());
    }

    @Override
    public CompositeByteBuf getBytes(int n, ByteBuf byteBuf, int n2) {
        this.getBytes(n, byteBuf, byteBuf.writerIndex(), n2);
        byteBuf.writerIndex(byteBuf.writerIndex() + n2);
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n, byte[] byArray) {
        return this.getBytes(n, byArray, 0, byArray.length);
    }

    @Override
    public CompositeByteBuf setBoolean(int n, boolean bl) {
        return this.setByte(n, bl ? 1 : 0);
    }

    @Override
    public CompositeByteBuf setChar(int n, int n2) {
        return this.setShort(n, n2);
    }

    @Override
    public CompositeByteBuf setFloat(int n, float f) {
        return this.setInt(n, Float.floatToRawIntBits(f));
    }

    @Override
    public CompositeByteBuf setDouble(int n, double d) {
        return this.setLong(n, Double.doubleToRawLongBits(d));
    }

    @Override
    public CompositeByteBuf setBytes(int n, ByteBuf byteBuf) {
        super.setBytes(n, byteBuf, byteBuf.readableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n, ByteBuf byteBuf, int n2) {
        super.setBytes(n, byteBuf, n2);
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n, byte[] byArray) {
        return this.setBytes(n, byArray, 0, byArray.length);
    }

    @Override
    public CompositeByteBuf setZero(int n, int n2) {
        super.setZero(n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf) {
        super.readBytes(byteBuf, byteBuf.writableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf, int n) {
        super.readBytes(byteBuf, n);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf, int n, int n2) {
        super.readBytes(byteBuf, n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(byte[] byArray) {
        super.readBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(byte[] byArray, int n, int n2) {
        super.readBytes(byArray, n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuffer byteBuffer) {
        super.readBytes(byteBuffer);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(OutputStream outputStream, int n) {
        super.readBytes(outputStream, n);
        return this;
    }

    @Override
    public CompositeByteBuf skipBytes(int n) {
        super.skipBytes(n);
        return this;
    }

    @Override
    public CompositeByteBuf writeBoolean(boolean bl) {
        this.writeByte(bl ? 1 : 0);
        return this;
    }

    @Override
    public CompositeByteBuf writeByte(int n) {
        this.ensureWritable0(1);
        this._setByte(this.writerIndex++, n);
        return this;
    }

    @Override
    public CompositeByteBuf writeShort(int n) {
        super.writeShort(n);
        return this;
    }

    @Override
    public CompositeByteBuf writeMedium(int n) {
        super.writeMedium(n);
        return this;
    }

    @Override
    public CompositeByteBuf writeInt(int n) {
        super.writeInt(n);
        return this;
    }

    @Override
    public CompositeByteBuf writeLong(long l) {
        super.writeLong(l);
        return this;
    }

    @Override
    public CompositeByteBuf writeChar(int n) {
        super.writeShort(n);
        return this;
    }

    @Override
    public CompositeByteBuf writeFloat(float f) {
        super.writeInt(Float.floatToRawIntBits(f));
        return this;
    }

    @Override
    public CompositeByteBuf writeDouble(double d) {
        super.writeLong(Double.doubleToRawLongBits(d));
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf) {
        super.writeBytes(byteBuf, byteBuf.readableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf, int n) {
        super.writeBytes(byteBuf, n);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf, int n, int n2) {
        super.writeBytes(byteBuf, n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] byArray) {
        super.writeBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] byArray, int n, int n2) {
        super.writeBytes(byArray, n, n2);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuffer byteBuffer) {
        super.writeBytes(byteBuffer);
        return this;
    }

    @Override
    public CompositeByteBuf writeZero(int n) {
        super.writeZero(n);
        return this;
    }

    @Override
    public CompositeByteBuf retain(int n) {
        super.retain(n);
        return this;
    }

    @Override
    public CompositeByteBuf retain() {
        super.retain();
        return this;
    }

    @Override
    public CompositeByteBuf touch() {
        return this;
    }

    @Override
    public CompositeByteBuf touch(Object object) {
        return this;
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(this.readerIndex(), this.readableBytes());
    }

    @Override
    public CompositeByteBuf discardSomeReadBytes() {
        return this.discardReadComponents();
    }

    @Override
    protected void deallocate() {
        if (this.freed) {
            return;
        }
        this.freed = true;
        int n = this.componentCount;
        for (int i = 0; i < n; ++i) {
            this.components[i].free();
        }
    }

    @Override
    boolean isAccessible() {
        return !this.freed;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    private void clearComps() {
        this.removeCompRange(0, this.componentCount);
    }

    private void removeComp(int n) {
        this.removeCompRange(n, n + 1);
    }

    private void removeCompRange(int n, int n2) {
        int n3;
        if (n >= n2) {
            return;
        }
        int n4 = this.componentCount;
        assert (n >= 0 && n2 <= n4);
        if (n2 < n4) {
            System.arraycopy(this.components, n2, this.components, n, n4 - n2);
        }
        for (int i = n3 = n4 - n2 + n; i < n4; ++i) {
            this.components[i] = null;
        }
        this.componentCount = n3;
    }

    private void addComp(int n, CompositeByteBuf$Component compositeByteBuf$Component) {
        this.shiftComps(n, 1);
        this.components[n] = compositeByteBuf$Component;
    }

    private void shiftComps(int n, int n2) {
        int n3 = this.componentCount;
        int n4 = n3 + n2;
        assert (n >= 0 && n <= n3 && n2 > 0);
        if (n4 > this.components.length) {
            CompositeByteBuf$Component[] compositeByteBuf$ComponentArray;
            int n5 = Math.max(n3 + (n3 >> 1), n4);
            if (n == n3) {
                compositeByteBuf$ComponentArray = (CompositeByteBuf$Component[])Arrays.copyOf(this.components, n5, CompositeByteBuf$Component[].class);
            } else {
                compositeByteBuf$ComponentArray = new CompositeByteBuf$Component[n5];
                if (n > 0) {
                    System.arraycopy(this.components, 0, compositeByteBuf$ComponentArray, 0, n);
                }
                if (n < n3) {
                    System.arraycopy(this.components, n, compositeByteBuf$ComponentArray, n + n2, n3 - n);
                }
            }
            this.components = compositeByteBuf$ComponentArray;
        } else if (n < n3) {
            System.arraycopy(this.components, n, this.components, n + n2, n3 - n);
        }
        this.componentCount = n4;
    }

    static /* synthetic */ CompositeByteBuf$Component[] access$200(CompositeByteBuf compositeByteBuf) {
        return compositeByteBuf.components;
    }
}

