/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import pro.gravit.repackage.io.netty.buffer.PoolArena;
import pro.gravit.repackage.io.netty.buffer.PoolChunk;
import pro.gravit.repackage.io.netty.buffer.PoolChunkListMetric;
import pro.gravit.repackage.io.netty.buffer.PoolChunkMetric;
import pro.gravit.repackage.io.netty.buffer.PoolThreadCache;
import pro.gravit.repackage.io.netty.buffer.PooledByteBuf;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

final class PoolChunkList<T>
implements PoolChunkListMetric {
    private static final Iterator<PoolChunkMetric> EMPTY_METRICS = Collections.emptyList().iterator();
    private final PoolArena<T> arena;
    private final PoolChunkList<T> nextList;
    private final int minUsage;
    private final int maxUsage;
    private final int maxCapacity;
    private PoolChunk<T> head;
    private final int freeMinThreshold;
    private final int freeMaxThreshold;
    private PoolChunkList<T> prevList;

    PoolChunkList(PoolArena<T> poolArena, PoolChunkList<T> poolChunkList, int n, int n2, int n3) {
        assert (n <= n2);
        this.arena = poolArena;
        this.nextList = poolChunkList;
        this.minUsage = n;
        this.maxUsage = n2;
        this.maxCapacity = PoolChunkList.calculateMaxCapacity(n, n3);
        this.freeMinThreshold = n2 == 100 ? 0 : (int)((double)n3 * (100.0 - (double)n2 + 0.99999999) / 100.0);
        this.freeMaxThreshold = n == 100 ? 0 : (int)((double)n3 * (100.0 - (double)n + 0.99999999) / 100.0);
    }

    private static int calculateMaxCapacity(int n, int n2) {
        if ((n = PoolChunkList.minUsage0(n)) == 100) {
            return 0;
        }
        return (int)((long)n2 * (100L - (long)n) / 100L);
    }

    void prevList(PoolChunkList<T> poolChunkList) {
        assert (this.prevList == null);
        this.prevList = poolChunkList;
    }

    boolean allocate(PooledByteBuf<T> pooledByteBuf, int n, int n2, PoolThreadCache poolThreadCache) {
        int n3 = this.arena.sizeClass.sizeIdx2size(n2);
        if (n3 > this.maxCapacity) {
            return false;
        }
        PoolChunk<T> poolChunk = this.head;
        while (poolChunk != null) {
            if (poolChunk.allocate(pooledByteBuf, n, n2, poolThreadCache)) {
                if (poolChunk.freeBytes <= this.freeMinThreshold) {
                    this.remove(poolChunk);
                    this.nextList.add(poolChunk);
                }
                return true;
            }
            poolChunk = poolChunk.next;
        }
        return false;
    }

    boolean free(PoolChunk<T> poolChunk, long l, int n, ByteBuffer byteBuffer) {
        poolChunk.free(l, n, byteBuffer);
        if (poolChunk.freeBytes > this.freeMaxThreshold) {
            this.remove(poolChunk);
            return this.move0(poolChunk);
        }
        return true;
    }

    private boolean move(PoolChunk<T> poolChunk) {
        assert (poolChunk.usage() < this.maxUsage);
        if (poolChunk.freeBytes > this.freeMaxThreshold) {
            return this.move0(poolChunk);
        }
        this.add0(poolChunk);
        return true;
    }

    private boolean move0(PoolChunk<T> poolChunk) {
        if (this.prevList == null) {
            assert (poolChunk.usage() == 0);
            return false;
        }
        return super.move(poolChunk);
    }

    void add(PoolChunk<T> poolChunk) {
        if (poolChunk.freeBytes <= this.freeMinThreshold) {
            this.nextList.add(poolChunk);
            return;
        }
        this.add0(poolChunk);
    }

    void add0(PoolChunk<T> poolChunk) {
        poolChunk.parent = this;
        if (this.head == null) {
            this.head = poolChunk;
            poolChunk.prev = null;
            poolChunk.next = null;
        } else {
            poolChunk.prev = null;
            poolChunk.next = this.head;
            this.head.prev = poolChunk;
            this.head = poolChunk;
        }
    }

    private void remove(PoolChunk<T> poolChunk) {
        if (poolChunk == this.head) {
            this.head = poolChunk.next;
            if (this.head != null) {
                this.head.prev = null;
            }
        } else {
            PoolChunk poolChunk2;
            poolChunk.prev.next = poolChunk2 = poolChunk.next;
            if (poolChunk2 != null) {
                poolChunk2.prev = poolChunk.prev;
            }
        }
    }

    @Override
    public int minUsage() {
        return PoolChunkList.minUsage0(this.minUsage);
    }

    @Override
    public int maxUsage() {
        return Math.min(this.maxUsage, 100);
    }

    private static int minUsage0(int n) {
        return Math.max(1, n);
    }

    @Override
    public Iterator<PoolChunkMetric> iterator() {
        this.arena.lock();
        try {
            if (this.head == null) {
                Iterator<PoolChunkMetric> iterator = EMPTY_METRICS;
                return iterator;
            }
            ArrayList<PoolChunk<T>> arrayList = new ArrayList<PoolChunk<T>>();
            Object object = this.head;
            do {
                arrayList.add((PoolChunk<T>)object);
            } while ((object = ((PoolChunk)object).next) != null);
            object = arrayList.iterator();
            return object;
        }
        finally {
            this.arena.unlock();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.arena.lock();
        try {
            if (this.head == null) {
                String string = "none";
                return string;
            }
            PoolChunk<T> poolChunk = this.head;
            while (true) {
                stringBuilder.append(poolChunk);
                poolChunk = poolChunk.next;
                if (poolChunk == null) {
                    break;
                }
                stringBuilder.append(StringUtil.NEWLINE);
            }
        }
        finally {
            this.arena.unlock();
        }
        return stringBuilder.toString();
    }

    void destroy(PoolArena<T> poolArena) {
        PoolChunk<T> poolChunk = this.head;
        while (poolChunk != null) {
            poolArena.destroyChunk(poolChunk);
            poolChunk = poolChunk.next;
        }
        this.head = null;
    }
}

