/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer.search;

import pro.gravit.repackage.io.netty.buffer.search.AbstractSearchProcessorFactory;
import pro.gravit.repackage.io.netty.buffer.search.BitapSearchProcessorFactory$Processor;

public class BitapSearchProcessorFactory
extends AbstractSearchProcessorFactory {
    private final long[] bitMasks = new long[256];
    private final long successBit;

    BitapSearchProcessorFactory(byte[] byArray) {
        if (byArray.length > 64) {
            throw new IllegalArgumentException("Maximum supported search pattern length is 64, got " + byArray.length);
        }
        long l = 1L;
        for (byte by : byArray) {
            int n = by & 0xFF;
            this.bitMasks[n] = this.bitMasks[n] | l;
            l <<= 1;
        }
        this.successBit = 1L << byArray.length - 1;
    }

    @Override
    public BitapSearchProcessorFactory$Processor newSearchProcessor() {
        return new BitapSearchProcessorFactory$Processor(this.bitMasks, this.successBit);
    }
}

